/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views;

import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;

public class WorkaroundForIssue1353 {
    private static Shell shell;
    private static final PartListener listener;

    static {
        DEBUG.OFF();
        listener = new PartListener();
    }

    public static void showShell() {
        if (shell != null) {
            WorkbenchHelper.asyncRun(() -> {
                DEBUG.OUT((Object)"Showing shell");
                WorkaroundForIssue1353.getShell().open();
                WorkaroundForIssue1353.getShell().setVisible(false);
            });
        }
    }

    private static Shell getShell() {
        if (shell == null || shell.isDisposed() || shell.getShell() == null || shell.getShell().isDisposed()) {
            WorkaroundForIssue1353.createShell();
        }
        return shell;
    }

    private static void createShell() {
        DEBUG.OUT((Object)"Shell created");
        shell = new Shell(WorkbenchHelper.getShell(), 65536);
        shell.setSize(5, 5);
        shell.setAlpha(0);
        shell.setBackground(IGamaColors.BLACK.color());
    }

    public static void install() {
        if (!PlatformHelper.isMac() || shell != null) {
            return;
        }
        DEBUG.OUT((Object)(WorkaroundForIssue1353.class.getSimpleName() + " installed"));
        WorkbenchHelper.run(() -> {
            WorkaroundForIssue1353.createShell();
            WorkbenchHelper.getPage().addPartListener((IPartListener2)listener);
        });
    }

    public static boolean isInstalled() {
        return shell != null;
    }

    public static void remove() {
        if (shell == null) {
            return;
        }
        WorkbenchHelper.run(() -> {
            shell.dispose();
            shell = null;
            WorkbenchHelper.getPage().removePartListener((IPartListener2)listener);
        });
        DEBUG.OUT((Object)(WorkaroundForIssue1353.class.getSimpleName() + " removed"));
    }

    public static class PartListener
    implements IPartListener2 {
        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            WorkaroundForIssue1353.showShell();
        }
    }
}

