/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.gaml.expressions.IExpression;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.parameters.EditorFactory;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class EditorsDialog
extends Dialog {
    private final IMap<String, Object> values = GamaMapFactory.createUnordered();
    private final List<IParameter> parameters;
    private final String title;
    private final GamaFont font;
    private final IScope scope;
    private Color color;

    public EditorsDialog(IScope iScope, Shell shell, List<IParameter> list, String string, GamaFont gamaFont, GamaColor gamaColor, Boolean bl) {
        super(shell);
        this.scope = iScope;
        this.title = string;
        this.font = gamaFont;
        this.color = gamaColor == null ? null : GamaColors.toSwtColor((java.awt.Color)gamaColor);
        this.setShellStyle(bl != false ? 16436 : 16388);
        this.parameters = list;
        list.forEach(iParameter -> this.values.put((Object)iParameter.getName(), iParameter.getInitialValue(iScope)));
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        EditorsGroup editorsGroup = new EditorsGroup(composite2);
        Label label = new Label((Composite)editorsGroup, 0);
        label.setText(this.title);
        GridData gridData = new GridData(4, 4, true, true, 3, 1);
        label.setLayoutData((Object)gridData);
        if (this.font != null) {
            label.setFont(new Font((Device)WorkbenchHelper.getDisplay(), this.font.getFontName(), this.font.getSize(), this.font.getStyle()));
        }
        Label label2 = new Label((Composite)editorsGroup, 0);
        gridData = new GridData(4, 4, true, true, 3, 1);
        gridData.heightHint = 20;
        label2.setLayoutData((Object)gridData);
        if (this.color == null) {
            this.color = composite2.getBackground();
        }
        GamaColors.setBackAndForeground(this.color, GamaColors.getTextColorForBackground(this.color).color(), new Control[]{composite, composite2, editorsGroup, label, label2});
        this.parameters.forEach(iParameter -> {
            EditorListener<Object> editorListener = object -> {
                iParameter.setValue(this.scope, object);
                this.values.put((Object)iParameter.getName(), object);
            };
            if (iParameter.isExpression()) {
                EditorFactory.createExpression(this.scope, editorsGroup, iParameter.getName(), (IExpression)iParameter.value(this.scope), editorListener, iParameter.getType());
            } else {
                EditorFactory.create(this.scope, editorsGroup, iParameter, editorListener, false);
            }
        });
        editorsGroup.layout();
        return editorsGroup;
    }

    protected Control createButtonBar(Composite composite) {
        Control control = super.createButtonBar(composite);
        GamaColors.setBackAndForeground(this.color, GamaColors.getTextColorForBackground(this.color).color(), control);
        return control;
    }

    protected boolean isResizable() {
        return true;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }
}

