/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.util.GamaFont;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.resources.GamaFonts;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;

public class FontEditor
extends AbstractEditor<GamaFont> {
    private FlatButton edit;

    FontEditor(IAgent iAgent, IParameter iParameter, EditorListener<GamaFont> editorListener) {
        super(iAgent, iParameter, editorListener);
    }

    @Override
    public Control createCustomParameterControl(Composite composite) {
        this.edit = FlatButton.menu(composite, null, "").light().small();
        this.edit.addSelectionListener(this);
        this.displayParameterValue();
        return this.edit;
    }

    @Override
    protected void displayParameterValue() {
        this.internalModification = true;
        GamaFont gamaFont = this.currentValue != null ? (GamaFont)this.currentValue : this.toGamaFont(WorkbenchHelper.getDisplay().getSystemFont().getFontData()[0]);
        this.edit.setText(this.currentValue == null ? "Default" : gamaFont.toString());
        this.edit.setFont(GamaFonts.getFont(gamaFont));
        this.internalModification = false;
    }

    private GamaFont toGamaFont(FontData fontData) {
        return new GamaFont(fontData.getName(), fontData.getStyle(), fontData.getHeight());
    }

    @Override
    protected int[] getToolItems() {
        return new int[]{2, 6};
    }

    @Override
    public void widgetSelected(SelectionEvent selectionEvent) {
        FontData fontData;
        FontDialog fontDialog = new FontDialog(WorkbenchHelper.getShell());
        fontDialog.setEffectsVisible(false);
        if (this.currentValue != null) {
            fontData = GamaFonts.getFont((GamaFont)this.currentValue);
            fontDialog.setFontList(fontData.getFontData());
        }
        if ((fontData = fontDialog.open()) != null) {
            this.modifyAndDisplayValue(this.toGamaFont(fontData));
        }
    }
}

