/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.InputParameter;
import gama.core.kernel.experiment.TextStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.parameters.EditorLabel;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.WebHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class TextDisplayer
extends AbstractEditor<TextStatement> {
    FormText form;
    StyledText text;
    TextStatement statement;
    final Color back;
    final Color front;
    final Font font;
    final boolean isXML;

    public TextDisplayer(IScope iScope, TextStatement textStatement) {
        super(iScope.getAgent(), (IParameter)new InputParameter(textStatement.getName(), null), null);
        this.isXML = textStatement.isXML(iScope);
        this.statement = textStatement;
        GamaColor gamaColor = textStatement.getColor(iScope);
        java.awt.Color color = textStatement.getBackground(iScope);
        this.front = gamaColor == null ? null : GamaColors.toSwtColor((java.awt.Color)gamaColor);
        this.back = color == null ? null : GamaColors.toSwtColor(color);
        GamaFont gamaFont = textStatement.getFont(iScope);
        this.font = gamaFont == null ? null : new Font((Device)WorkbenchHelper.getDisplay(), gamaFont.getFontName(), gamaFont.getSize(), gamaFont.getStyle());
    }

    @Override
    public void createControls(EditorsGroup editorsGroup) {
        this.parent = editorsGroup;
        this.internalModification = true;
        this.editorLabel = this.createEditorLabel();
        this.createValueComposite();
        this.editorControl = this.createEditorControl();
        this.editorToolbar = null;
        this.internalModification = false;
        editorsGroup.requestLayout();
    }

    @Override
    Composite createValueComposite() {
        this.composite = new Composite((Composite)this.parent, 0);
        GamaColors.setBackground(this.parent.getBackground(), new Control[]{this.composite});
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 100;
        gridData.horizontalSpan = 3;
        this.composite.setLayoutData((Object)gridData);
        FillLayout fillLayout = new FillLayout();
        this.composite.setLayout((Layout)fillLayout);
        return this.composite;
    }

    @Override
    protected Control createCustomParameterControl(Composite composite) throws GamaRuntimeException {
        if (this.isXML) {
            this.form = new FormText(composite, 0);
            this.form.setFont(this.font);
            this.form.marginHeight = 4;
            this.form.marginWidth = 4;
            this.form.setText("<form>" + this.statement.getText(this.getScope()) + "</form>", true, true);
            if (this.back != null) {
                if (this.front != null) {
                    GamaColors.setBackAndForeground(this.back, this.front, new Control[]{this.form});
                } else {
                    GamaColors.setBackground(this.back, new Control[]{this.form});
                }
            } else if (this.front != null) {
                GamaColors.setForeground(this.front, new Control[]{this.form});
            }
            this.form.addHyperlinkListener(new IHyperlinkListener(){

                public void linkExited(HyperlinkEvent hyperlinkEvent) {
                }

                public void linkEntered(HyperlinkEvent hyperlinkEvent) {
                }

                public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                    WebHelper.openPage(hyperlinkEvent.getHref().toString());
                }
            });
            this.form.requestLayout();
            composite.requestLayout();
            return this.form;
        }
        this.text = new StyledText(composite, 72);
        this.text.setJustify(true);
        this.text.setMargins(4, 4, 4, 4);
        this.text.setText(this.statement.getText(this.getScope()));
        if (this.font != null) {
            int n = this.text.getCharCount();
            StyleRange[] styleRangeArray = new StyleRange[]{new StyleRange()};
            styleRangeArray[0].start = 0;
            styleRangeArray[0].length = n;
            styleRangeArray[0].font = this.font;
            styleRangeArray[0].foreground = this.front;
            styleRangeArray[0].background = this.back;
            this.text.replaceStyleRanges(styleRangeArray[0].start, styleRangeArray[0].length, styleRangeArray);
        } else if (this.front != null || this.back != null) {
            int n = this.text.getCharCount();
            StyleRange[] styleRangeArray = new StyleRange[]{new StyleRange()};
            styleRangeArray[0].start = 0;
            styleRangeArray[0].length = n;
            styleRangeArray[0].foreground = this.front;
            styleRangeArray[0].background = this.back;
            this.text.replaceStyleRanges(styleRangeArray[0].start, styleRangeArray[0].length, styleRangeArray);
        }
        if (this.back != null) {
            if (this.front != null) {
                GamaColors.setBackAndForeground(this.back, this.front, new Control[]{this.text});
            } else {
                GamaColors.setBackground(this.back, new Control[]{this.text});
            }
        } else if (this.front != null) {
            GamaColors.setForeground(this.front, new Control[]{this.text});
        }
        composite.requestLayout();
        return this.text;
    }

    @Override
    EditorLabel createEditorLabel() {
        return null;
    }

    @Override
    Color getEditorControlBackground() {
        return this.back == null ? super.getEditorControlBackground() : this.back;
    }

    @Override
    Color getEditorControlForeground() {
        return this.front == null ? super.getEditorControlForeground() : this.front;
    }

    @Override
    protected int[] getToolItems() {
        return new int[0];
    }

    @Override
    protected void displayParameterValue() {
    }
}

