/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views.toolbar;

import gama.core.common.preferences.GamaPreferences;
import gama.core.outputs.IOutput;
import gama.core.runtime.GAMA;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchSite;

public interface IToolbarDecoratedView {
    public static final ICameraHelper NULL_CAMERA = new ICameraHelper(){};

    public IWorkbenchSite getSite();

    public void createToolItems(GamaToolbar2 var1);

    default public void addStateListener(StateListener stateListener) {
    }

    public static interface CSVExportable
    extends IToolbarDecoratedView {
        public void saveAsCSV();
    }

    public static interface Colorizable
    extends IToolbarDecoratedView {
        public String[] getColorLabels();

        public GamaColors.GamaUIColor getColor(int var1);

        public void setColor(int var1, GamaColors.GamaUIColor var2);
    }

    public static interface Expandable
    extends IToolbarDecoratedView {
        public void expandAll();

        public void collapseAll();
    }

    public static interface ICameraHelper {
        default public Collection<String> getCameraNames() {
            return Collections.EMPTY_LIST;
        }

        default public void setCameraName(String string) {
        }

        default public String getCameraName() {
            return (String)GamaPreferences.Displays.OPENGL_DEFAULT_CAM.getValue();
        }

        default public boolean isCameraLocked() {
            return false;
        }

        default public boolean isCameraDynamic() {
            return false;
        }

        default public void toggleCameraLock() {
        }

        default public String getCameraDefinition() {
            return "";
        }
    }

    public static interface LogExportable
    extends IToolbarDecoratedView {
        default public void saveAsLog() {
            String string = this.getContents();
            FileDialog fileDialog = new FileDialog(WorkbenchHelper.getShell(), 8192);
            fileDialog.setText("Choose a destination file");
            fileDialog.setFilterExtensions(new String[]{"*.log"});
            if (GAMA.getExperiment() != null && GAMA.getExperiment().getAgent() != null) {
                fileDialog.setFilterPath(GAMA.getExperiment().getAgent().getProjectPath());
            } else {
                fileDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
            }
            String string2 = fileDialog.open();
            if (string2 == null) {
                return;
            }
            try {
                Files.writeString(Path.of(string2, new String[0]), (CharSequence)string, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }

        public String getContents();
    }

    public static interface Pausable
    extends IToolbarDecoratedView {
        public void pauseChanged();

        public IOutput getOutput();

        default public boolean largePauseIcon() {
            return false;
        }
    }

    public static interface Sizable
    extends IToolbarDecoratedView {
        public Control getSizableFontControl();
    }

    public static interface StateListener {
        public void updateToReflectState();
    }

    public static interface Zoomable
    extends IToolbarDecoratedView {
        public void zoomIn();

        public void zoomOut();

        public void zoomFit();

        public void toggleLock();

        public boolean isCameraLocked();

        public boolean isCameraDynamic();

        public Control[] getZoomableControls();

        public boolean zoomWhenScrolling();

        default public ICameraHelper getCameraHelper() {
            return NULL_CAMERA;
        }

        default public boolean hasCameras() {
            return false;
        }

        default public boolean largeZoomIcons() {
            return false;
        }
    }
}

