/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views.toolbar;

import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.util.Collection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;

public class ZoomController {
    final boolean includingScrolling;
    final IToolbarDecoratedView.Zoomable view;
    ToolItem cameraLocked;

    public ZoomController(IToolbarDecoratedView.Zoomable zoomable) {
        this.view = zoomable;
        this.includingScrolling = zoomable.zoomWhenScrolling();
    }

    public void install(GamaToolbar2 gamaToolbar2) {
        final GestureListener gestureListener = gestureEvent -> {
            if (gestureEvent.detail == 32) {
                if (gestureEvent.magnification > 1.0) {
                    this.view.zoomIn();
                } else if (gestureEvent.magnification < 1.0) {
                    this.view.zoomOut();
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (mouseEvent.button == 1) {
                    ZoomController.this.view.zoomFit();
                }
            }
        };
        MouseWheelListener mouseWheelListener = mouseEvent -> {
            if (mouseEvent.count < 0) {
                this.view.zoomOut();
            } else {
                this.view.zoomIn();
            }
        };
        gamaToolbar2.addControlListener((ControlListener)new ControlAdapter((MouseListener)mouseAdapter, mouseWheelListener, gamaToolbar2){
            private final /* synthetic */ MouseListener val$ml;
            private final /* synthetic */ MouseWheelListener val$mw;
            private final /* synthetic */ GamaToolbar2 val$tb;
            {
                this.val$ml = mouseListener;
                this.val$mw = mouseWheelListener;
                this.val$tb = gamaToolbar2;
            }

            public void controlResized(ControlEvent controlEvent) {
                Control[] controlArray;
                Control[] controlArray2 = controlArray = ZoomController.this.view.getZoomableControls();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray2[n2];
                    if (control != null) {
                        control.addGestureListener(gestureListener);
                        control.addMouseListener(this.val$ml);
                        if (ZoomController.this.includingScrolling) {
                            control.addMouseWheelListener(this.val$mw);
                        }
                    }
                    ++n2;
                }
                if (ZoomController.this.cameraLocked != null) {
                    boolean bl = ZoomController.this.view.isCameraLocked();
                    n2 = ZoomController.this.view.isCameraDynamic() ? 1 : 0;
                    this.val$tb.setSelection(ZoomController.this.cameraLocked, bl || n2 != 0);
                    ZoomController.this.cameraLocked.setEnabled(n2 == 0);
                }
                this.val$tb.removeControlListener((ControlListener)this);
            }
        });
        gamaToolbar2.button(this.view.largeZoomIcons() ? "display/zoom.in" : "toolbar/font.increase", "Zoom in", "Zoom in", selectionEvent -> this.view.zoomIn(), 131072);
        gamaToolbar2.button(this.view.largeZoomIcons() ? "display/zoom.fit" : "toolbar/font.reset", "Zoom fit", "Zoom to fit view", selectionEvent -> this.view.zoomFit(), 131072);
        gamaToolbar2.button(this.view.largeZoomIcons() ? "display/zoom.out" : "toolbar/font.decrease", "Zoom out", "Zoom out", selectionEvent -> this.view.zoomOut(), 131072);
        gamaToolbar2.sep(131072);
        if (this.view.hasCameras()) {
            gamaToolbar2.menu("display/camera.full", "", "Choose a camera...", selectionEvent -> {
                GamaMenu gamaMenu = new GamaMenu(){

                    @Override
                    protected void fillMenu() {
                        Collection<String> collection = ZoomController.this.view.getCameraHelper().getCameraNames();
                        for (final String string : collection) {
                            this.action(string, (SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent selectionEvent) {
                                    (this).ZoomController.this.view.getCameraHelper().setCameraName(string);
                                    (this).ZoomController.this.cameraLocked.setSelection((this).ZoomController.this.view.isCameraLocked());
                                }
                            }, string.equals(ZoomController.this.view.getCameraHelper().getCameraName()) ? GamaIcon.named("display/camera.full").image() : GamaIcon.named("display/camera.empty").image());
                        }
                        this.sep();
                        this.action("Copy current camera", (SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                String string = (this).ZoomController.this.view.getCameraHelper().getCameraDefinition();
                                WorkbenchHelper.copy(string);
                            }
                        }, GamaIcon.named("generic/menu.paste").image());
                    }
                };
                gamaMenu.open((Control)gamaToolbar2.getToolbar(131072), selectionEvent, gamaToolbar2.getToolbar((int)131072).getSize().y, 96);
            }, 131072);
            this.cameraLocked = gamaToolbar2.check("display/camera.lock", "Lock/unlock", "Lock/unlock view", selectionEvent -> this.view.toggleLock(), 131072);
        }
    }
}

