/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.controls.text;

import gama.core.util.GamaFont;
import gama.ui.shared.controls.text.IXmlFontUser;
import gama.ui.shared.controls.text.XmlHyperlinkSegment;
import gama.ui.shared.controls.text.XmlParagraphSegment;
import gama.ui.shared.controls.text.XmlTextSegment;
import gama.ui.shared.resources.GamaFonts;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.SelectionData;

public class XmlParagraph
implements IXmlFontUser {
    public static final String[] PROTOCOLS = new String[]{"http://", "https://", "ftp://"};
    private List<XmlParagraphSegment> segments;
    private boolean addVerticalSpace = true;
    private final GamaFont font;

    public XmlParagraph(boolean bl, GamaFont gamaFont) {
        this.font = gamaFont;
        this.addVerticalSpace = bl;
    }

    @Override
    public Font getFont() {
        return GamaFonts.getFont(this.font);
    }

    public int getIndent() {
        return 0;
    }

    public boolean getAddVerticalSpace() {
        return this.addVerticalSpace;
    }

    public XmlParagraphSegment[] getSegments() {
        if (this.segments == null) {
            return new XmlParagraphSegment[0];
        }
        return this.segments.toArray(new XmlParagraphSegment[this.segments.size()]);
    }

    public void addSegment(XmlParagraphSegment xmlParagraphSegment) {
        if (this.segments == null) {
            this.segments = new ArrayList<XmlParagraphSegment>();
        }
        this.segments.add(xmlParagraphSegment);
    }

    public void parseRegularText(String string, boolean bl, boolean bl2, HyperlinkSettings hyperlinkSettings, boolean bl3, boolean bl4) {
        if (string.isEmpty()) {
            return;
        }
        if (bl) {
            int n = this.findUrl(string, 0);
            if (n == -1) {
                this.addSegment(new XmlTextSegment(string, bl3, bl4, bl2, this.font));
            } else {
                int n2 = 0;
                while (n != -1) {
                    this.addSegment(new XmlTextSegment(string.substring(n2, n), bl3, bl4, bl2, this.font));
                    boolean bl5 = false;
                    n2 = n;
                    while (n2 < string.length()) {
                        char c = string.charAt(n2);
                        if (Character.isSpaceChar(c)) {
                            this.addHyperlinkSegment(string.substring(n, n2), hyperlinkSettings, bl3, bl4);
                            bl5 = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl5) {
                        this.addHyperlinkSegment(string.substring(n), hyperlinkSettings, bl3, bl4);
                        break;
                    }
                    n = this.findUrl(string, n2);
                }
                if (n2 < string.length()) {
                    this.addSegment(new XmlTextSegment(string.substring(n2), bl3, bl4, bl2, this.font));
                }
            }
        } else {
            this.addSegment(new XmlTextSegment(string, bl3, bl4, bl2, this.font));
        }
    }

    private int findUrl(String string, int n) {
        int[] nArray = new int[PROTOCOLS.length];
        int n2 = 0;
        while (n2 < PROTOCOLS.length) {
            nArray[n2] = string.indexOf(PROTOCOLS[n2], n);
            ++n2;
        }
        Arrays.sort(nArray);
        n2 = 0;
        while (n2 < PROTOCOLS.length) {
            if (nArray[n2] != -1) {
                return nArray[n2];
            }
            ++n2;
        }
        return -1;
    }

    private void addHyperlinkSegment(String string, HyperlinkSettings hyperlinkSettings, boolean bl, boolean bl2) {
        XmlHyperlinkSegment xmlHyperlinkSegment = new XmlHyperlinkSegment(string, hyperlinkSettings, bl, bl2, this.font);
        xmlHyperlinkSegment.setWordWrapAllowed(false);
        xmlHyperlinkSegment.setHref(string);
        this.addSegment(xmlHyperlinkSegment);
    }

    protected void computeRowHeights(GC gC, int n, Locator locator, int n2) {
        XmlParagraphSegment xmlParagraphSegment;
        ArrayList arrayList;
        gC.setFont(this.getFont());
        Locator locator2 = locator.create();
        locator2.heights = arrayList = new ArrayList();
        locator2.rowCounter = 0;
        XmlParagraphSegment[] xmlParagraphSegmentArray = this.getSegments();
        int n3 = xmlParagraphSegmentArray.length;
        int n4 = 0;
        while (n4 < n3) {
            xmlParagraphSegment = xmlParagraphSegmentArray[n4];
            xmlParagraphSegment.advanceLocator(gC, n, locator2, true);
            ++n4;
        }
        if (locator2.rowHeight == 0) {
            xmlParagraphSegment = gC.getFontMetrics();
            locator2.rowHeight = xmlParagraphSegment.getHeight();
        }
        locator2.collectHeights();
        locator.heights = arrayList;
        locator.rowCounter = 0;
    }

    public void layout(GC gC, int n, Locator locator, int n2, IHyperlinkSegment iHyperlinkSegment) {
        gC.setFont(this.getFont());
        XmlParagraphSegment[] xmlParagraphSegmentArray = this.getSegments();
        if (xmlParagraphSegmentArray.length > 0) {
            if (locator.heights == null) {
                this.computeRowHeights(gC, n, locator, n2);
            }
            XmlParagraphSegment[] xmlParagraphSegmentArray2 = xmlParagraphSegmentArray;
            int n3 = xmlParagraphSegmentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                XmlParagraphSegment xmlParagraphSegment;
                XmlParagraphSegment xmlParagraphSegment2 = xmlParagraphSegmentArray2[n4];
                boolean bl = false;
                if (iHyperlinkSegment instanceof XmlParagraphSegment && xmlParagraphSegment2.equals(xmlParagraphSegment = (XmlParagraphSegment)iHyperlinkSegment)) {
                    bl = true;
                }
                xmlParagraphSegment2.layout(gC, n, locator, bl);
                ++n4;
            }
            locator.heights = null;
            locator.y += locator.rowHeight;
        } else {
            locator.y += n2;
        }
    }

    public void paint(GC gC, Rectangle rectangle, IHyperlinkSegment iHyperlinkSegment, SelectionData selectionData) {
        gC.setFont(this.getFont());
        XmlParagraphSegment[] xmlParagraphSegmentArray = this.getSegments();
        int n = xmlParagraphSegmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlParagraphSegment xmlParagraphSegment = xmlParagraphSegmentArray[n2];
            if (xmlParagraphSegment.intersects(rectangle)) {
                XmlParagraphSegment xmlParagraphSegment2;
                boolean bl = false;
                if (iHyperlinkSegment instanceof XmlParagraphSegment && xmlParagraphSegment.equals(xmlParagraphSegment2 = (XmlParagraphSegment)iHyperlinkSegment)) {
                    bl = true;
                }
                xmlParagraphSegment.paint(gC, false, bl, selectionData, rectangle);
            }
            ++n2;
        }
    }

    public void computeSelection(GC gC, IHyperlinkSegment iHyperlinkSegment, SelectionData selectionData) {
        XmlParagraphSegment[] xmlParagraphSegmentArray = this.getSegments();
        int n = xmlParagraphSegmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlParagraphSegment xmlParagraphSegment = xmlParagraphSegmentArray[n2];
            xmlParagraphSegment.computeSelection(gC, selectionData);
            ++n2;
        }
    }

    public String getAccessibleText() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        XmlParagraphSegment[] xmlParagraphSegmentArray = this.getSegments();
        int n = xmlParagraphSegmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlParagraphSegment xmlParagraphSegment = xmlParagraphSegmentArray[n2];
            if (xmlParagraphSegment instanceof XmlTextSegment) {
                String string = ((XmlTextSegment)xmlParagraphSegment).getText();
                printWriter.print(string);
            }
            ++n2;
        }
        printWriter.println();
        stringWriter.flush();
        return stringWriter.toString();
    }

    public XmlParagraphSegment findSegmentAt(int n, int n2) {
        if (this.segments != null) {
            for (XmlParagraphSegment xmlParagraphSegment : this.segments) {
                if (!xmlParagraphSegment.contains(n, n2)) continue;
                return xmlParagraphSegment;
            }
        }
        return null;
    }

    public void clearCache(String string) {
        if (this.segments != null) {
            for (XmlParagraphSegment xmlParagraphSegment : this.segments) {
                xmlParagraphSegment.clearCache(string);
            }
        }
    }
}

