/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.controls.text;

import gama.core.util.GamaFont;
import gama.ui.shared.controls.text.IXmlFontUser;
import gama.ui.shared.controls.text.XmlParagraph;
import gama.ui.shared.controls.text.XmlParagraphSegment;
import gama.ui.shared.controls.text.XmlTextModel;
import gama.ui.shared.controls.text.XmlTextSegment;
import gama.ui.shared.resources.GamaFonts;
import java.io.InputStream;
import java.util.EventListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.internal.forms.widgets.IFocusSelectable;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.SelectionData;

public class XmlText
extends Canvas
implements IXmlFontUser {
    public int marginWidth = 0;
    public int marginHeight = 1;
    private boolean hasFocus;
    private boolean paragraphsSeparated = true;
    private final XmlTextModel model;
    private ListenerList<IHyperlinkListener> listeners;
    private IHyperlinkSegment entered;
    private IHyperlinkSegment armed;
    private boolean inSelection = false;
    private SelectionData selData;

    public XmlText(Composite composite, int n, GamaFont gamaFont) {
        super(composite, 0x40040 | n);
        this.setLayout(new XmlTextLayout());
        this.model = new XmlTextModel(gamaFont == null ? GamaFonts.getFont(this.getFont()) : gamaFont);
        this.addDisposeListener(disposeEvent -> this.model.dispose());
        this.addPaintListener(this::paint);
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                XmlText.this.handleMouseClick(mouseEvent, true);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                XmlText.this.handleMouseClick(mouseEvent, false);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
                XmlText.this.handleMouseMove(mouseEvent);
            }

            public void mouseExit(MouseEvent mouseEvent) {
                if (XmlText.this.entered != null) {
                    XmlText.this.exitLink(XmlText.this.entered, mouseEvent.stateMask);
                    XmlText.this.entered = null;
                    XmlText.this.setCursor(null);
                }
            }

            public void mouseHover(MouseEvent mouseEvent) {
                XmlText.this.handleMouseHover(mouseEvent);
            }
        });
        this.addMouseMoveListener(this::handleMouseMove);
    }

    public boolean getFocus() {
        return this.hasFocus;
    }

    public void setParagraphsSeparated(boolean bl) {
        this.paragraphsSeparated = bl;
    }

    public boolean getParagraphsSeparated() {
        return this.paragraphsSeparated;
    }

    public void setText(String string, boolean bl, boolean bl2) {
        this.entered = null;
        if (bl) {
            this.model.parseTaggedText(string, bl2);
        } else {
            this.model.parseRegularText(string, bl2);
        }
        this.layout();
        this.redraw();
    }

    public void setContents(InputStream inputStream, boolean bl) {
        this.entered = null;
        this.model.parseInputStream(inputStream, bl);
        this.layout();
        this.redraw();
    }

    public void setWhitespaceNormalized(boolean bl) {
        this.model.setWhitespaceNormalized(bl);
    }

    public boolean isWhitespaceNormalized() {
        return this.model.isWhitespaceNormalized();
    }

    public HyperlinkSettings getHyperlinkSettings() {
        return this.model.getHyperlinkSettings();
    }

    public void setHyperlinkSettings(HyperlinkSettings hyperlinkSettings) {
        this.model.setHyperlinkSettings(hyperlinkSettings);
    }

    public void addHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add((Object)iHyperlinkListener);
    }

    public void removeHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove((Object)iHyperlinkListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.addTypedListener((EventListener)selectionListener, new int[]{13});
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.removeTypedListener(13, (EventListener)selectionListener);
    }

    public String getSelectionText() {
        this.checkWidget();
        if (this.selData != null) {
            return this.selData.getSelectionText();
        }
        return "";
    }

    public boolean canCopy() {
        return this.selData != null && this.selData.canCopy();
    }

    public void copy() {
        if (!this.canCopy()) {
            return;
        }
        Clipboard clipboard = new Clipboard(this.getDisplay());
        Object[] objectArray = new Object[]{this.getSelectionText()};
        Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance()};
        clipboard.setContents(objectArray, transferArray);
        clipboard.dispose();
    }

    public Object getSelectedLinkHref() {
        IHyperlinkSegment iHyperlinkSegment = this.getSelectedLink();
        return iHyperlinkSegment != null ? iHyperlinkSegment.getHref() : null;
    }

    public String getSelectedLinkText() {
        IHyperlinkSegment iHyperlinkSegment = this.getSelectedLink();
        return iHyperlinkSegment != null ? iHyperlinkSegment.getText() : null;
    }

    private IHyperlinkSegment getSelectedLink() {
        IFocusSelectable iFocusSelectable = this.model.getSelectedSegment();
        if (iFocusSelectable instanceof IHyperlinkSegment) {
            return (IHyperlinkSegment)iFocusSelectable;
        }
        return null;
    }

    private void startSelection(MouseEvent mouseEvent) {
        this.inSelection = true;
        this.selData = new SelectionData(mouseEvent);
        this.redraw();
    }

    private void endSelection(MouseEvent mouseEvent) {
        this.inSelection = false;
        if (this.selData != null) {
            if (!this.selData.isEnclosed()) {
                this.selData = null;
            } else {
                this.computeSelection();
            }
        }
        this.notifySelectionChanged();
    }

    private void computeSelection() {
        GC gC = new GC((Drawable)this);
        XmlParagraph[] xmlParagraphArray = this.model.getParagraphs();
        IHyperlinkSegment iHyperlinkSegment = this.getSelectedLink();
        if (this.getDisplay().getFocusControl() != this) {
            iHyperlinkSegment = null;
        }
        XmlParagraph[] xmlParagraphArray2 = xmlParagraphArray;
        int n = xmlParagraphArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlParagraph xmlParagraph = xmlParagraphArray2[n2];
            xmlParagraph.computeSelection(gC, iHyperlinkSegment, this.selData);
            ++n2;
        }
        gC.dispose();
    }

    void clearSelection() {
        this.selData = null;
        if (!this.isDisposed()) {
            this.redraw();
            this.notifySelectionChanged();
        }
    }

    private void notifySelectionChanged() {
        Event event = new Event();
        event.widget = this;
        event.display = this.getDisplay();
        event.type = 13;
        this.notifyListeners(13, event);
        if (!this.isDisposed()) {
            this.getAccessible().selectionChanged();
        }
    }

    private void handleDrag(MouseEvent mouseEvent) {
        if (this.selData != null) {
            ScrolledComposite scrolledComposite = FormUtil.getScrolledComposite((Control)this);
            if (scrolledComposite != null) {
                FormUtil.ensureVisible((ScrolledComposite)scrolledComposite, (Control)this, (MouseEvent)mouseEvent);
            }
            this.selData.update(mouseEvent);
            this.redraw();
        }
    }

    private void handleMouseClick(MouseEvent mouseEvent, boolean bl) {
        if (bl) {
            IHyperlinkSegment iHyperlinkSegment = this.model.findHyperlinkAt(mouseEvent.x, mouseEvent.y);
            if (iHyperlinkSegment != null) {
                if (this.getDisplay().getFocusControl() != this) {
                    this.setFocus();
                }
                this.model.selectLink(iHyperlinkSegment);
                this.enterLink(iHyperlinkSegment, mouseEvent.stateMask);
            }
            if (mouseEvent.button == 1) {
                this.startSelection(mouseEvent);
                this.armed = iHyperlinkSegment;
            }
        } else if (mouseEvent.button == 1) {
            this.endSelection(mouseEvent);
            if (this.isDisposed()) {
                return;
            }
            IHyperlinkSegment iHyperlinkSegment = this.model.findHyperlinkAt(mouseEvent.x, mouseEvent.y);
            if (iHyperlinkSegment != null && this.armed == iHyperlinkSegment && this.selData == null) {
                this.activateLink(iHyperlinkSegment, mouseEvent.stateMask);
                this.armed = null;
            }
        }
    }

    private void handleMouseHover(MouseEvent mouseEvent) {
    }

    private void updateTooltipText(XmlParagraphSegment xmlParagraphSegment) {
        String string;
        String string2 = null;
        if (xmlParagraphSegment != null) {
            string2 = xmlParagraphSegment.getTooltipText();
        }
        if ((string = this.getToolTipText()) != null == (string2 == null)) {
            this.setToolTipText(string2);
        }
    }

    private void handleMouseMove(MouseEvent mouseEvent) {
        if (this.inSelection) {
            this.handleDrag(mouseEvent);
            return;
        }
        XmlParagraphSegment xmlParagraphSegment = this.model.findSegmentAt(mouseEvent.x, mouseEvent.y);
        this.updateTooltipText(xmlParagraphSegment);
        if (xmlParagraphSegment == null) {
            if (this.entered != null) {
                this.exitLink(this.entered, mouseEvent.stateMask);
                this.entered = null;
            }
            this.setCursor(null);
        } else if (xmlParagraphSegment instanceof IHyperlinkSegment) {
            IHyperlinkSegment iHyperlinkSegment = (IHyperlinkSegment)xmlParagraphSegment;
            if (this.entered != null && iHyperlinkSegment != this.entered) {
                this.exitLink(this.entered, mouseEvent.stateMask);
                this.entered = null;
            }
            if (this.entered == null) {
                this.entered = iHyperlinkSegment;
                this.enterLink(iHyperlinkSegment, mouseEvent.stateMask);
                this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
            }
        } else {
            if (this.entered != null) {
                this.exitLink(this.entered, mouseEvent.stateMask);
                this.entered = null;
            }
            if (xmlParagraphSegment instanceof XmlTextSegment) {
                this.setCursor(this.model.getHyperlinkSettings().getTextCursor());
            } else {
                this.setCursor(null);
            }
        }
    }

    private void enterLink(IHyperlinkSegment iHyperlinkSegment, int n) {
        if (iHyperlinkSegment == null || this.listeners == null) {
            return;
        }
        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent((Widget)this, (Object)iHyperlinkSegment.getHref(), iHyperlinkSegment.getText(), n);
        for (IHyperlinkListener iHyperlinkListener : this.listeners) {
            iHyperlinkListener.linkEntered(hyperlinkEvent);
        }
    }

    private void exitLink(IHyperlinkSegment iHyperlinkSegment, int n) {
        if (iHyperlinkSegment == null || this.listeners == null) {
            return;
        }
        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent((Widget)this, (Object)iHyperlinkSegment.getHref(), iHyperlinkSegment.getText(), n);
        for (IHyperlinkListener iHyperlinkListener : this.listeners) {
            iHyperlinkListener.linkExited(hyperlinkEvent);
        }
    }

    private void activateLink(IHyperlinkSegment iHyperlinkSegment, int n) {
        this.setCursor(this.model.getHyperlinkSettings().getBusyCursor());
        if (this.listeners != null) {
            int n2 = this.listeners.size();
            HyperlinkEvent hyperlinkEvent = new HyperlinkEvent((Widget)this, (Object)iHyperlinkSegment.getHref(), iHyperlinkSegment.getText(), n);
            Object[] objectArray = this.listeners.getListeners();
            int n3 = 0;
            while (n3 < n2) {
                IHyperlinkListener iHyperlinkListener = (IHyperlinkListener)objectArray[n3];
                iHyperlinkListener.linkActivated(hyperlinkEvent);
                ++n3;
            }
        }
        if (!this.isDisposed() && this.model.linkExists(iHyperlinkSegment)) {
            this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
        }
    }

    private void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        gC.setFont(this.getFont());
        gC.setForeground(this.getForeground());
        gC.setBackground(this.getBackground());
        this.repaint(gC, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
    }

    private void repaint(GC gC, int n, int n2, int n3, int n4) {
        Image image = new Image((Device)this.getDisplay(), n3, n4);
        GC gC2 = new GC((Drawable)image, gC.getStyle());
        gC2.setForeground(this.getForeground());
        gC2.setBackground(this.getBackground());
        gC2.setFont(this.getFont());
        gC2.fillRectangle(0, 0, n3, n4);
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        XmlParagraph[] xmlParagraphArray = this.model.getParagraphs();
        IHyperlinkSegment iHyperlinkSegment = this.getSelectedLink();
        if (this.getDisplay().getFocusControl() != this) {
            iHyperlinkSegment = null;
        }
        XmlParagraph[] xmlParagraphArray2 = xmlParagraphArray;
        int n5 = xmlParagraphArray.length;
        int n6 = 0;
        while (n6 < n5) {
            XmlParagraph xmlParagraph = xmlParagraphArray2[n6];
            xmlParagraph.paint(gC2, rectangle, iHyperlinkSegment, this.selData);
            ++n6;
        }
        gC2.dispose();
        gC.drawImage(image, n, n2);
        image.dispose();
    }

    private int getParagraphSpacing(int n) {
        return n / 2;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        XmlTextLayout xmlTextLayout = (XmlTextLayout)this.getLayout();
        Point point = n == -1 || n2 == -1 ? xmlTextLayout.computeSize((Composite)this, n, n2, bl) : new Point(n, n2);
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.redraw();
    }

    private class XmlTextLayout
    extends Layout
    implements ILayoutExtension {
        public int computeMaximumWidth(Composite composite, boolean bl) {
            return this.computeSize((Composite)composite, (int)-1, (int)-1, (boolean)bl).x;
        }

        public int computeMinimumWidth(Composite composite, boolean bl) {
            return this.computeSize((Composite)composite, (int)5, (int)-1, (boolean)true).x;
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            int n3 = n;
            if (n3 != -1) {
                n3 -= XmlText.this.marginWidth * 2;
            }
            Point point = this.computeTextSize(n3);
            int n4 = point.x + 2 * XmlText.this.marginWidth;
            int n5 = point.y + 2 * XmlText.this.marginHeight;
            return new Point(n4, n5);
        }

        private Point computeTextSize(int n) {
            XmlParagraph[] xmlParagraphArray = XmlText.this.model.getParagraphs();
            GC gC = new GC((Drawable)XmlText.this);
            gC.setFont(XmlText.this.getFont());
            Locator locator = new Locator();
            int n2 = n != -1 ? n : 0;
            FontMetrics fontMetrics = gC.getFontMetrics();
            int n3 = fontMetrics.getHeight();
            boolean bl = false;
            int n4 = 0;
            while (n4 < xmlParagraphArray.length) {
                XmlParagraph xmlParagraph = xmlParagraphArray[n4];
                if (n4 > 0 && XmlText.this.getParagraphsSeparated() && xmlParagraph.getAddVerticalSpace()) {
                    locator.y += XmlText.this.getParagraphSpacing(n3);
                }
                locator.rowHeight = 0;
                locator.indent = xmlParagraph.getIndent();
                locator.x = xmlParagraph.getIndent();
                XmlParagraphSegment[] xmlParagraphSegmentArray = xmlParagraph.getSegments();
                if (xmlParagraphSegmentArray.length > 0) {
                    bl = false;
                    int n5 = 0;
                    XmlParagraphSegment[] xmlParagraphSegmentArray2 = xmlParagraphSegmentArray;
                    int n6 = xmlParagraphSegmentArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        XmlParagraphSegment xmlParagraphSegment = xmlParagraphSegmentArray2[n7];
                        xmlParagraphSegment.advanceLocator(gC, n, locator, false);
                        if (n != -1) {
                            n2 = Math.max(n2, locator.width);
                        } else {
                            n5 = Math.max(n5, locator.width);
                        }
                        if (xmlParagraphSegment instanceof IFocusSelectable) {
                            bl = true;
                        }
                        ++n7;
                    }
                    if (n == -1) {
                        n2 = Math.max(n2, n5);
                    }
                    locator.y += locator.rowHeight;
                } else {
                    locator.y += n3;
                }
                ++n4;
            }
            gC.dispose();
            if (bl) {
                ++locator.y;
            }
            return new Point(n2, locator.y);
        }

        protected void layout(Composite composite, boolean bl) {
            XmlText.this.selData = null;
            Rectangle rectangle = composite.getClientArea();
            GC gC = new GC((Drawable)composite);
            gC.setFont(XmlText.this.getFont());
            gC.setForeground(XmlText.this.getForeground());
            gC.setBackground(XmlText.this.getBackground());
            Locator locator = new Locator();
            locator.marginWidth = XmlText.this.marginWidth;
            locator.marginHeight = XmlText.this.marginHeight;
            locator.y = XmlText.this.marginHeight;
            FontMetrics fontMetrics = gC.getFontMetrics();
            int n = fontMetrics.getHeight();
            XmlParagraph[] xmlParagraphArray = XmlText.this.model.getParagraphs();
            IHyperlinkSegment iHyperlinkSegment = XmlText.this.getSelectedLink();
            int n2 = 0;
            while (n2 < xmlParagraphArray.length) {
                XmlParagraph xmlParagraph = xmlParagraphArray[n2];
                if (n2 > 0 && XmlText.this.paragraphsSeparated && xmlParagraph.getAddVerticalSpace()) {
                    locator.y += XmlText.this.getParagraphSpacing(n);
                }
                locator.indent = xmlParagraph.getIndent();
                locator.resetCaret();
                locator.rowHeight = 0;
                xmlParagraph.layout(gC, rectangle.width, locator, n, iHyperlinkSegment);
                ++n2;
            }
            gC.dispose();
        }
    }
}

