/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;
import gama.gaml.operators.Cast;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.controls.SimpleSlider;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class SliderEditor<T extends Comparable>
extends AbstractEditor<T> {
    protected int nbInts;
    SimpleSlider slider;
    final DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    private static final int[] ITEMS;

    static {
        DEBUG.OFF();
        ITEMS = new int[]{8, 6};
    }

    public SliderEditor(IAgent iAgent, IParameter iParameter, EditorListener<T> editorListener) {
        super(iAgent, iParameter, editorListener);
        this.computeFormatterParameters();
    }

    @Override
    protected int[] getToolItems() {
        return ITEMS;
    }

    protected void computeFormatterParameters() {
        int n = String.valueOf(Cast.asInt((IScope)this.getScope(), this.getMinValue())).length();
        int n2 = String.valueOf(Cast.asInt((IScope)this.getScope(), this.getMaxValue())).length();
        this.nbInts = Math.max(n, n2);
    }

    @Override
    protected Control createCustomParameterControl(Composite composite) throws GamaRuntimeException {
        List list = this.getParam().getColors(this.getScope());
        Color color = IGamaColors.OK.color();
        Color color2 = composite.getBackground();
        Color color3 = ThemeHelper.isDark() ? GamaColors.get(color2).lighter() : GamaColors.get(color2).darker();
        Color color4 = color;
        if (list != null) {
            if (list.size() == 1) {
                color = color4 = GamaColors.get((java.awt.Color)list.get(0)).color();
            } else if (list.size() == 2) {
                color = GamaColors.get((java.awt.Color)list.get(0)).color();
                color3 = GamaColors.get((java.awt.Color)list.get(1)).color();
            } else if (list.size() >= 3) {
                color = GamaColors.get((java.awt.Color)list.get(0)).color();
                color4 = GamaColors.get((java.awt.Color)list.get(1)).color();
                color3 = GamaColors.get((java.awt.Color)list.get(2)).color();
            }
        }
        this.slider = new SimpleSlider(composite, color, color3, color4, false);
        this.computeSliderStep();
        this.slider.addPositionChangeListener((simpleSlider, d) -> this.modifyAndDisplayValue(this.computeValue(d)));
        this.slider.pack(true);
        return this.slider;
    }

    private void computeSliderStep() {
        if (this.getStepValue() != null) {
            Double d = ((Number)this.getStepValue()).doubleValue() / (Cast.asFloat((IScope)this.getScope(), this.getMaxValue()) - Cast.asFloat((IScope)this.getScope(), this.getMinValue()));
            this.slider.setStep(d);
        }
    }

    @Override
    protected void computeMaxMinAndStepValues() {
        super.computeMaxMinAndStepValues();
        if (this.slider != null) {
            this.computeSliderStep();
            this.computeFormatterParameters();
            this.displayParameterValue();
            this.updateToolbar();
        }
    }

    @Override
    protected Object getEditorControlGridData() {
        Object object = super.getEditorControlGridData();
        if (object instanceof GridData) {
            GridData gridData = (GridData)object;
            gridData.heightHint = 18;
        }
        return object;
    }

    protected abstract T computeValue(double var1);

    @Override
    protected void displayParameterValue() {
        Comparable comparable = (Comparable)this.currentValue;
        double d = (Cast.asFloat((IScope)this.getScope(), (Object)comparable) - Cast.asFloat((IScope)this.getScope(), this.getMinValue())) / (Cast.asFloat((IScope)this.getScope(), this.getMaxValue()) - Cast.asFloat((IScope)this.getScope(), this.getMinValue()));
        this.slider.updateSlider(d, false);
        this.composite.layout();
    }

    @Override
    protected void updateToolbar() {
        super.updateToolbar();
        this.editorToolbar.updateValue(this.formatter.format(this.currentValue == null ? Integer.valueOf(0) : this.currentValue));
    }

    public static class Float
    extends SliderEditor<Double> {
        int nbFracs;

        public Float(IAgent iAgent, IParameter iParameter, EditorListener<Double> editorListener) {
            super(iAgent, iParameter, editorListener);
        }

        @Override
        protected void computeFormatterParameters() {
            super.computeFormatterParameters();
            this.formatter.setMaximumIntegerDigits(this.nbInts);
            this.formatter.setMinimumIntegerDigits(this.nbInts);
            String string = String.valueOf(this.getStepValue());
            string = string.contains(".") ? string.replaceAll("0*$", "").replaceAll("\\.$", "") : string;
            String[] stringArray = string.split("\\.");
            this.nbFracs = stringArray.length > 1 ? stringArray[1].length() : 1;
            this.formatter.setMaximumFractionDigits(this.nbFracs);
            this.formatter.setMinimumFractionDigits(this.nbFracs);
            this.formatter.setGroupingUsed(false);
        }

        @Override
        protected Double defaultStepValue() {
            return (Cast.asFloat((IScope)this.getScope(), this.getMaxValue()) - Cast.asFloat((IScope)this.getScope(), this.getMinValue())) / 100.0;
        }

        @Override
        protected Double computeValue(double d) {
            return Cast.asFloat((IScope)this.getScope(), this.getMinValue()) + d * (Cast.asFloat((IScope)this.getScope(), this.getMaxValue()) - Cast.asFloat((IScope)this.getScope(), this.getMinValue()));
        }
    }

    public static class Int
    extends SliderEditor<Integer> {
        public Int(IAgent iAgent, IParameter iParameter, EditorListener<Integer> editorListener) {
            super(iAgent, iParameter, editorListener);
        }

        @Override
        protected void computeFormatterParameters() {
            super.computeFormatterParameters();
            this.formatter.setMaximumFractionDigits(0);
            this.formatter.setMinimumFractionDigits(0);
            this.formatter.setMaximumIntegerDigits(this.nbInts);
            this.formatter.setMinimumIntegerDigits(this.nbInts);
            this.formatter.setGroupingUsed(false);
        }

        @Override
        protected Integer defaultStepValue() {
            return 1;
        }

        @Override
        protected Integer computeValue(double d) {
            return (int)((long)Cast.asInt((IScope)this.getScope(), this.getMinValue()).intValue() + Math.round(d * (double)(Cast.asInt((IScope)this.getScope(), this.getMaxValue()) - Cast.asInt((IScope)this.getScope(), this.getMinValue()))));
        }
    }
}

