/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.utils;

import gama.core.common.util.FileUtils;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class FileOpener {
    static final IWorkbenchPage PAGE = WorkbenchHelper.getPage();

    public static IEditorPart openFile(URI uRI) {
        if (uRI == null) {
            MessageDialog.openWarning(null, (String)"No file found", (String)"Trying to open a null file");
            return null;
        }
        try {
            if (uRI.isPlatformResource()) {
                return FileOpener.openFileInWorkspace(uRI);
            }
            if (uRI.isFile()) {
                return FileOpener.openFileInFileSystem(uRI);
            }
        }
        catch (PartInitException partInitException) {
            MessageDialog.openWarning(null, (String)"No file found", (String)("The file'" + uRI.toString() + "' does not exist on disk."));
        }
        MessageDialog.openWarning(null, (String)"No file found", (String)("The file'" + uRI.toString() + "' cannot be found."));
        return null;
    }

    public static IEditorPart openFileInWorkspace(URI uRI) throws PartInitException {
        IFile iFile = FileUtils.getWorkspaceFile((URI)uRI);
        if (iFile == null) {
            MessageDialog.openWarning(null, (String)"No file found", (String)("The file'" + uRI.toString() + "' cannot be found."));
            return null;
        }
        return IDE.openEditor((IWorkbenchPage)PAGE, (IFile)iFile);
    }

    public static IEditorPart openFileInFileSystem(URI uRI) throws PartInitException {
        IFileInfo iFileInfo;
        IFileStore iFileStore;
        if (uRI == null) {
            return null;
        }
        try {
            iFileStore = EFS.getLocalFileSystem().getStore(Path.fromOSString((String)uRI.toFileString()));
        }
        catch (Exception exception) {
            MessageDialog.openWarning(null, (String)"No file found", (String)("The file'" + uRI.toString() + "' cannot be found."));
            return null;
        }
        try {
            iFileInfo = iFileStore.fetchInfo();
        }
        catch (Exception exception) {
            MessageDialog.openWarning(null, (String)"No file found", (String)("The file'" + uRI.toString() + "' cannot be found."));
            return null;
        }
        if (!iFileInfo.exists()) {
            MessageDialog.openWarning(null, (String)"No file found", (String)("The file'" + uRI.toString() + "' cannot be found."));
        }
        return IDE.openInternalEditorOnFileStore((IWorkbenchPage)PAGE, (IFileStore)iFileStore);
    }
}

