/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.utils;

import gama.core.common.interfaces.IGamaView;
import gama.core.common.preferences.GamaPreferences;
import gama.ui.application.workbench.IWebHelper;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class WebHelper
implements IWebHelper {
    private static WebHelper instance = new WebHelper();
    private static URL HOME_URL;

    public static WebHelper getInstance() {
        return instance;
    }

    private WebHelper() {
    }

    public static URL getWelcomePageURL() {
        if (HOME_URL == null) {
            try {
                String string = "/welcome/" + (ThemeHelper.isDark() ? "dark" : "light") + "/welcome.html";
                HOME_URL = FileLocator.toFileURL((URL)Platform.getBundle((String)"gama.ui.shared").getEntry(string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return HOME_URL;
    }

    public static void openWelcomePage() {
        FileEditorInput fileEditorInput;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Path path = new Path(WebHelper.getWelcomePageURL().getPath());
        IFile iFile = iWorkspace.getRoot().getFileForLocation((IPath)path);
        if (iFile == null) {
            IFileStore iFileStore = EFS.getLocalFileSystem().getStore((IPath)path);
            fileEditorInput = new FileStoreEditorInput(iFileStore);
        } else {
            fileEditorInput = new FileEditorInput(iFile);
        }
        try {
            WorkbenchHelper.getPage().openEditor((IEditorInput)fileEditorInput, "gama.ui.application.browser");
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    public static void showWeb2Editor(URL uRL) {
        FileEditorInput fileEditorInput;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Path path = new Path(uRL.getPath());
        IFile iFile = iWorkspace.getRoot().getFileForLocation((IPath)path);
        if (iFile == null) {
            IFileStore iFileStore = EFS.getLocalFileSystem().getStore((IPath)path);
            fileEditorInput = new FileStoreEditorInput(iFileStore);
        } else {
            fileEditorInput = new FileEditorInput(iFile);
        }
        try {
            WorkbenchHelper.getPage().openEditor((IEditorInput)fileEditorInput, "gama.ui.application.browser");
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    public static void openPage(String string) {
        if (((Boolean)GamaPreferences.Network.CORE_EXTERNAL_BROWSER.getValue()).booleanValue()) {
            try {
                IGamaView.Html html = (IGamaView.Html)WorkbenchHelper.getPage().openEditor((IEditorInput)new NullEditorInput(), "gama.ui.application.browser");
                html.setUrl(string);
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        } else {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(string));
            }
            catch (MalformedURLException | PartInitException throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void showPage(String string) {
        WebHelper.openPage(string);
    }

    public void showURL(URL uRL) {
        WebHelper.showWeb2Editor(uRL);
    }
}

