/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.access;

import gama.gaml.compilation.GamlIdiomsProvider;
import gama.gaml.interfaces.IGamlDescription;
import gama.ui.shared.access.GamlAccessEntry;
import gama.ui.shared.access.GamlAccessMatcher;
import gama.ui.shared.access.GamlBrowserPane;
import gama.ui.shared.utils.WebHelper;
import gama.ui.shared.views.toolbar.GamaCommand;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class GamlAccessContents2
extends PopupDialog {
    private static final String QUICK_ACCESS_COMMAND_ID = "org.eclipse.ui.window.quickAccess";
    private static final List<GamlAccessEntry>[] EMPTY_ENTRIES = (List[])Array.newInstance(List.class, 0);
    protected Text filterText;
    private final Map<IGamlDescription, GamlIdiomsProvider> elementsToProviders = new HashMap<IGamlDescription, GamlIdiomsProvider>();
    protected Table table;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    protected String rememberedText;
    GridData browserData;
    private Color grayColor;
    private TextLayout textLayout;
    private static boolean showAllMatches = false;
    protected boolean resized = false;
    private TriggerSequence keySequence;
    private Job computeProposalsJob;
    GamlBrowserPane browser;
    Pattern categoryPattern;
    Label hintText;
    private boolean displayHintText;

    public GamlAccessContents2() {
        super(ProgressManagerUtil.getDefaultParent(), 16, true, true, false, false, false, "GAML Reference", null);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        boolean bl = Util.isWindows();
        GridLayoutFactory.fillDefaults().extendedMargins(bl ? 0 : 3, 3, 2, 2).numColumns(2).applyTo(composite2);
        this.hintText = this.createHintText(composite2, -1);
        GridData gridData = new GridData(4, -1, true, false, 2, 1);
        gridData.horizontalIndent = 7;
        this.hintText.setLayoutData((Object)gridData);
        this.createTable(composite2);
        this.createBrowser(composite2);
        return composite2;
    }

    public int open() {
        int n = super.open();
        this.updateProposals("");
        return n;
    }

    private int computeNumberOfItems() {
        Rectangle rectangle = this.table.getClientArea();
        int n = this.table.getItemHeight();
        int n2 = this.table.getHeaderHeight();
        return (rectangle.height - n2 + n - 1) / (n + this.table.getGridLineWidth());
    }

    public void updateProposals(final String string) {
        if (this.computeProposalsJob != null) {
            this.computeProposalsJob.cancel();
            this.computeProposalsJob = null;
        }
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        final Display display = this.table.getDisplay();
        int n = this.computeNumberOfItems();
        final AtomicReference atomicReference = new AtomicReference();
        final Job job = Job.create((String)"Computing entries", iProgressMonitor -> {
            atomicReference.set(this.computeMatchingEntries(string, null, n, iProgressMonitor));
            return iProgressMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        });
        job.setPriority(10);
        final UIJob uIJob = new UIJob(this.table.getDisplay(), ""){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                if (job.getResult() == null && !iProgressMonitor.isCanceled() && !GamlAccessContents2.this.table.isDisposed()) {
                    GamlAccessContents2.this.showHintText("Computing entries", GamlAccessContents2.this.grayColor);
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                uIJob.cancel();
                if (GamlAccessContents2.this.computeProposalsJob == job && iJobChangeEvent.getResult().isOK() && !GamlAccessContents2.this.table.isDisposed()) {
                    display.asyncExec(() -> {
                        uIJob.cancel();
                        GamlAccessContents2.this.refreshTable((List[])atomicReference.get(), string);
                    });
                }
            }
        });
        this.computeProposalsJob = job;
        job.schedule();
        uIJob.schedule(200L);
    }

    public void setShowAllMatches(boolean bl) {
        if (showAllMatches != bl) {
            showAllMatches = bl;
            this.updateProposals(this.filterText.getText().toLowerCase());
        }
    }

    public TriggerSequence getTriggerSequence() {
        if (this.keySequence == null) {
            IBindingService iBindingService = (IBindingService)Adapters.adapt((Object)PlatformUI.getWorkbench(), IBindingService.class);
            this.keySequence = iBindingService.getBestActiveBindingFor(QUICK_ACCESS_COMMAND_ID);
        }
        return this.keySequence;
    }

    public boolean getShowAllMatches() {
        return showAllMatches;
    }

    private void refreshTable(List<GamlAccessEntry>[] listArray, String string) {
        if (this.table.isDisposed()) {
            return;
        }
        if (this.table.getItemCount() > listArray.length && this.table.getItemCount() - listArray.length > 20) {
            this.table.removeAll();
        }
        TableItem[] tableItemArray = this.table.getItems();
        int n = -1;
        int n2 = 0;
        List<GamlAccessEntry>[] listArray2 = listArray;
        int n3 = listArray.length;
        int n4 = 0;
        while (n4 < n3) {
            List<GamlAccessEntry> list = listArray2[n4];
            if (list != null) {
                boolean bl = true;
                Iterator<GamlAccessEntry> iterator = list.iterator();
                while (iterator.hasNext()) {
                    TableItem tableItem;
                    GamlAccessEntry gamlAccessEntry = iterator.next();
                    gamlAccessEntry.firstInCategory = bl;
                    bl = false;
                    if (!iterator.hasNext()) {
                        gamlAccessEntry.lastInCategory = true;
                    }
                    if (n2 < tableItemArray.length) {
                        tableItem = tableItemArray[n2];
                        this.table.clear(n2);
                    } else {
                        tableItem = new TableItem(this.table, 0);
                    }
                    tableItem.setData((Object)gamlAccessEntry);
                    tableItem.setText(0, gamlAccessEntry.provider.getSearchCategory());
                    tableItem.setText(1, gamlAccessEntry.element.getTitle());
                    ++n2;
                }
            }
            ++n4;
        }
        if (n2 < tableItemArray.length) {
            this.table.remove(n2, tableItemArray.length - 1);
        }
        if (n == -1) {
            n = 0;
        }
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(n);
            this.hideHintText();
        } else if (string.isEmpty()) {
            this.showHintText("Start typing text to find GAML elements", this.grayColor);
        } else {
            this.showHintText("No matching GAML elements", this.grayColor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<GamlAccessEntry>[] computeMatchingEntries(String object, IGamlDescription iGamlDescription, int n, IProgressMonitor iProgressMonitor) {
        Object object2;
        if (object == null || ((String)object).isBlank()) {
            return EMPTY_ENTRIES;
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        Matcher matcher = this.getCategoryPattern().matcher((CharSequence)object);
        String string = null;
        if (matcher.matches()) {
            string = matcher.group(1);
            object = string + " " + matcher.group(2);
        }
        Object string2 = object;
        LinkedHashMap<GamlIdiomsProvider, List> linkedHashMap = new LinkedHashMap<GamlIdiomsProvider, List>();
        for (GamlIdiomsProvider gamlIdiomsProvider2 : GamlIdiomsProvider.getProviders()) {
            void var12_22;
            void var12_25;
            if (iProgressMonitor.isCanceled()) break;
            if (string != null && !string.equalsIgnoreCase(gamlIdiomsProvider2.getSearchCategory()) || ((String)object).isEmpty() && !showAllMatches) continue;
            object2 = new AtomicReference<List<IGamlDescription>>();
            ((AtomicReference)object2).set(Arrays.asList(gamlIdiomsProvider2.getSortedElements()));
            List list2 = (List)((AtomicReference)object2).get();
            if (list2 == null) {
                List list3 = Collections.emptyList();
            }
            for (Object object3 : var12_25) {
                this.elementsToProviders.put((IGamlDescription)object3, gamlIdiomsProvider2);
            }
            if (!((String)object).isEmpty() && !var12_25.isEmpty()) {
                List<IGamlDescription> list4 = GamlAccessContents2.putPrefixMatchFirst((List<IGamlDescription>)var12_25, (String)object);
            }
            linkedHashMap.put(gamlIdiomsProvider2, new ArrayList(var12_22));
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object2 = new ArrayList((Collection)entry.getValue());
            entry.setValue(object2);
        }
        LinkedHashMap<GamlIdiomsProvider, Object> linkedHashMap2 = new LinkedHashMap<GamlIdiomsProvider, Object>(linkedHashMap.size());
        if (showAllMatches) {
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                Object object3;
                GamlIdiomsProvider gamlIdiomsProvider3 = (GamlIdiomsProvider)entry.getKey();
                object3 = ((List)entry.getValue()).stream().map(GamlAccessMatcher::new).map(arg_0 -> GamlAccessContents2.lambda$2((String)string2, gamlIdiomsProvider3, arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
                if (object3.isEmpty()) continue;
                linkedHashMap2.put(gamlIdiomsProvider3, object3);
            }
        } else {
            void var10_14;
            int n2 = iGamlDescription != null ? n * 2 - 1 : n * 2;
            while (!linkedHashMap.isEmpty() && var10_14 > 0) {
                void var11_21 = var10_14 / linkedHashMap.size();
                if (var11_21 > 0) {
                    for (Map.Entry entry : linkedHashMap.entrySet()) {
                        var14_37 = (GamlIdiomsProvider)entry.getKey();
                        var15_38 = (List)entry.getValue();
                        var16_39 = var11_21;
                        while (var16_39 > 0 && !var15_38.isEmpty()) {
                            var17_40 = (IGamlDescription)var15_38.remove(0);
                            var18_41 = new GamlAccessMatcher(var17_40).match((String)object, var14_37);
                            if (var18_41 == null) continue;
                            --var10_14;
                            --var16_39;
                            if (!linkedHashMap2.containsKey(var14_37)) {
                                linkedHashMap2.put(var14_37, new LinkedList());
                            }
                            ((List)linkedHashMap2.get(var14_37)).add(var18_41);
                        }
                    }
                } else {
                    for (Map.Entry entry : linkedHashMap.entrySet()) {
                        if (var10_14 <= 0) continue;
                        var14_37 = (GamlIdiomsProvider)entry.getKey();
                        var15_38 = (List)entry.getValue();
                        var16_39 = 0;
                        while (var16_39 == 0 && !var15_38.isEmpty()) {
                            var17_40 = (IGamlDescription)var15_38.remove(0);
                            var18_41 = new GamlAccessMatcher(var17_40).match((String)object, var14_37);
                            if (var18_41 == null) continue;
                            --var10_14;
                            var16_39 = 1;
                            if (!linkedHashMap2.containsKey(var14_37)) {
                                linkedHashMap2.put(var14_37, new LinkedList());
                            }
                            ((List)linkedHashMap2.get(var14_37)).add(var18_41);
                        }
                    }
                }
                HashSet hashSet = new HashSet();
                linkedHashMap.forEach((gamlIdiomsProvider, list) -> {
                    if (list.isEmpty()) {
                        hashSet.add(gamlIdiomsProvider);
                    }
                });
                hashSet.forEach(linkedHashMap::remove);
            }
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(linkedHashMap2.values());
        return arrayList.toArray(new List[arrayList.size()]);
    }

    private static List<IGamlDescription> putPrefixMatchFirst(List<IGamlDescription> list, String string) {
        ArrayList<IGamlDescription> arrayList = new ArrayList<IGamlDescription>(list);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n = 0;
        while (n < list.size()) {
            if (list.get(n).getTitle().toLowerCase().startsWith(string.toLowerCase())) {
                arrayList2.add(n);
            }
            ++n;
        }
        n = 0;
        int n2 = arrayList2.size();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            boolean bl;
            boolean bl2 = bl = !arrayList2.isEmpty() && (Integer)arrayList2.iterator().next() == n3;
            if (bl) {
                arrayList2.remove(0);
                arrayList.set(n, list.get(n3));
                ++n;
            } else {
                arrayList.set(n2, list.get(n3));
                ++n2;
            }
            ++n3;
        }
        return arrayList;
    }

    protected Pattern getCategoryPattern() {
        if (this.categoryPattern == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("^(:?");
            int n = 0;
            while (n < GamlIdiomsProvider.getProviders().size()) {
                if (n != 0) {
                    stringBuilder.append("|");
                }
                stringBuilder.append(((GamlIdiomsProvider)GamlIdiomsProvider.getProviders().get(n)).getSearchCategory());
                ++n;
            }
            stringBuilder.append("):\\s?(.*)");
            String string = stringBuilder.toString();
            this.categoryPattern = Pattern.compile(string, 2);
        }
        return this.categoryPattern;
    }

    private void doDispose() {
        if (this.textLayout != null && !this.textLayout.isDisposed()) {
            this.textLayout.dispose();
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
    }

    protected String getId() {
        return "org.eclipse.ui.internal.QuickAccess";
    }

    protected void handleElementSelected(String string, IGamlDescription iGamlDescription) {
        if (iGamlDescription == null) {
            return;
        }
        Consumer consumer = iGamlDescription.getContextualAction();
        if (consumer != null) {
            consumer.accept(iGamlDescription);
            return;
        }
        String string2 = "https://gama-platform.org/search?q=" + iGamlDescription.getName();
        WebHelper.openPage(string2);
    }

    private void handleSelection() {
        IGamlDescription iGamlDescription = null;
        String string = this.filterText.getText().toLowerCase();
        if (this.table.getSelectionCount() == 1) {
            GamlAccessEntry gamlAccessEntry = (GamlAccessEntry)this.table.getSelection()[0].getData();
            IGamlDescription iGamlDescription2 = iGamlDescription = gamlAccessEntry == null ? null : gamlAccessEntry.element;
        }
        if (iGamlDescription != null) {
            this.doClose();
            this.handleElementSelected(string, iGamlDescription);
        }
    }

    protected void doClose() {
        this.close();
    }

    public void hookFilterText(Text text) {
        this.filterText = text;
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        GamlAccessContents2.this.handleSelection();
                        break;
                    }
                    case 0x1000002: {
                        int n = GamlAccessContents2.this.table.getSelectionIndex();
                        if (n == -1 || GamlAccessContents2.this.table.getItemCount() <= n + 1) break;
                        GamlAccessContents2.this.table.setSelection(n + 1);
                        break;
                    }
                    case 0x1000001: {
                        int n = GamlAccessContents2.this.table.getSelectionIndex();
                        if (n == -1 || n < 1) break;
                        GamlAccessContents2.this.table.setSelection(n - 1);
                        break;
                    }
                    case 27: {
                        GamlAccessContents2.this.doClose();
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        text.addModifyListener(modifyEvent -> {
            String string = ((Text)modifyEvent.widget).getText();
            this.updateProposals(string);
        });
    }

    Label createHintText(Composite composite, int n) {
        this.hintText = new Label(composite, 4);
        this.hintText.setOrientation(n);
        this.displayHintText = true;
        return this.hintText;
    }

    private void hideHintText() {
        if (this.displayHintText) {
            this.setHintTextToDisplay(false);
        }
    }

    private void showHintText(String string, Color color) {
        if (this.hintText == null || this.hintText.isDisposed()) {
            return;
        }
        this.hintText.setText(string);
        if (color != null) {
            this.hintText.setForeground(color);
        }
        if (!this.displayHintText) {
            this.setHintTextToDisplay(true);
        }
    }

    private void setHintTextToDisplay(boolean bl) {
        GridData gridData = (GridData)this.hintText.getLayoutData();
        gridData.exclude = !bl;
        this.hintText.setVisible(bl);
        this.hintText.requestLayout();
        this.displayHintText = bl;
    }

    public Table createTable(Composite composite) {
        GamlIdiomsProvider gamlIdiomsProvider2;
        composite.addDisposeListener(disposeEvent -> this.doDispose());
        Composite composite2 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite2);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite2.setLayout((Layout)tableColumnLayout);
        this.table = new Table(composite2, 65540);
        this.textLayout = new TextLayout((Device)this.table.getDisplay());
        Font font = (Font)this.resourceManager.create((DeviceResourceDescriptor)FontDescriptor.createFrom((Font)this.table.getFont()).setStyle(1));
        this.textLayout.setFont(font);
        this.textLayout.setText("Available categories to search into");
        int n = this.textLayout.getBounds().width;
        for (GamlIdiomsProvider gamlIdiomsProvider2 : GamlIdiomsProvider.getProviders()) {
            this.textLayout.setText(gamlIdiomsProvider2.getSearchCategory());
            int n2 = this.textLayout.getBounds().width;
            if (n2 <= n) continue;
            n = n2;
        }
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(0, n));
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(100, 100));
        this.table.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (!showAllMatches && !GamlAccessContents2.this.resized) {
                    GamlAccessContents2.this.resized = true;
                    controlEvent.display.timerExec(100, () -> {
                        if (GamlAccessContents2.this.table != null && !GamlAccessContents2.this.table.isDisposed() && GamlAccessContents2.this.filterText != null && !GamlAccessContents2.this.filterText.isDisposed()) {
                            GamlAccessContents2.this.updateProposals(GamlAccessContents2.this.filterText.getText().toLowerCase());
                        }
                        GamlAccessContents2.this.resized = false;
                    });
                }
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000001 && GamlAccessContents2.this.table.getSelectionIndex() == 0) {
                    GamlAccessContents2.this.filterText.setFocus();
                } else if (keyEvent.character == '\u001b') {
                    GamlAccessContents2.this.doClose();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (GamlAccessContents2.this.table.getSelectionCount() < 1 || mouseEvent.button != 1) {
                    return;
                }
                if (GamlAccessContents2.this.table.equals(mouseEvent.getSource())) {
                    TableItem tableItem = GamlAccessContents2.this.table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    TableItem tableItem2 = GamlAccessContents2.this.table.getSelection()[0];
                    if (tableItem2.equals(tableItem)) {
                        GamlAccessContents2.this.handleSelection();
                    }
                }
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){
            TableItem lastItem = null;

            public void mouseMove(MouseEvent mouseEvent) {
                if (GamlAccessContents2.this.table.equals(mouseEvent.getSource())) {
                    TableItem tableItem = GamlAccessContents2.this.table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    if (tableItem != null) {
                        if (!tableItem.equals(this.lastItem)) {
                            this.lastItem = tableItem;
                            GamlAccessContents2.this.table.setSelection(new TableItem[]{this.lastItem});
                            GamlAccessEntry gamlAccessEntry = (GamlAccessEntry)this.lastItem.getData();
                            if (gamlAccessEntry != null) {
                                IGamlDescription iGamlDescription = gamlAccessEntry.element;
                                GamlAccessContents2.this.browser.setInput(gamlAccessEntry.provider.document(iGamlDescription));
                                GamlAccessContents2.this.showBrowser();
                            }
                        }
                    } else {
                        this.lastItem = null;
                    }
                }
                if (this.lastItem == null) {
                    GamlAccessContents2.this.hideBrowser();
                } else {
                    GamlAccessContents2.this.showBrowser();
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                GamlAccessContents2.this.handleSelection();
            }
        });
        this.filterText.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent mouseEvent) {
                GamlAccessContents2.this.hideBrowser();
            }
        });
        gamlIdiomsProvider2 = event -> {
            GamlAccessEntry gamlAccessEntry = (GamlAccessEntry)event.item.getData();
            if (gamlAccessEntry != null) {
                switch (event.type) {
                    case 41: {
                        gamlAccessEntry.measure(event, this.textLayout);
                        break;
                    }
                    case 42: {
                        gamlAccessEntry.paint(event, this.textLayout);
                        break;
                    }
                    case 40: {
                        gamlAccessEntry.erase(event);
                    }
                }
            }
        };
        this.table.addListener(41, (Listener)gamlIdiomsProvider2);
        this.table.addListener(40, (Listener)gamlIdiomsProvider2);
        this.table.addListener(42, (Listener)gamlIdiomsProvider2);
        return this.table;
    }

    public Text getFilterText() {
        return this.filterText;
    }

    public Table getTable() {
        return this.table;
    }

    protected Control createTitleControl(Composite composite) {
        composite.getShell().setText(QuickAccessMessages.QuickAccessContents_QuickAccess);
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        GamaCommand.build("editor/lexical.sort", "", "Toggle the display of all proposals", selectionEvent -> this.setShowAllMatches(!showAllMatches)).toCheckItem(toolBar).setSelection(!showAllMatches);
        this.filterText = new Text(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.filterText);
        this.hookFilterText(this.filterText);
        return this.filterText;
    }

    private void createBrowser(Composite composite) {
        this.browser = new GamlBrowserPane();
        this.browserData = GridDataFactory.fillDefaults().grab(true, true).create();
        this.browser.createContent(composite);
        this.browser.getControl().setLayoutData((Object)this.browserData);
        this.hideBrowser();
    }

    private void showBrowser() {
        this.browserData.exclude = false;
        this.browser.getControl().setVisible(true);
        this.browser.getControl().getParent().requestLayout();
    }

    private void hideBrowser() {
        this.browserData.exclude = true;
        this.browser.getControl().setVisible(false);
        this.browser.getControl().getParent().requestLayout();
    }

    protected Control getFocusControl() {
        return this.filterText;
    }

    protected Point getDefaultSize() {
        int n;
        GC gC = new GC((Drawable)this.getContents());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        int n2 = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)300);
        if (n2 < 350) {
            n2 = 350;
        }
        if ((n = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)270)) < 420) {
            n = 420;
        }
        return new Point(n2, n);
    }

    protected Point getDefaultLocation(Point point) {
        Rectangle rectangle = this.getParentShell().getBounds();
        int n = rectangle.x + rectangle.width / 2 - point.x / 2;
        int n2 = rectangle.y + rectangle.height / 2 - point.y / 2;
        return new Point(n, n2);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(GamlAccessContents2.class)).getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(this.getId());
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(this.getId());
        }
        return iDialogSettings2;
    }

    private static /* synthetic */ GamlAccessEntry lambda$2(String string, GamlIdiomsProvider gamlIdiomsProvider, GamlAccessMatcher gamlAccessMatcher) {
        return gamlAccessMatcher.match(string, gamlIdiomsProvider);
    }
}

