/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.access;

import gama.core.runtime.GAMA;
import gama.dev.DEBUG;
import gama.ui.shared.access.GamlAccessContents2;
import gama.ui.shared.controls.StatusControlContribution;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaToolbarSimple;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;

public class HeapControl {
    ToolItem item;

    static {
        DEBUG.ON();
    }

    Control displayOn(final Composite composite) {
        final Composite composite2 = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).extendedMargins(0, 5, 5, 5).numColumns(2).equalWidth(false).applyTo(composite2);
        final GamaToolbarSimple gamaToolbarSimple = new GamaToolbarSimple(composite2, 0);
        gamaToolbarSimple.space(20);
        gamaToolbarSimple.button("editor/command.find", null, "Search GAML reference", selectionEvent -> {
            GamlAccessContents2 gamlAccessContents2 = new GamlAccessContents2();
            gamlAccessContents2.open();
        });
        this.item = gamaToolbarSimple.button("generic/garbage.collect", "", "", selectionEvent -> {
            Runtime runtime = Runtime.getRuntime();
            long l = this.convertToMeg(runtime.totalMemory());
            System.gc();
            l = this.convertToMeg(runtime.totalMemory());
            GAMA.getGui().getStatus().informStatus("Compact memory (" + (l - this.convertToMeg(runtime.freeMemory())) + "M on " + l + "M)", "status/status.memory");
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).indent(30, 0).applyTo((Control)gamaToolbarSimple);
        gamaToolbarSimple.addListener(6, event -> this.updateToolTip());
        new StatusControlContribution().fill(gamaToolbarSimple, 0);
        composite.requestLayout();
        composite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent controlEvent) {
                DEBUG.OUT((Object)("Size of parent : " + String.valueOf(composite.getSize())));
                DEBUG.OUT((Object)("Size of composite : " + String.valueOf(composite2.getSize())));
                DEBUG.OUT((Object)("Size of toolbar : " + String.valueOf(gamaToolbarSimple.getSize())));
                composite.requestLayout();
            }

            public void controlMoved(ControlEvent controlEvent) {
            }
        });
        return composite2;
    }

    protected void updateToolTip() {
        Runtime runtime = Runtime.getRuntime();
        long l = this.convertToMeg(runtime.totalMemory());
        this.item.setToolTipText("Memory used: " + (l - this.convertToMeg(runtime.freeMemory())) + "M on " + l + "M");
    }

    private long convertToMeg(long l) {
        return (l + 524288L) / 0x100000L;
    }

    public static void install() {
        WorkbenchHelper.runInUI("Install GAMA Status and Heap Controls", 0, iProgressMonitor -> {
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (iWorkbenchWindow instanceof WorkbenchWindow) {
                WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
                MTrimBar mTrimBar = workbenchWindow.getTopTrim();
                for (MTrimElement mTrimElement : mTrimBar.getChildren()) {
                    if (!"SearchField".equals(mTrimElement.getElementId())) continue;
                    Composite composite = ((Control)mTrimElement.getWidget()).getParent();
                    Control control = (Control)mTrimElement.getWidget();
                    WorkbenchHelper.asyncRun(() -> control.dispose(), 500, () -> true);
                    mTrimElement.setWidget((Object)new HeapControl().displayOn(composite));
                    composite.requestLayout();
                    break;
                }
            }
        });
    }
}

