/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.controls;

import gama.core.common.IStatusMessage;
import gama.core.common.StatusMessage;
import gama.core.common.StatusMessageFactory;
import gama.core.common.interfaces.IStatusControl;
import gama.core.common.interfaces.IStatusDisplayer;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.controls.StatusHistoryPopUpMenu;
import gama.ui.shared.controls.StatusIconProvider;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Color;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.progress.UIJob;

public class StatusControlContribution
extends WorkbenchWindowControlContribution
implements IStatusControl {
    IStatusMessage.StatusType currentStatus;
    GamaRuntimeException currentException;
    private volatile boolean isUpdating;
    private FlatButton label;
    private StatusHistoryPopUpMenu historyPopup;
    private volatile Double taskCompletion;
    private static final int WIDTH = 400;
    static StatusControlContribution INSTANCE;
    private GamaColors.GamaUIColor inactiveColor;
    boolean showSystemEvents = true;
    boolean showViewEvents = true;
    StatusIconProvider iconProvider = new StatusIconProvider();
    UIJob idleJob = new UIJob("Idle"){

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (StatusControlContribution.this.label == null || StatusControlContribution.this.label.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            StatusControlContribution.this.label.setImageWithoutRecomputingSize(GamaIcon.named("overlays/status.clock").image());
            StatusControlContribution.this.label.setTextWithoutRecomputingSize("Idle");
            return Status.OK_STATUS;
        }
    };

    static {
        DEBUG.ON();
    }

    public static StatusControlContribution getInstance() {
        return INSTANCE;
    }

    public StatusControlContribution() {
        INSTANCE = this;
        WorkbenchHelper.getService(IStatusDisplayer.class).setStatusTarget((IStatusControl)this);
    }

    public StatusControlContribution(String string) {
        super(string);
        INSTANCE = this;
    }

    protected int computeWidth(Control control) {
        return 400;
    }

    protected Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0x20000000);
        this.inactiveColor = ThemeHelper.isDark() ? GamaColors.get(GamaColors.get(composite.getBackground()).lighter()) : GamaColors.get(GamaColors.get(composite.getBackground()).darker());
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(composite2);
        this.label = FlatButton.label(composite2, this.inactiveColor, "", 400).withMinimalHeight(24).addMenuSign();
        this.label.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).hint(400, 24).applyTo((Control)this.label);
        this.historyPopup = new StatusHistoryPopUpMenu(this);
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (StatusControlContribution.this.historyPopup.isVisible()) {
                    StatusControlContribution.this.historyPopup.hide();
                } else {
                    WorkbenchHelper.asyncRun(StatusControlContribution.this.historyPopup::display);
                }
            }
        });
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
            final Set<String> uselessJobs = Set.of("Win32 refresh daemon", "Animation start", "Decoration Calculation", "Update Capability Enablement for Natures", "Status refresh", "Update for Decoration Completion", "Change cursor", "Searching for local changes", "Hooking to commands", "Update Job", "Check for workspace changes", "Refreshing view", "Mark Occurrences", "XtextReconcilerJob", "Xtext validation", "Searching for markers", "Idle");

            public void aboutToRun(IJobChangeEvent iJobChangeEvent) {
                String string;
                Job job = iJobChangeEvent.getJob();
                if (WorkbenchHelper.getWorkbench().isClosing()) {
                    return;
                }
                String string2 = string = job.getName() == null ? "" : job.getName().strip();
                if (this.uselessJobs.contains(string)) {
                    return;
                }
                Object object = job.getProperty(IStatusMessage.JOB_KEY);
                if ("internal".equals(object)) {
                    return;
                }
                boolean bl = "view".equals(object);
                WorkbenchHelper.asyncRun(() -> StatusControlContribution.this.updateWith(StatusMessageFactory.CUSTOM((String)string, (IStatusMessage.StatusType)IStatusMessage.StatusType.REGULAR, (String)(bl ? "status/status.view" : "status/status.system"), null)));
            }

            public void done(IJobChangeEvent iJobChangeEvent) {
            }

            private String jobPriority(int n) {
                return switch (n) {
                    case 10 -> "INTERACTIVE";
                    case 40 -> "BUILD";
                    case 50 -> "DECORATE";
                    case 30 -> "LONG";
                    case 20 -> "SHORT";
                    default -> "NONE";
                };
            }

            public void scheduled(IJobChangeEvent iJobChangeEvent) {
            }

            public void awake(IJobChangeEvent iJobChangeEvent) {
            }

            public void sleeping(IJobChangeEvent iJobChangeEvent) {
            }
        });
        return composite2;
    }

    public boolean isDisposed() {
        return this.label.isDisposed();
    }

    public Shell getControllingShell() {
        return this.label.getShell();
    }

    public Point getLocation() {
        return this.label.toDisplay(this.label.getLocation());
    }

    public int getWidth() {
        return this.label.getSize().x;
    }

    public int getHeight() {
        return this.label.getSize().y;
    }

    public void updateWith(IStatusMessage iStatusMessage) {
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        try {
            if (iStatusMessage == null) {
                this.taskCompletion = null;
                this.currentException = null;
                this.currentStatus = IStatusMessage.StatusType.NONE;
                this.label.setColor(this.inactiveColor);
                this.label.setTextWithoutRecomputingSize("");
                this.label.setImageWithoutRecomputingSize(null);
            } else {
                this.taskCompletion = iStatusMessage.completion();
                this.currentException = iStatusMessage.exception();
                this.currentStatus = iStatusMessage.type();
                String string = this.iconProvider.getIcon();
                this.label.setImageWithoutRecomputingSize(string == null ? null : GamaIcon.named(string).image());
                this.label.setTextWithoutRecomputingSize(this.getLabelText(iStatusMessage));
                if (this.currentStatus != IStatusMessage.StatusType.NONE) {
                    this.historyPopup.addStatus(iStatusMessage);
                    if (this.historyPopup.isVisible()) {
                        this.historyPopup.display();
                    }
                }
            }
        }
        finally {
            this.isUpdating = false;
            this.idleJob.schedule(2000L);
        }
    }

    private String getLabelText(IStatusMessage iStatusMessage) {
        String string = iStatusMessage.message();
        if (string == null) {
            string = "";
        }
        return string + (String)(this.taskCompletion != null ? " [" + (int)(this.taskCompletion * 100.0) + "%]" : "");
    }

    public GamaColors.GamaUIColor getLabelBackground(StatusMessage statusMessage) {
        return GamaColors.get((Color)statusMessage.color());
    }

    public void showSystemEvents(boolean bl) {
        this.showSystemEvents = bl;
    }

    public void showViewEvents(boolean bl) {
        this.showViewEvents = bl;
    }

    public boolean showSystemEvents() {
        return this.showSystemEvents;
    }

    public boolean showViewEvents() {
        return this.showSystemEvents;
    }
}

