/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.controls.text;

import gama.core.util.GamaFont;
import gama.dev.DEBUG;
import gama.ui.shared.controls.text.IXmlFontUser;
import gama.ui.shared.controls.text.XmlBreakSegment;
import gama.ui.shared.controls.text.XmlHyperlinkSegment;
import gama.ui.shared.controls.text.XmlLiParagraph;
import gama.ui.shared.controls.text.XmlParagraph;
import gama.ui.shared.controls.text.XmlParagraphSegment;
import gama.ui.shared.controls.text.XmlTextSegment;
import gama.ui.shared.resources.GamaFonts;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.internal.forms.widgets.IFocusSelectable;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.SWTUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlTextModel
implements IXmlFontUser {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY;
    private boolean whitespaceNormalized = true;
    private List<XmlParagraph> paragraphs;
    private IFocusSelectable[] selectableSegments;
    private int selectedSegmentIndex = -1;
    private HyperlinkSettings hyperlinkSettings;
    public GamaFont font;

    static {
        DEBUG.ON();
        DOCUMENT_BUILDER_FACTORY = XmlProcessorFactory.createDocumentBuilderFactoryWithErrorOnDOCTYPE();
    }

    public XmlTextModel(GamaFont gamaFont) {
        this.font = gamaFont;
        this.reset();
    }

    @Override
    public Font getFont() {
        return GamaFonts.getFont(this.font);
    }

    public XmlParagraph[] getParagraphs() {
        if (this.paragraphs == null) {
            return new XmlParagraph[0];
        }
        return this.paragraphs.toArray(new XmlParagraph[this.paragraphs.size()]);
    }

    public void parseTaggedText(String string, boolean bl) {
        if (string == null) {
            this.reset();
            return;
        }
        string = this.processAmpersandEscapes(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        this.parseInputStream(byteArrayInputStream, bl);
    }

    private String processAmpersandEscapes(String string) {
        try {
            String string2 = string.replace("&quot;", "&#034;");
            string2 = string2.replace("<br>", "<br/>");
            string2 = string2.replace("</br>", "<br/>");
            string2 = string2.replace(" \"", " &#034;");
            string2 = string2.replace("\" ", "&#034; ");
            string2 = string2.replace(" '", " &#039;");
            string2 = string2.replace("' ", "&#039; ");
            string2 = string2.replace("&apos;", "&#039;");
            string2 = string2.replace("< ", "&#060; ");
            string2 = string2.replace("&lt;", "&#060;");
            string2 = string2.replace("&gt;", "&#062;");
            string2 = string2.replace(" >", " &#062;");
            string2 = string2.replace("& ", "&#038; ");
            string2 = string2.replace("&amp;", "&#038;");
            return string2.replaceAll("&([^#])", "&#038;$1");
        }
        catch (Exception exception) {
            return string;
        }
    }

    public void parseInputStream(InputStream inputStream, boolean bl) {
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
        DOCUMENT_BUILDER_FACTORY.setIgnoringComments(true);
        this.reset();
        try {
            DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ParseErrorHandler());
            InputSource inputSource = new InputSource(inputStream);
            Document document = documentBuilder.parse(inputSource);
            this.processDocument(document, bl);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            String string = "Error in the text: " + exception.getMessage();
            this.parseRegularText(string, false);
        }
    }

    private void processDocument(Document document, boolean bl) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        this.processSubnodes(this.paragraphs, nodeList, bl);
    }

    private void processSubnodes(List<XmlParagraph> list, NodeList nodeList, boolean bl) {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 3) {
                var6_6 = this.getSingleNodeText(node);
                if (var6_6 != null && !this.isIgnorableWhiteSpace(var6_6, true)) {
                    var7_7 = new XmlParagraph(true, this.font);
                    var7_7.parseRegularText(var6_6, bl, true, this.getHyperlinkSettings(), false, false);
                    list.add(var7_7);
                }
            } else if (node.getNodeType() == 1) {
                var6_6 = node.getNodeName().toLowerCase();
                if ("p".equals(var6_6)) {
                    var7_7 = this.processParagraph(node, bl);
                    if (var7_7 != null) {
                        list.add(var7_7);
                    }
                } else if ("li".equals(var6_6) && (var7_7 = this.processListItem(node, bl)) != null) {
                    list.add(var7_7);
                }
            }
            ++n;
        }
    }

    private XmlParagraph processParagraph(Node node, boolean bl) {
        Object object;
        NodeList nodeList = node.getChildNodes();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("addVerticalSpace");
        boolean bl2 = true;
        if (node2 == null) {
            node2 = namedNodeMap.getNamedItem("vspace");
        }
        if (node2 != null) {
            object = node2.getNodeValue();
            bl2 = "true".equalsIgnoreCase((String)object);
        }
        object = new XmlParagraph(bl2, this.font);
        this.processSegments((XmlParagraph)object, nodeList, bl);
        return object;
    }

    private XmlParagraph processListItem(Node node, boolean bl) {
        Object object;
        NodeList nodeList = node.getChildNodes();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("addVerticalSpace");
        Node node3 = namedNodeMap.getNamedItem("style");
        Node node4 = namedNodeMap.getNamedItem("value");
        Node node5 = namedNodeMap.getNamedItem("indent");
        Node node6 = namedNodeMap.getNamedItem("bindent");
        int n = 1;
        int n2 = -1;
        int n3 = -1;
        Object object2 = null;
        boolean bl2 = true;
        if (node2 != null) {
            object = node2.getNodeValue();
            bl2 = "true".equalsIgnoreCase((String)object);
        }
        if (node3 != null) {
            object = node3.getNodeValue();
            if ("text".equalsIgnoreCase((String)object)) {
                n = 2;
            } else if ("image".equalsIgnoreCase((String)object)) {
                n = 3;
            } else if ("bullet".equalsIgnoreCase((String)object)) {
                n = 1;
            }
        }
        if (node4 != null) {
            object2 = node4.getNodeValue();
            if (n == 3) {
                object2 = "i." + (String)object2;
            }
        }
        if (node5 != null) {
            object = node5.getNodeValue();
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (node6 != null) {
            object = node6.getNodeValue();
            try {
                n3 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        object = new XmlLiParagraph(bl2, this.font);
        ((XmlLiParagraph)object).setIndent(n2);
        ((XmlLiParagraph)object).setBulletIndent(n3);
        ((XmlLiParagraph)object).setBulletStyle(n);
        ((XmlLiParagraph)object).setBulletText((String)object2);
        this.processSegments((XmlParagraph)object, nodeList, bl);
        return object;
    }

    private void processSegments(XmlParagraph xmlParagraph, NodeList nodeList, boolean bl) {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            XmlParagraphSegment xmlParagraphSegment = null;
            if (node.getNodeType() == 3) {
                var7_7 = this.getSingleNodeText(node);
                if (var7_7 != null && !this.isIgnorableWhiteSpace(var7_7, false)) {
                    xmlParagraph.parseRegularText(var7_7, bl, true, this.getHyperlinkSettings(), false, false);
                }
            } else if (node.getNodeType() == 1) {
                var7_7 = node.getNodeName();
                if ("a".equalsIgnoreCase(var7_7)) {
                    xmlParagraphSegment = this.processHyperlinkSegment(node, this.getHyperlinkSettings());
                } else if ("span".equalsIgnoreCase(var7_7)) {
                    this.processTextSegment(xmlParagraph, bl, node);
                } else if ("b".equalsIgnoreCase(var7_7)) {
                    var8_8 = this.getNodeText(node);
                    xmlParagraph.parseRegularText(var8_8, bl, true, this.getHyperlinkSettings(), true, false);
                } else if ("i".equalsIgnoreCase(var7_7)) {
                    var8_8 = this.getNodeText(node);
                    xmlParagraph.parseRegularText(var8_8, bl, true, this.getHyperlinkSettings(), false, true);
                } else if ("br".equalsIgnoreCase(var7_7)) {
                    xmlParagraphSegment = new XmlBreakSegment(this.font);
                } else {
                    var8_8 = this.getNodeText(node);
                    if (var8_8 != null && !this.isIgnorableWhiteSpace(var8_8, false)) {
                        xmlParagraph.parseRegularText(var8_8, bl, true, this.getHyperlinkSettings(), false, false);
                    }
                }
            }
            if (xmlParagraphSegment != null) {
                xmlParagraph.addSegment(xmlParagraphSegment);
            }
            ++n;
        }
    }

    private boolean isIgnorableWhiteSpace(String string, boolean bl) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(bl && c == ' ' || c == '\n' || c == '\r' || c == '\f')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void appendText(String string, StringBuilder stringBuilder, int[] nArray) {
        if (!this.whitespaceNormalized) {
            stringBuilder.append(string);
        } else {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '\t': 
                    case ' ': {
                        nArray[0] = nArray[0] + 1;
                        if (nArray[0] != 1) break;
                        stringBuilder.append(c);
                        break;
                    }
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        nArray[0] = nArray[0] + 1;
                        if (nArray[0] != 1) break;
                        stringBuilder.append(' ');
                        break;
                    }
                    default: {
                        nArray[0] = 0;
                        stringBuilder.append(c);
                    }
                }
                ++n;
            }
        }
    }

    private String getNormalizedText(String string) {
        int[] nArray = new int[1];
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            return null;
        }
        this.appendText(string, stringBuilder, nArray);
        return stringBuilder.toString();
    }

    private String getSingleNodeText(Node node) {
        String string = this.getNormalizedText(node.getNodeValue());
        if (!this.whitespaceNormalized) {
            return string;
        }
        if (string.length() > 0 && node.getPreviousSibling() == null && this.isIgnorableWhiteSpace(string.substring(0, 1), true)) {
            return string.substring(1);
        }
        if (string.length() > 1 && node.getNextSibling() == null && this.isIgnorableWhiteSpace(string.substring(string.length() - 1), true)) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String getNodeText(Node node) {
        NodeList nodeList = node.getChildNodes();
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = new int[1];
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() == 3) {
                String string = node2.getNodeValue();
                this.appendText(string, stringBuilder, nArray);
            }
            ++n;
        }
        if (this.whitespaceNormalized) {
            return stringBuilder.toString().trim();
        }
        return stringBuilder.toString();
    }

    private XmlParagraphSegment processHyperlinkSegment(Node node, HyperlinkSettings hyperlinkSettings) {
        Object object;
        Node node2;
        Node node3;
        Node node4;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        Node node5 = namedNodeMap.getNamedItem("href");
        if (node5 != null) {
            string = node5.getNodeValue();
        }
        if ((node4 = namedNodeMap.getNamedItem("bold")) != null) {
            bl2 = true;
        }
        if ((node3 = namedNodeMap.getNamedItem("italic")) != null) {
            bl3 = true;
        }
        if ((node2 = namedNodeMap.getNamedItem("nowrap")) != null && "true".equalsIgnoreCase((String)(object = node2.getNodeValue()))) {
            bl = false;
        }
        object = new XmlHyperlinkSegment(this.getNodeText(node), hyperlinkSettings, bl2, bl3, this.font);
        ((XmlHyperlinkSegment)object).setHref(string);
        Node node6 = namedNodeMap.getNamedItem("alt");
        if (node6 != null) {
            ((XmlHyperlinkSegment)object).setTooltipText(node6.getNodeValue());
        }
        ((XmlTextSegment)object).setWordWrapAllowed(bl);
        return object;
    }

    private void processTextSegment(XmlParagraph xmlParagraph, boolean bl, Node node) {
        String string;
        String string2 = this.getNodeText(node);
        NamedNodeMap namedNodeMap = node.getAttributes();
        boolean bl2 = true;
        Node node2 = namedNodeMap.getNamedItem("nowrap");
        if (node2 != null && "true".equalsIgnoreCase(string = node2.getNodeValue())) {
            bl2 = false;
        }
        xmlParagraph.parseRegularText(string2, bl, bl2, this.getHyperlinkSettings(), false, false);
    }

    public void parseRegularText(String string, boolean bl) {
        this.reset();
        if (string == null) {
            return;
        }
        string = this.getNormalizedText(string);
        XmlParagraph xmlParagraph = new XmlParagraph(true, this.font);
        this.paragraphs.add(xmlParagraph);
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (xmlParagraph == null) {
                xmlParagraph = new XmlParagraph(true, this.font);
                this.paragraphs.add(xmlParagraph);
            }
            if (c == '\n') {
                String string2 = string.substring(n, n2);
                n = n2 + 1;
                xmlParagraph.parseRegularText(string2, bl, true, this.getHyperlinkSettings(), false, false);
                xmlParagraph = null;
            }
            ++n2;
        }
        if (xmlParagraph != null) {
            String string3 = string.substring(n);
            xmlParagraph.parseRegularText(string3, bl, true, this.getHyperlinkSettings(), false, false);
        }
    }

    public HyperlinkSettings getHyperlinkSettings() {
        if (this.hyperlinkSettings == null) {
            this.hyperlinkSettings = new HyperlinkSettings(SWTUtil.getStandardDisplay());
        }
        return this.hyperlinkSettings;
    }

    public void setHyperlinkSettings(HyperlinkSettings hyperlinkSettings) {
        this.hyperlinkSettings = hyperlinkSettings;
    }

    private void reset() {
        if (this.paragraphs == null) {
            this.paragraphs = new Vector<XmlParagraph>();
        }
        this.paragraphs.clear();
        this.selectedSegmentIndex = -1;
        this.selectableSegments = null;
    }

    IFocusSelectable[] getFocusSelectableSegments() {
        if (this.selectableSegments != null || this.paragraphs == null) {
            return this.selectableSegments;
        }
        ArrayList<XmlParagraphSegment> arrayList = new ArrayList<XmlParagraphSegment>();
        for (XmlParagraph xmlParagraph : this.paragraphs) {
            XmlParagraphSegment[] xmlParagraphSegmentArray;
            XmlParagraphSegment[] xmlParagraphSegmentArray2 = xmlParagraphSegmentArray = xmlParagraph.getSegments();
            int n = xmlParagraphSegmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlParagraphSegment xmlParagraphSegment = xmlParagraphSegmentArray2[n2];
                if (xmlParagraphSegment instanceof IFocusSelectable) {
                    arrayList.add(xmlParagraphSegment);
                }
                ++n2;
            }
        }
        this.selectableSegments = arrayList.toArray(new IFocusSelectable[arrayList.size()]);
        return this.selectableSegments;
    }

    public IHyperlinkSegment getHyperlink(int n) {
        IFocusSelectable iFocusSelectable;
        IFocusSelectable[] iFocusSelectableArray = this.getFocusSelectableSegments();
        if (iFocusSelectableArray.length > n && (iFocusSelectable = iFocusSelectableArray[n]) instanceof IHyperlinkSegment) {
            return (IHyperlinkSegment)iFocusSelectable;
        }
        return null;
    }

    public IHyperlinkSegment findHyperlinkAt(int n, int n2) {
        IFocusSelectable[] iFocusSelectableArray;
        IFocusSelectable[] iFocusSelectableArray2 = iFocusSelectableArray = this.getFocusSelectableSegments();
        int n3 = iFocusSelectableArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IHyperlinkSegment iHyperlinkSegment;
            IFocusSelectable iFocusSelectable = iFocusSelectableArray2[n4];
            if (iFocusSelectable instanceof IHyperlinkSegment && (iHyperlinkSegment = (IHyperlinkSegment)iFocusSelectable).contains(n, n2)) {
                return iHyperlinkSegment;
            }
            ++n4;
        }
        return null;
    }

    public int getHyperlinkCount() {
        return this.getFocusSelectableSegments().length;
    }

    public int indexOf(IHyperlinkSegment iHyperlinkSegment) {
        IFocusSelectable[] iFocusSelectableArray = this.getFocusSelectableSegments();
        int n = 0;
        while (n < iFocusSelectableArray.length) {
            IHyperlinkSegment iHyperlinkSegment2;
            IFocusSelectable iFocusSelectable = iFocusSelectableArray[n];
            if (iFocusSelectable instanceof IHyperlinkSegment && iHyperlinkSegment == (iHyperlinkSegment2 = (IHyperlinkSegment)iFocusSelectable)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public XmlParagraphSegment findSegmentAt(int n, int n2) {
        for (XmlParagraph xmlParagraph : this.paragraphs) {
            XmlParagraphSegment xmlParagraphSegment = xmlParagraph.findSegmentAt(n, n2);
            if (xmlParagraphSegment == null) continue;
            return xmlParagraphSegment;
        }
        return null;
    }

    public IFocusSelectable getSelectedSegment() {
        if (this.selectableSegments == null || this.selectedSegmentIndex == -1) {
            return null;
        }
        return this.selectableSegments[this.selectedSegmentIndex];
    }

    public int getSelectedSegmentIndex() {
        return this.selectedSegmentIndex;
    }

    public boolean linkExists(IHyperlinkSegment iHyperlinkSegment) {
        if (this.selectableSegments == null) {
            return false;
        }
        IFocusSelectable[] iFocusSelectableArray = this.selectableSegments;
        int n = this.selectableSegments.length;
        int n2 = 0;
        while (n2 < n) {
            IFocusSelectable iFocusSelectable = iFocusSelectableArray[n2];
            if (iFocusSelectable == iHyperlinkSegment) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void selectLink(IHyperlinkSegment iHyperlinkSegment) {
        if (iHyperlinkSegment == null) {
            this.selectedSegmentIndex = -1;
        } else {
            this.select((IFocusSelectable)iHyperlinkSegment);
        }
    }

    public void select(IFocusSelectable iFocusSelectable) {
        IFocusSelectable[] iFocusSelectableArray = this.getFocusSelectableSegments();
        this.selectedSegmentIndex = -1;
        if (iFocusSelectableArray == null) {
            return;
        }
        int n = 0;
        while (n < iFocusSelectableArray.length) {
            if (iFocusSelectableArray[n].equals(iFocusSelectable)) {
                this.selectedSegmentIndex = n;
                break;
            }
            ++n;
        }
    }

    public boolean hasFocusSegments() {
        IFocusSelectable[] iFocusSelectableArray = this.getFocusSelectableSegments();
        return iFocusSelectableArray.length > 0;
    }

    public void dispose() {
        this.paragraphs = null;
        this.selectedSegmentIndex = -1;
        this.selectableSegments = null;
    }

    public boolean isWhitespaceNormalized() {
        return this.whitespaceNormalized;
    }

    public void setWhitespaceNormalized(boolean bl) {
        this.whitespaceNormalized = bl;
    }

    public static class ParseErrorHandler
    implements ErrorHandler {
        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            DEBUG.OUT((Object)sAXParseException.getMessage());
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            DEBUG.OUT((Object)sAXParseException.getMessage());
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            DEBUG.OUT((Object)sAXParseException.getMessage());
        }
    }
}

