/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import com.google.common.primitives.Ints;
import gama.core.common.util.StringUtils;
import gama.core.kernel.experiment.ExperimentParameter;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.types.GamaStringType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.gaml.variables.Variable;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.interfaces.IParameterEditor;
import gama.ui.shared.parameters.ComboEditorControl;
import gama.ui.shared.parameters.EditorControl;
import gama.ui.shared.parameters.EditorLabel;
import gama.ui.shared.parameters.EditorToolbar;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.parameters.FixedValueEditorControl;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.Objects;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractEditor<T>
implements SelectionListener,
ModifyListener,
IParameterEditor<T> {
    private static int ORDER;
    private final int order = ORDER++;
    private final EditorListener<T> listener;
    private final IAgent agent;
    private final IScope scope;
    protected String name;
    protected final IParameter param;
    protected T originalValue;
    protected T currentValue;
    protected T minValue;
    protected T stepValue;
    protected T maxValue;
    protected boolean acceptNull = true;
    protected boolean isSubParameter;
    protected volatile boolean internalModification;
    protected IType<?> expectedType = Types.NO_TYPE;
    protected Composite composite;
    protected EditorsGroup parent;
    protected EditorToolbar editorToolbar;
    protected EditorLabel editorLabel;
    protected EditorControl editorControl;

    public AbstractEditor(IAgent iAgent, IParameter iParameter, EditorListener<T> editorListener) {
        this.param = iParameter;
        this.agent = iAgent;
        if (this.agent == null) {
            throw GamaRuntimeException.error((String)"The parameters view cannot be opened.", (IScope)iAgent.getScope());
        }
        this.scope = this.agent.getScope().copy("in editor");
        this.name = this.param.getTitle();
        this.expectedType = this.param.getType();
        this.computeMaxMinAndStepValues();
        this.listener = editorListener;
        try {
            this.originalValue = this.retrieveValueOfParameter(false);
            this.currentValue = this.originalValue;
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("Impossible to obtain the value of " + this.name);
            GAMA.reportError((IScope)GAMA.getRuntimeScope(), (GamaRuntimeException)gamaRuntimeException, (boolean)false);
        }
    }

    protected void computeMaxMinAndStepValues() {
        Object object = this.param.getMinValue(this.getScope());
        if (object != null) {
            this.minValue = this.castValueToInnerType(object);
        }
        if ((object = this.param.getMaxValue(this.getScope())) != null) {
            this.maxValue = this.castValueToInnerType(object);
        }
        if ((object = this.param.getStepValue(this.getScope())) != null) {
            this.stepValue = this.castValueToInnerType(object);
        }
        if (this.getStepValue() == null) {
            this.stepValue = this.defaultStepValue();
        }
    }

    protected T castValueToInnerType(Object object) {
        return (T)this.getExpectedType().cast(this.getScope(), object, null, false);
    }

    @Override
    public void isSubParameter(boolean bl) {
        this.isSubParameter = bl;
    }

    protected abstract int[] getToolItems();

    protected T defaultStepValue() {
        return null;
    }

    @Override
    public IType<?> getExpectedType() {
        return this.expectedType;
    }

    public IScope getScope() {
        return this.scope;
    }

    @Override
    public void setActive(Boolean bl) {
        if (this.editorLabel != null) {
            this.editorLabel.setActive(bl);
        }
        this.editorToolbar.setActive(bl);
        this.editorControl.setActive(bl);
    }

    protected T retrieveValueOfParameter(boolean bl) throws GamaRuntimeException {
        try {
            Object object = this.getScope() != null && bl || this.agent.getSpecies().hasVar(this.param.getName()) ? this.getScope().getAgentVarValue(this.getAgent(), this.param.getName()) : this.param.value(this.getScope());
            if (this.getExpectedType() == Types.STRING) {
                return (T)StringUtils.toJavaString((String)GamaStringType.staticCast((IScope)this.getScope(), (Object)object, (boolean)false));
            }
            return (T)this.getExpectedType().cast(this.getScope(), object, null, false);
        }
        catch (Exception exception) {
            throw GamaRuntimeException.create((Throwable)exception, (IScope)this.getScope());
        }
    }

    private final void modifyValueOfParameterWith(Object object) throws GamaRuntimeException {
        if (this.param instanceof ExperimentParameter && GAMA.getCurrentTopLevelAgent() instanceof SimulationAgent) {
            this.agent.getScope().setAgentVarValue(this.agent, this.param.getName(), object);
        } else if (this.param instanceof Variable) {
            ((Variable)this.param).setVal(this.getScope(), this.agent, object);
            return;
        }
        this.param.setValue(this.agent.getScope(), object);
    }

    @Override
    public int compareTo(IParameterEditor<T> iParameterEditor) {
        return Ints.compare((int)this.order, (int)iParameterEditor.getOrder());
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public EditorLabel getLabel() {
        return this.editorLabel;
    }

    public Control getEditor() {
        return this.editorControl.getControl();
    }

    @Override
    public void createControls(EditorsGroup editorsGroup) {
        this.parent = editorsGroup;
        this.internalModification = true;
        this.editorLabel = this.createEditorLabel();
        this.composite = this.createValueComposite();
        this.editorControl = this.createEditorControl();
        this.editorToolbar = this.createEditorToolbar();
        this.internalModification = false;
        editorsGroup.requestLayout();
    }

    Composite createValueComposite() {
        this.composite = new Composite((Composite)this.parent, 0);
        GamaColors.setBackground(this.parent.getBackground(), new Control[]{this.composite});
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.minimumWidth = 100;
        this.composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        this.composite.setLayout((Layout)gridLayout);
        return this.composite;
    }

    EditorLabel createEditorLabel() {
        this.editorLabel = new EditorLabel(this, this.parent, this.name, this.isSubParameter);
        return this.editorLabel;
    }

    Color getEditorControlBackground() {
        return this.parent.getBackground();
    }

    Color getEditorControlForeground() {
        return GamaColors.getTextColorForBackground(this.getEditorControlBackground()).color();
    }

    EditorToolbar createEditorToolbar() {
        this.editorToolbar = new EditorToolbar(this, this.parent);
        this.updateToolbar();
        return this.editorToolbar;
    }

    EditorControl createEditorControl() {
        boolean bl = this.param.getAmongValue(this.getScope()) != null;
        boolean bl2 = this.param.isEditable();
        this.editorControl = bl2 ? (bl ? new ComboEditorControl(this, this.composite, this.getExpectedType(), this.param.getAmongValue(this.getScope())) : new EditorControl<Control>(this, this.createCustomParameterControl(this.composite))) : new FixedValueEditorControl(this, this.composite);
        this.editorControl.displayParameterValue();
        return this.editorControl;
    }

    protected T getMinValue() {
        return this.minValue;
    }

    protected T getMaxValue() {
        return this.maxValue;
    }

    protected T getStepValue() {
        return this.stepValue;
    }

    protected EditorListener<?> getListener() {
        return this.listener;
    }

    protected void setParameterValue(T t) {
        WorkbenchHelper.asyncRun(() -> {
            try {
                if (this.listener == null) {
                    this.modifyValueOfParameterWith(t);
                } else {
                    this.listener.valueModified(t);
                }
            }
            catch (Exception exception) {
                GamaRuntimeException gamaRuntimeException = GamaRuntimeException.create((Throwable)exception, (IScope)this.getScope());
                gamaRuntimeException.addContext("Value of " + this.name + " cannot be modified");
                GAMA.reportError((IScope)this.getScope(), (GamaRuntimeException)gamaRuntimeException, (boolean)false);
                return;
            }
        });
    }

    protected Object getEditorControlGridData() {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.minimumWidth = 50;
        return gridData;
    }

    protected abstract Control createCustomParameterControl(Composite var1) throws GamaRuntimeException;

    protected abstract void displayParameterValue();

    @Override
    public boolean isValueModified() {
        return this.isValueDifferentFrom(this.getOriginalValue());
    }

    public boolean isValueDifferentFrom(Object object) {
        return !Objects.equals(this.currentValue, object);
    }

    @Override
    public void revertToDefaultValue() {
        this.modifyAndDisplayValue(this.getOriginalValue());
    }

    @Override
    public IParameter getParam() {
        return this.param;
    }

    protected boolean modifyValue(Object object) throws GamaRuntimeException {
        if (!this.isValueDifferentFrom(object)) {
            return true;
        }
        this.currentValue = object;
        this.editorLabel.signalChanged(this.isValueModified());
        if (!this.internalModification) {
            this.setParameterValue(this.currentValue);
        }
        return true;
    }

    @Override
    public void updateWithValueOfParameter(boolean bl, boolean bl2) {
        try {
            T t = this.retrieveValueOfParameter(bl2);
            this.currentValue = t;
            Runnable runnable = () -> {
                this.internalModification = true;
                if (this.parent != null && !this.parent.isDisposed()) {
                    this.editorControl.updateAmongValues(this.param.getAmongValue(this.getScope()));
                    this.computeMaxMinAndStepValues();
                    if (this.editorLabel != null) {
                        this.editorLabel.signalChanged(this.isValueModified());
                    }
                    this.editorControl.displayParameterValue();
                    this.updateToolbar();
                    this.composite.update();
                }
                this.internalModification = false;
            };
            if (bl) {
                WorkbenchHelper.run(runnable);
            } else {
                WorkbenchHelper.asyncRun(runnable);
            }
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("Unable to obtain the value of " + this.name);
            GAMA.reportError((IScope)GAMA.getRuntimeScope(), (GamaRuntimeException)gamaRuntimeException, (boolean)false);
            return;
        }
    }

    protected final void modifyAndDisplayValue(T t) {
        this.modifyValue(t);
        WorkbenchHelper.asyncRun(() -> {
            this.editorControl.displayParameterValue();
            this.updateToolbar();
        });
    }

    protected void updateToolbar() {
        if (this.editorToolbar != null && !this.editorToolbar.isDisposed()) {
            this.editorToolbar.update();
        }
    }

    protected IAgent getAgent() {
        return this.agent;
    }

    public void modifyText(ModifyEvent modifyEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    protected T getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public T getCurrentValue() {
        return this.currentValue;
    }

    protected void setOriginalValue(T t) {
        this.originalValue = t;
    }

    protected T applyPlus() {
        return null;
    }

    protected T applyMinus() {
        return null;
    }

    protected T applyRevert() {
        return this.getOriginalValue();
    }

    protected void applyBrowse() {
    }

    protected void applyInspect() {
    }

    protected void applyEdit() {
    }

    protected void applyChange() {
    }

    protected void applyDefine() {
    }

    protected void applySave() {
    }

    public void dispose() {
        if (this.editorLabel != null && !this.editorLabel.isDisposed()) {
            this.editorLabel.dispose();
            this.editorLabel = null;
        }
        if (this.editorControl != null && !this.editorControl.getControl().isDisposed()) {
            this.editorControl.getControl().dispose();
            this.editorControl = null;
        }
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.dispose();
            this.composite = null;
        }
        GAMA.releaseScope((IScope)this.scope);
    }

    @Override
    public boolean isDisposed() {
        if (this.editorLabel != null && this.editorLabel.isDisposed() || this.editorControl != null && this.editorControl.isDisposed()) {
            return true;
        }
        return this.composite != null && this.composite.isDisposed();
    }
}

