/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.parameters.NumberEditor;

public class IntEditor
extends NumberEditor<Integer> {
    IntEditor(IAgent iAgent, IParameter iParameter, boolean bl, EditorListener<Integer> editorListener) {
        super(iAgent, iParameter, editorListener, bl);
    }

    @Override
    protected Integer defaultStepValue() {
        return 1;
    }

    @Override
    protected Integer applyPlus() {
        if (this.currentValue == null) {
            return 0;
        }
        Integer n = (Integer)this.currentValue;
        return n + (Integer)this.getStepValue();
    }

    @Override
    protected Integer applyMinus() {
        if (this.currentValue == null) {
            return 0;
        }
        Integer n = (Integer)this.currentValue;
        return n - (Integer)this.getStepValue();
    }

    @Override
    protected boolean modifyValue(Object object) throws GamaRuntimeException {
        int n = Cast.asInt((IScope)this.getScope(), (Object)object);
        if (this.getMinValue() != null && n < Cast.asInt((IScope)this.getScope(), this.getMinValue())) {
            throw GamaRuntimeException.error((String)("Value " + n + " should be greater than " + String.valueOf(this.getMinValue())), (IScope)this.getScope());
        }
        if (this.getMaxValue() != null && n > Cast.asInt((IScope)this.getScope(), this.getMaxValue())) {
            throw GamaRuntimeException.error((String)("Value " + n + " should be smaller than " + String.valueOf(this.getMaxValue())), (IScope)this.getScope());
        }
        return super.modifyValue(n);
    }

    @Override
    protected void updateToolbar() {
        super.updateToolbar();
        this.editorToolbar.enable(0, this.param.isDefined() && (this.getMaxValue() == null || this.applyPlus() < Cast.asInt((IScope)this.getScope(), this.getMaxValue())));
        this.editorToolbar.enable(1, this.param.isDefined() && (this.getMinValue() == null || this.applyMinus() > Cast.asInt((IScope)this.getScope(), this.getMinValue())));
    }

    @Override
    protected Integer normalizeValues() throws GamaRuntimeException {
        Integer n = this.getOriginalValue() == null ? 0 : Cast.asInt((IScope)this.getScope(), this.getOriginalValue());
        this.currentValue = this.getOriginalValue() == null ? null : n;
        return n;
    }

    @Override
    public IType<Integer> getExpectedType() {
        return Types.INT;
    }
}

