/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.GamaObjectMatrix;
import gama.core.util.matrix.IMatrix;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MatrixEditorDialog
extends Dialog {
    IMatrix data;
    Composite container = null;
    Table table = null;
    final IScope scope;
    final Color gray = WorkbenchHelper.getDisplay().getSystemColor(15);

    protected MatrixEditorDialog(IScope iScope, Shell shell, IMatrix iMatrix) {
        super(shell);
        this.scope = iScope;
        this.data = iMatrix;
    }

    protected Control createDialogArea(Composite composite) {
        TableColumn tableColumn;
        this.container = (Composite)super.createDialogArea(composite);
        this.table = new Table(this.container, 68354);
        this.container.setLayout((Layout)new FillLayout());
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(false);
        TableColumn tableColumn2 = new TableColumn(this.table, 0x1000000);
        tableColumn2.setWidth(30);
        int n = 0;
        int n2 = 0;
        while (n2 < this.data.getCols(this.scope)) {
            tableColumn = new TableColumn(this.table, 0x1000000);
            tableColumn.setWidth(90);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.data.getRows(this.scope)) {
            tableColumn = new TableItem(this.table, 0);
            tableColumn.setText(0, String.valueOf(n));
            tableColumn.setBackground(0, this.gray);
            ++n;
            int n3 = 0;
            while (n3 < this.data.getCols(this.scope)) {
                tableColumn.setText(n3 + 1, String.valueOf(this.data.get(this.scope, n3, n2)));
                ++n3;
            }
            ++n2;
        }
        TableEditor tableEditor = new TableEditor(this.table);
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        this.table.addListener(3, event2 -> {
            Rectangle rectangle = this.table.getClientArea();
            Point point = new Point(event2.x, event2.y);
            int n = this.table.getTopIndex();
            while (n < this.table.getItemCount()) {
                boolean bl = false;
                TableItem tableItem = this.table.getItem(n);
                int n2 = 1;
                while (n2 < this.table.getColumnCount()) {
                    Rectangle rectangle2 = tableItem.getBounds(n2);
                    if (rectangle2.contains(point)) {
                        int n3 = n2;
                        Text text = new Text((Composite)this.table, 0);
                        Listener listener = event -> {
                            switch (event.type) {
                                case 16: {
                                    tableItem.setText(n3, text.getText());
                                    text.dispose();
                                    break;
                                }
                                case 31: {
                                    switch (event.detail) {
                                        case 4: {
                                            tableItem.setText(n3, text.getText());
                                        }
                                        case 2: {
                                            text.dispose();
                                            event.doit = false;
                                        }
                                    }
                                }
                            }
                        };
                        text.addListener(16, listener);
                        text.addListener(31, listener);
                        tableEditor.setEditor((Control)text, tableItem, n2);
                        text.setText(tableItem.getText(n2));
                        text.selectAll();
                        text.setFocus();
                        return;
                    }
                    if (!bl && rectangle2.intersects(rectangle)) {
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) {
                    return;
                }
                ++n;
            }
        });
        tableColumn = new Button(composite, 0x1000008);
        tableColumn.setText("Add a row");
        GridData gridData = new GridData(4, 2, true, false);
        gridData.widthHint = 80;
        tableColumn.setLayoutData((Object)gridData);
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem;
                int n;
                int n2 = MatrixEditorDialog.this.table.getSelectionIndex();
                int n3 = MatrixEditorDialog.this.table.getItemCount();
                if (MatrixEditorDialog.this.table.getSelectionIndices().length == 0) {
                    n = n3;
                    tableItem = new TableItem(MatrixEditorDialog.this.table, 0x1000000);
                    tableItem.setText(0, String.valueOf(n));
                } else {
                    n = n2 + 1;
                    tableItem = new TableItem(MatrixEditorDialog.this.table, 0x1000000, n);
                    tableItem.setText(0, String.valueOf(n));
                }
                tableItem.setBackground(0, MatrixEditorDialog.this.gray);
                MatrixEditorDialog.this.table.deselect(n2);
                MatrixEditorDialog.this.table.select(n);
                MatrixEditorDialog.this.refreshColumnIndex(n);
            }
        });
        Button button = new Button(composite, 0x1000008);
        button.setText("Delete this row");
        button.setEnabled(false);
        button.setLayoutData((Object)gridData);
        this.table.addListener(13, arg_0 -> this.lambda$2(button, (Button)tableColumn, arg_0));
        button.addListener(13, arg_0 -> this.lambda$3(button, (Button)tableColumn, arg_0));
        this.container.addDisposeListener(disposeEvent -> {
            try {
                this.data = this.getNewMatrix();
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                GAMA.reportError((IScope)GAMA.getRuntimeScope(), (GamaRuntimeException)gamaRuntimeException, (boolean)false);
            }
        });
        return this.container;
    }

    public void refreshColumnIndex(int n) {
        int n2 = this.table.getItemCount();
        int n3 = n;
        while (n3 < n2) {
            TableItem tableItem = this.table.getItem(n3);
            tableItem.setText(0, String.valueOf(n3));
            ++n3;
        }
    }

    private IMatrix getNewMatrix() throws GamaRuntimeException {
        int n = this.table.getItemCount();
        int n2 = this.table.getColumnCount() - 1;
        IMatrix iMatrix = this.createMatrix(n, n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 1;
            while (n4 < n2 + 1) {
                TableItem tableItem = this.table.getItem(n3);
                iMatrix.set(this.scope, n4 - 1, n3, (Object)tableItem.getText(n4));
                ++n4;
            }
            ++n3;
        }
        return iMatrix;
    }

    private IMatrix createMatrix(int n, int n2) {
        if (this.data instanceof GamaIntMatrix) {
            return new GamaIntMatrix(n2, n);
        }
        if (this.data instanceof GamaFloatMatrix) {
            return new GamaFloatMatrix(n2, n);
        }
        return new GamaObjectMatrix(n2, n, this.data.getGamlType().getContentType());
    }

    public IMatrix getMatrix() {
        return this.data;
    }

    private /* synthetic */ void lambda$2(Button button, Button button2, Event event) {
        if (this.table.getSelectionIndices().length != 0) {
            button.setEnabled(true);
            button2.setText("Add a row after this position");
        } else {
            button.setEnabled(false);
        }
    }

    private /* synthetic */ void lambda$3(Button button, Button button2, Event event) {
        int n = this.table.getSelectionIndex();
        this.table.remove(this.table.getSelectionIndices());
        button.setEnabled(false);
        button2.setText("Add a row");
        this.refreshColumnIndex(n);
    }
}

