/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.common.util.StringUtils;
import gama.core.kernel.experiment.IParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.util.GamaPair;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.resources.GamaColors;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PairEditor
extends AbstractEditor<GamaPair>
implements VerifyListener {
    private static final String[] LABELS = new String[]{"key", "value"};
    private static final int LABEL_WIDTH = 25;
    private static final int SPACING = 4;
    private static final int MARGIN = 2;
    private Composite pointEditor;
    private boolean allowVerification;
    private boolean isReverting;
    private final Text[] ordinates = new Text[2];
    private final Label[] labels = new Label[2];

    PairEditor(IAgent iAgent, IParameter iParameter, EditorListener<GamaPair> editorListener) {
        super(iAgent, iParameter, editorListener);
    }

    @Override
    public Control createCustomParameterControl(Composite composite) {
        this.pointEditor = new Composite(composite, 0);
        RowLayout rowLayout = RowLayoutFactory.fillDefaults().center(true).spacing(4).margins(2, 2).type(256).fill(true).wrap(false).create();
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.pointEditor.setLayoutData((Object)gridData);
        this.pointEditor.setLayout((Layout)rowLayout);
        this.pointEditor.addListener(9, event -> {
            Label label;
            GC gC = event.gc;
            Rectangle rectangle = this.pointEditor.getBounds();
            Color color = composite.getBackground();
            Color color2 = ThemeHelper.isDark() ? GamaColors.get(color).lighter() : GamaColors.get(color).darker();
            gC.setBackground(color2);
            gC.fillRoundRectangle(0, 0, rectangle.width, rectangle.height, 5, 5);
            Label[] labelArray = this.labels;
            int n = this.labels.length;
            int n2 = 0;
            while (n2 < n) {
                label = labelArray[n2];
                label.setBackground(color2);
                ++n2;
            }
            labelArray = this.ordinates;
            n = this.ordinates.length;
            n2 = 0;
            while (n2 < n) {
                label = labelArray[n2];
                label.setBackground(color);
                ++n2;
            }
        });
        int n = 0;
        while (n < 2) {
            this.labels[n] = new Label(this.pointEditor, 16384);
            this.labels[n].setText(LABELS[n]);
            RowDataFactory.swtDefaults().hint(25, -1).applyTo((Control)this.labels[n]);
            this.ordinates[n] = new Text(this.pointEditor, 0);
            RowDataFactory.swtDefaults().applyTo((Control)this.ordinates[n]);
            this.ordinates[n].addModifyListener((ModifyListener)this);
            ++n;
        }
        this.pointEditor.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                int n = (PairEditor.this.pointEditor.getSize().x - 70) / 2;
                Text[] textArray = PairEditor.this.ordinates;
                int n2 = PairEditor.this.ordinates.length;
                int n3 = 0;
                while (n3 < n2) {
                    Text text = textArray[n3];
                    ((RowData)text.getLayoutData()).width = n;
                    ++n3;
                }
            }
        });
        this.displayParameterValue();
        return this.pointEditor;
    }

    public void verifyText(VerifyEvent verifyEvent) {
        if (this.internalModification || !this.allowVerification) {
            return;
        }
        char c = verifyEvent.character;
        Text text = (Text)verifyEvent.widget;
        String string = text.getText();
        boolean bl = string.contains(".");
        boolean bl2 = verifyEvent.start == 0;
        verifyEvent.doit = Character.isDigit(c) || c == '\b' || c == '.' && !bl || c == '-' && bl2;
    }

    @Override
    protected void displayParameterValue() {
        this.allowVerification = false;
        GamaPair gamaPair = (GamaPair)this.currentValue;
        int n = 0;
        while (n < 3) {
            if (this.isReverting || !this.ordinates[0].isFocusControl()) {
                this.ordinates[0].setText(this.currentValue == null ? "nil" : StringUtils.toGaml((Object)gamaPair.getKey(), (boolean)false));
            }
            if (this.isReverting || !this.ordinates[1].isFocusControl()) {
                this.ordinates[1].setText(this.currentValue == null ? "nil" : StringUtils.toGaml((Object)gamaPair.getValue(), (boolean)false));
            }
            ++n;
        }
        this.isReverting = false;
        this.allowVerification = true;
    }

    @Override
    public void modifyText(ModifyEvent modifyEvent) {
        if (this.internalModification || !this.allowVerification) {
            return;
        }
        this.modifyAndDisplayValue(new GamaPair(this.getScope(), (Object)this.ordinates[0].getText(), (Object)this.ordinates[1].getText(), Types.NO_TYPE, Types.NO_TYPE));
    }

    @Override
    public IType getExpectedType() {
        return Types.PAIR;
    }

    @Override
    protected int[] getToolItems() {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 6;
        return nArray;
    }

    @Override
    protected GamaPair applyRevert() {
        this.isReverting = true;
        return (GamaPair)super.applyRevert();
    }
}

