/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.InputParameter;
import gama.core.kernel.experiment.TextStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.controls.text.XmlText;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.parameters.EditorLabel;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaFonts;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WebHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class TextDisplayer
extends AbstractEditor<TextStatement> {
    TextStatement statement;
    final Color back;
    final Color front;
    final GamaFont font;

    public TextDisplayer(IScope iScope, TextStatement textStatement) {
        super(iScope.getAgent(), (IParameter)new InputParameter(textStatement.getName(), null), null);
        this.statement = textStatement;
        GamaColor gamaColor = textStatement.getColor(iScope);
        GamaColor gamaColor2 = textStatement.getBackground(iScope);
        this.front = gamaColor == null ? null : GamaColors.toSwtColor((java.awt.Color)gamaColor);
        this.back = gamaColor2 == null ? null : GamaColors.toSwtColor((java.awt.Color)gamaColor2);
        this.font = textStatement.getFont(iScope);
    }

    public boolean isHtml(String string) {
        return string.contains("<html>");
    }

    @Override
    public void createControls(EditorsGroup editorsGroup) {
        this.parent = editorsGroup;
        this.internalModification = true;
        this.editorLabel = this.createEditorLabel();
        this.createValueComposite();
        this.editorControl = this.createEditorControl();
        this.editorToolbar = null;
        this.internalModification = false;
        editorsGroup.requestLayout();
    }

    @Override
    Composite createValueComposite() {
        this.composite = new Composite((Composite)this.parent, 0);
        GamaColors.setBackground(this.parent.getBackground(), new Control[]{this.composite});
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 100;
        gridData.horizontalSpan = 3;
        this.composite.setLayoutData((Object)gridData);
        FillLayout fillLayout = new FillLayout();
        this.composite.setLayout((Layout)fillLayout);
        return this.composite;
    }

    @Override
    protected Control createCustomParameterControl(Composite composite) throws GamaRuntimeException {
        String string = this.statement.getText(this.getScope());
        if (string == null) {
            return new Text(composite, 0);
        }
        Control control = string.contains("<html>") ? this.buildBrowser(composite, string) : this.buildForm(composite, string);
        GamaColors.setBackAndForeground(this.back, this.front, control);
        control.setFont(GamaFonts.getFont(this.font));
        composite.requestLayout();
        return control;
    }

    private Control buildForm(Composite composite, String string) {
        XmlText xmlText = new XmlText(composite, 8, this.font);
        xmlText.setText("<form><p>" + string + "</p></form>", true, true);
        xmlText.setHyperlinkSettings(this.getHyperlinkSettings());
        xmlText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                WebHelper.openPage(hyperlinkEvent.getHref().toString());
            }
        });
        return xmlText;
    }

    private HyperlinkSettings getHyperlinkSettings() {
        HyperlinkSettings hyperlinkSettings = new HyperlinkSettings(WorkbenchHelper.getDisplay());
        hyperlinkSettings.setActiveForeground(ThemeHelper.isDark() ? IGamaColors.TOOLTIP.color() : IGamaColors.DARK_ORANGE.color());
        hyperlinkSettings.setActiveBackground(this.back);
        hyperlinkSettings.setForeground(ThemeHelper.isDark() ? IGamaColors.TOOLTIP.color() : IGamaColors.DARK_ORANGE.color());
        hyperlinkSettings.setBackground(this.back);
        hyperlinkSettings.setHyperlinkUnderlineMode(2);
        hyperlinkSettings.setHyperlinkCursor(new Cursor((Device)WorkbenchHelper.getDisplay(), 0));
        hyperlinkSettings.setBusyCursor(new Cursor((Device)WorkbenchHelper.getDisplay(), 0));
        hyperlinkSettings.setTextCursor(new Cursor((Device)WorkbenchHelper.getDisplay(), 0));
        return hyperlinkSettings;
    }

    private Control buildBrowser(Composite composite, String string) {
        Browser browser = new Browser(composite, 8);
        browser.setText(string);
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent locationEvent) {
                WebHelper.openPage(locationEvent.location);
                locationEvent.doit = false;
            }
        });
        return browser;
    }

    @Override
    EditorLabel createEditorLabel() {
        return null;
    }

    @Override
    Color getEditorControlBackground() {
        return this.back == null ? super.getEditorControlBackground() : this.back;
    }

    @Override
    Color getEditorControlForeground() {
        return this.front == null ? super.getEditorControlForeground() : this.front;
    }

    @Override
    protected int[] getToolItems() {
        return new int[0];
    }

    @Override
    protected void displayParameterValue() {
    }
}

