/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis.geotools.styling;

import gama.ui.viewers.gis.geotools.styling.Mode;
import gama.ui.viewers.gis.geotools.styling.SimpleConfigurator;
import gama.ui.viewers.gis.geotools.styling.StolenColorEditor;
import java.awt.Color;
import java.text.MessageFormat;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;

public class StrokeViewer {
    boolean enabled = false;
    Color color = null;
    double width = Double.NaN;
    double opacity = Double.NaN;
    Button on;
    StolenColorEditor chooser;
    Combo size;
    Combo percent;
    Listener sync = new Listener();
    SelectionListener listener = null;

    public Composite createControl(Composite composite, KeyListener keyListener) {
        Composite composite2 = SimpleConfigurator.subpart(composite, "Line");
        this.on = new Button(composite2, 32);
        this.chooser = new StolenColorEditor(composite2, this.sync);
        this.size = new Combo(composite2, 4);
        this.size.setItems(new String[]{"1", "2", "3", "5", "10"});
        this.size.setTextLimit(2);
        this.size.addKeyListener(keyListener);
        this.size.setToolTipText("Line width");
        this.percent = new Combo(composite2, 4);
        this.percent.setItems(new String[]{"0%", "25%", "50%", "75%", "100%"});
        this.percent.setTextLimit(3);
        this.percent.addKeyListener(keyListener);
        this.percent.setToolTipText("Line opacity");
        return composite2;
    }

    public void addListener(SelectionListener selectionListener) {
        this.listener = selectionListener;
    }

    public void removeListener(SelectionListener selectionListener) {
        if (this.listener == selectionListener) {
            this.listener = null;
        }
    }

    protected void fire(SelectionEvent selectionEvent) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(selectionEvent);
    }

    void listen(boolean bl) {
        if (bl) {
            this.on.addSelectionListener((SelectionListener)this.sync);
            this.chooser.setListener(this.sync);
            this.size.addSelectionListener((SelectionListener)this.sync);
            this.size.addModifyListener((ModifyListener)this.sync);
            this.percent.addSelectionListener((SelectionListener)this.sync);
            this.percent.addModifyListener((ModifyListener)this.sync);
        } else {
            this.on.removeSelectionListener((SelectionListener)this.sync);
            this.chooser.setListener(null);
            this.size.removeSelectionListener((SelectionListener)this.sync);
            this.size.removeModifyListener((ModifyListener)this.sync);
            this.percent.removeSelectionListener((SelectionListener)this.sync);
            this.percent.removeModifyListener((ModifyListener)this.sync);
        }
    }

    public void setStroke(Stroke stroke, Mode mode, Color color) {
        this.listen(false);
        try {
            Object object;
            boolean bl = true;
            Stroke stroke2 = stroke;
            if (stroke2 == null) {
                object = new StyleBuilder();
                stroke2 = object.createStroke(color);
                bl = false;
            }
            this.enabled = bl && mode != Mode.NONE && stroke2 != null;
            this.color = SLD.color((Stroke)stroke2);
            this.width = SLD.width((Stroke)stroke2);
            this.opacity = SLD.opacity((Stroke)stroke2);
            this.on.setEnabled(mode != Mode.NONE);
            this.chooser.setColor(this.color);
            object = MessageFormat.format("{0,number,#0}", this.width);
            this.size.setText((String)object);
            this.size.select(this.size.indexOf((String)object));
            object = MessageFormat.format("{0,number,#0%}", this.opacity);
            this.percent.setText((String)object);
            this.percent.select(this.percent.indexOf((String)object));
            this.on.setSelection(this.enabled);
            this.chooser.setEnabled(this.enabled);
            this.size.setEnabled(this.enabled);
            this.percent.setEnabled(this.enabled);
        }
        finally {
            this.listen(true);
        }
    }

    public Stroke getStroke(StyleBuilder styleBuilder) {
        if (!this.enabled) {
            return null;
        }
        if (!Double.isNaN(this.opacity)) {
            return styleBuilder.createStroke(this.color, this.width, this.opacity);
        }
        if (!Double.isNaN(this.width)) {
            return styleBuilder.createStroke(this.color, this.width);
        }
        return styleBuilder.createStroke(this.color);
    }

    class Listener
    implements SelectionListener,
    ModifyListener {
        Listener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.sync(selectionEvent);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.sync(selectionEvent);
        }

        public void modifyText(ModifyEvent modifyEvent) {
            this.sync(SimpleConfigurator.selectionEvent(modifyEvent));
        }

        private void sync(SelectionEvent selectionEvent) {
            try {
                try {
                    StrokeViewer.this.enabled = StrokeViewer.this.on.getSelection();
                    StrokeViewer.this.color = StrokeViewer.this.chooser.getColor();
                    try {
                        StrokeViewer.this.width = Integer.parseInt(StrokeViewer.this.size.getText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    try {
                        String string = StrokeViewer.this.percent.getText();
                        if (string.endsWith("%")) {
                            string = string.substring(0, string.length() - 1);
                            StrokeViewer.this.opacity = Double.parseDouble(string);
                            StrokeViewer.this.opacity /= 100.0;
                        } else {
                            StrokeViewer.this.opacity = Double.parseDouble(string);
                            if (StrokeViewer.this.opacity > 1.0) {
                                StrokeViewer.this.opacity /= 100.0;
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    StrokeViewer.this.fire(selectionEvent);
                }
                catch (Throwable throwable) {
                    StrokeViewer.this.chooser.setEnabled(StrokeViewer.this.enabled);
                    StrokeViewer.this.size.setEnabled(StrokeViewer.this.enabled);
                    StrokeViewer.this.percent.setEnabled(StrokeViewer.this.enabled);
                }
            }
            finally {
                StrokeViewer.this.chooser.setEnabled(StrokeViewer.this.enabled);
                StrokeViewer.this.size.setEnabled(StrokeViewer.this.enabled);
                StrokeViewer.this.percent.setEnabled(StrokeViewer.this.enabled);
            }
        }
    }
}

