/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.csv;

import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.viewers.csv.model.CSVRow;
import gama.ui.viewers.csv.text.SearchResultStyle;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class CSVLabelProvider
extends StyledCellLabelProvider {
    private String searchText;
    private final Color searchColor = WorkbenchHelper.getDisplay().getSystemColor(7);

    public String getColumnText(Object object, int n) {
        CSVRow cSVRow = (CSVRow)object;
        if (cSVRow.getEntries().size() > n) {
            return cSVRow.getEntries().get(n);
        }
        return "";
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void setSearchText(String string) {
        this.searchText = string;
    }

    public void dispose() {
    }

    public void update(ViewerCell viewerCell) {
        CSVRow cSVRow = (CSVRow)viewerCell.getElement();
        int n = viewerCell.getColumnIndex();
        String string = this.getColumnText(cSVRow, n);
        viewerCell.setText(string);
        viewerCell.setImage(null);
        if (this.searchText != null && this.searchText.length() > 0) {
            int[] nArray = SearchResultStyle.getSearchTermOccurrences(this.searchText, string);
            ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
            int n2 = 0;
            while (n2 < nArray.length / 2) {
                StyleRange styleRange = new StyleRange(0, 0, null, this.searchColor);
                styleRange.start = nArray[n2];
                styleRange.length = nArray[++n2];
                arrayList.add(styleRange);
                ++n2;
            }
            viewerCell.setStyleRanges(arrayList.toArray(new StyleRange[arrayList.size()]));
        } else {
            viewerCell.setStyleRanges(null);
        }
        super.update(viewerCell);
    }
}

