/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.csv.model;

import gama.core.runtime.GAMA;
import gama.core.util.file.GamaCSVFile;
import gama.core.util.file.IGamaFileMetaData;
import gama.core.util.file.csv.AbstractCSVManipulator;
import gama.core.util.file.csv.CsvReader;
import gama.core.util.file.csv.CsvWriter;
import gama.dev.DEBUG;
import gama.ui.shared.interfaces.IRefreshHandler;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.viewers.csv.model.CSVRow;
import gama.ui.viewers.csv.model.ICsvFileModelListener;
import gama.ui.viewers.csv.model.IRowChangesListener;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class CSVModel
implements IRowChangesListener {
    private final boolean displayFirstLine;
    private final ArrayList<CSVRow> rows;
    private final ArrayList<ICsvFileModelListener> listeners;
    private final IFile file;
    private GamaCSVFile.CSVInfo currentInfo;

    public CSVModel(IFile iFile) {
        this.file = iFile;
        this.displayFirstLine = true;
        this.rows = new ArrayList();
        this.listeners = new ArrayList();
    }

    public boolean isFirstLineHeader() {
        return this.getInfo().header;
    }

    public void setFirstLineHeader(boolean bl) {
        GamaCSVFile.CSVInfo cSVInfo = this.getInfo();
        if (cSVInfo.header != bl) {
            cSVInfo.header = bl;
            this.saveMetaData();
        }
    }

    public char getCustomDelimiter() {
        return this.getInfo().delimiter.charValue();
    }

    public void setCustomDelimiter(char c) {
        GamaCSVFile.CSVInfo cSVInfo = this.getInfo();
        if (c == cSVInfo.delimiter.charValue()) {
            return;
        }
        cSVInfo.delimiter = Character.valueOf(c);
        this.saveMetaData();
    }

    public Character getTextQualifier() {
        return Character.valueOf(AbstractCSVManipulator.getDefaultQualifier());
    }

    public void setInput(String string) {
        this.readLines(string);
    }

    protected CsvReader initializeReader(Reader reader) {
        CsvReader csvReader = new CsvReader(reader);
        char c = this.getCustomDelimiter();
        csvReader.setDelimiter(c);
        return csvReader;
    }

    protected void readLines(String string) {
        this.readLines(new StringReader(string));
    }

    protected void readLines(Reader reader) {
        this.rows.clear();
        GamaCSVFile.CSVInfo cSVInfo = this.getInfo();
        cSVInfo.cols = 0;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CsvReader csvReader = this.initializeReader(reader);){
                if (!this.displayFirstLine) {
                    csvReader.skipLine();
                }
                boolean bl = false;
                while (csvReader.readRecord()) {
                    String[] stringArray = csvReader.getValues();
                    if (stringArray.length > cSVInfo.cols) {
                        cSVInfo.cols = stringArray.length;
                    }
                    CSVRow cSVRow = new CSVRow(stringArray, (IRowChangesListener)this);
                    if (cSVInfo.header && !bl) {
                        bl = true;
                        cSVRow.setHeader(true);
                        this.getInfo().headers = new String[this.getInfo().cols];
                        int n = 0;
                        while (n < this.getInfo().cols) {
                            this.getInfo().headers[n] = stringArray[n];
                            ++n;
                        }
                    }
                    this.rows.add(cSVRow);
                }
                if (!cSVInfo.header) {
                    this.getInfo().headers = new String[this.getInfo().cols];
                    int n = 0;
                    while (n < this.getInfo().cols) {
                        this.getInfo().headers[n] = "Column" + (n + 1);
                        ++n;
                    }
                }
                csvReader.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)("exception in readLines " + String.valueOf(exception)));
            exception.printStackTrace();
        }
        this.saveMetaData();
    }

    public List<String> getHeader() {
        return Arrays.asList(this.getInfo().headers);
    }

    public String[] getArrayHeader() {
        return this.getInfo().headers;
    }

    public void addRow() {
        CSVRow cSVRow = CSVRow.createEmptyLine(this.getInfo().cols, this);
        this.addRow(cSVRow);
    }

    public void addRow(CSVRow cSVRow) {
        this.rows.add(cSVRow);
        GamaCSVFile.CSVInfo cSVInfo = this.getInfo();
        ++cSVInfo.rows;
        this.saveMetaData();
    }

    public void addRowAfterElement(CSVRow cSVRow) {
        GamaCSVFile.CSVInfo cSVInfo = this.getInfo();
        CSVRow cSVRow2 = CSVRow.createEmptyLine(cSVInfo.cols, this);
        int n = this.findRow(cSVRow);
        if (n != -1) {
            this.rows.add(n, cSVRow2);
            ++cSVInfo.rows;
        } else {
            this.addRow(cSVRow2);
        }
        this.saveMetaData();
    }

    public int findRow(CSVRow cSVRow) {
        int n = 0;
        while (n <= this.getArrayRows(true).length) {
            CSVRow cSVRow2 = this.getRowAt(n);
            if (cSVRow2.equals(cSVRow)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public List<CSVRow> getRows() {
        return this.rows;
    }

    public Object[] getArrayRows(boolean bl) {
        ArrayList<CSVRow> arrayList = new ArrayList<CSVRow>();
        for (CSVRow cSVRow : this.rows) {
            if (cSVRow.isHeader()) continue;
            arrayList.add(cSVRow);
        }
        return arrayList.toArray();
    }

    public CSVRow getRowAt(int n) {
        return this.rows.get(n);
    }

    @Override
    public void rowChanged(CSVRow cSVRow, int n) {
        for (ICsvFileModelListener iCsvFileModelListener : this.listeners) {
            iCsvFileModelListener.entryChanged(cSVRow, n);
        }
    }

    public void removeRow(CSVRow cSVRow) {
        if (!this.rows.remove(cSVRow)) {
            return;
        }
        GamaCSVFile.CSVInfo cSVInfo = this.getInfo();
        --cSVInfo.rows;
        this.saveMetaData();
    }

    public void addColumn(String string) {
        GamaCSVFile.CSVInfo cSVInfo = this.getInfo();
        ++cSVInfo.cols;
        cSVInfo.headers = Arrays.copyOf(cSVInfo.headers, cSVInfo.headers.length + 1);
        cSVInfo.headers[cSVInfo.headers.length - 1] = string;
        for (CSVRow cSVRow : this.rows) {
            cSVRow.addElement("");
        }
        this.saveMetaData();
    }

    public int getColumnCount() {
        return this.getInfo().cols;
    }

    public void removeColumn(int n) {
        GamaCSVFile.CSVInfo cSVInfo = this.getInfo();
        if (cSVInfo.header) {
            ArrayList<String> object = new ArrayList<String>(Arrays.asList(cSVInfo.headers));
            object.remove(n);
            cSVInfo.headers = object.toArray(new String[object.size()]);
        }
        --cSVInfo.cols;
        for (CSVRow cSVRow : this.rows) {
            cSVRow.removeElementAt(n);
        }
        this.saveMetaData();
    }

    public void removeColumn(String string) {
        if (string == null) {
            return;
        }
        List<String> list = Arrays.asList(this.getInfo().headers);
        int n = list.indexOf(string);
        this.removeColumn(n);
    }

    public void removeModelListener(ICsvFileModelListener iCsvFileModelListener) {
        this.listeners.remove(iCsvFileModelListener);
    }

    public void addModelListener(ICsvFileModelListener iCsvFileModelListener) {
        if (!this.listeners.contains(iCsvFileModelListener)) {
            this.listeners.add(iCsvFileModelListener);
        }
    }

    protected CsvWriter initializeWriter(Writer writer) {
        char c = this.getCustomDelimiter();
        CsvWriter csvWriter = new CsvWriter(writer, c);
        csvWriter.setTextQualifier(this.getTextQualifier());
        return csvWriter;
    }

    /*
     * Loose catch block
     */
    public String getTextRepresentation() {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                String string;
                CsvWriter csvWriter;
                StringWriter stringWriter;
                block19: {
                    block18: {
                        stringWriter = new StringWriter();
                        csvWriter = this.initializeWriter(stringWriter);
                        for (CSVRow cSVRow : this.rows) {
                            csvWriter.writeRecord(cSVRow.getEntriesAsArray());
                        }
                        string = stringWriter.toString();
                        if (csvWriter == null) break block18;
                        csvWriter.close();
                    }
                    if (stringWriter == null) break block19;
                    stringWriter.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (csvWriter != null) {
                                csvWriter.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (stringWriter != null) {
                                stringWriter.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)"cannot write csv file");
            return "";
        }
    }

    public void saveMetaData() {
        IRefreshHandler iRefreshHandler = (IRefreshHandler)WorkbenchHelper.getService(IRefreshHandler.class);
        if (iRefreshHandler != null) {
            iRefreshHandler.refreshResource((IResource)this.file);
        }
    }

    public GamaCSVFile.CSVInfo getInfo() {
        if (this.currentInfo == null) {
            IGamaFileMetaData iGamaFileMetaData = GAMA.getGui().getMetaDataProvider().getMetaData((Object)this.file, false, true);
            if (iGamaFileMetaData instanceof GamaCSVFile.CSVInfo) {
                this.currentInfo = (GamaCSVFile.CSVInfo)iGamaFileMetaData;
            } else {
                GAMA.getGui().getMetaDataProvider().storeMetaData((IResource)this.file, null, true);
                this.currentInfo = (GamaCSVFile.CSVInfo)GAMA.getGui().getMetaDataProvider().getMetaData((Object)this.file, false, true);
            }
        }
        return this.currentInfo;
    }
}

