/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis;

import gama.ui.shared.resources.GamaIcon;
import gama.ui.viewers.gis.SwtMapPane;
import gama.ui.viewers.gis.geotools.styling.SimpleConfigurator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.geotools.data.FeatureSource;
import org.geotools.map.Layer;
import org.geotools.map.StyleLayer;
import org.geotools.styling.Style;

public class MaplayerTableViewer
extends TableViewer
implements ISelectionChangedListener {
    private final List<Layer> layersList = new ArrayList<Layer>();
    private Layer selectedMapLayer;
    private final String[] titles = new String[]{"Layer name", "Visible", "Style"};
    private SwtMapPane pane;

    public MaplayerTableViewer(Composite composite, int n) {
        super(composite, n);
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.addSelectionChangedListener(this);
        this.createColumns(composite);
        Table table = this.getTable();
        table.setHeaderVisible(true);
        this.setInput(this.layersList);
    }

    public void setPane(SwtMapPane swtMapPane) {
        this.pane = swtMapPane;
    }

    public List<Layer> getLayersList() {
        return this.layersList;
    }

    public Layer getSelectedMapLayer() {
        return this.selectedMapLayer;
    }

    private void createColumns(Composite composite) {
        int[] nArray = new int[]{120, 50, 50};
        TableViewerColumn tableViewerColumn = this.createTableViewerColumn(this.titles[0], nArray[0], 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object object) {
                return null;
            }

            public String getText(Object object) {
                if (object instanceof Layer) {
                    FeatureSource featureSource;
                    Layer layer = (Layer)object;
                    String string = layer.getTitle();
                    if ((string == null || string.length() == 0) && (featureSource = layer.getFeatureSource()) != null) {
                        string = featureSource.getName().getLocalPart();
                    }
                    return string;
                }
                return null;
            }
        });
        tableViewerColumn = this.createTableViewerColumn(this.titles[1], nArray[1], 1);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object object) {
                if (object instanceof Layer) {
                    Layer layer = (Layer)object;
                    if (layer.isVisible()) {
                        return GamaIcon.named((String)"overlays/small.inspect").image();
                    }
                    return GamaIcon.named((String)"overlays/small.hidden").image();
                }
                return null;
            }

            public String getText(Object object) {
                return null;
            }
        });
        tableViewerColumn = this.createTableViewerColumn(this.titles[2], nArray[2], 2);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object object) {
                return GamaIcon.named((String)"overlays/small.selectable").image();
            }

            public String getText(Object object) {
                return null;
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String string, int n, int n2) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText(string);
        tableColumn.setWidth(n);
        tableColumn.setResizable(true);
        tableColumn.setMoveable(true);
        return tableViewerColumn;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent == null) {
            this.selectedMapLayer = null;
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof Layer) {
            this.selectedMapLayer = (Layer)object;
        }
    }

    protected void triggerEditorActivationEvent(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
        super.triggerEditorActivationEvent(columnViewerEditorActivationEvent);
        ViewerCell viewerCell = (ViewerCell)columnViewerEditorActivationEvent.getSource();
        int n = viewerCell.getColumnIndex();
        if (n == 1) {
            Layer layer;
            layer.setVisible(!(layer = (Layer)viewerCell.getElement()).isVisible());
            this.refresh();
            this.pane.redraw();
        } else if (n == 2) {
            Layer layer = (Layer)viewerCell.getElement();
            try {
                this.doSetStyle(layer);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.pane.redraw();
        }
    }

    private void doSetStyle(Layer layer) throws IOException {
        if (layer instanceof StyleLayer) {
            StyleLayer styleLayer = (StyleLayer)layer;
            Style style = SimpleConfigurator.showDialog(this.getTable().getShell(), layer);
            if (style != null) {
                styleLayer.setStyle(style);
            }
        }
    }

    public void addLayer(Layer layer) {
        this.layersList.add(0, layer);
        this.refresh();
    }

    public void removeLayer(Layer layer) {
        this.layersList.remove(layer);
        this.refresh();
    }

    public void clear() {
        this.layersList.clear();
        this.refresh();
    }
}

