/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis;

import gama.ui.viewers.gis.MapLayerComposite;
import gama.ui.viewers.gis.geotools.styling.Utils;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapBoundsEvent;
import org.geotools.map.MapBoundsListener;
import org.geotools.map.MapContent;
import org.geotools.map.MapLayerListEvent;
import org.geotools.map.MapLayerListListener;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class SwtMapPane
extends Canvas
implements Listener,
MapLayerListListener,
MapBoundsListener,
MouseListener,
MouseMoveListener {
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);
    private static final int TRANSPARENT_COLOR = 1193046;
    private ReferencedEnvelope fullExtent;
    MapContent content;
    private GTRenderer renderer;
    private MapLayerComposite layerTable;
    private AffineTransform worldToScreen;
    private AffineTransform screenToWorld;
    org.eclipse.swt.graphics.Rectangle curPaintArea;
    private BufferedImage baseImage;
    private final java.awt.Point imageOrigin;
    private boolean redrawBaseImage;
    private Image swtImage;
    private GC gc;
    private boolean mouseDown = false;
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private boolean isDragging = false;
    private final Point panePos = new Point(0, 0);
    boolean panning;
    private int alpha = 255;
    private final Color white = this.getDisplay().getSystemColor(1);
    private final Color yellow = this.getDisplay().getSystemColor(7);
    private boolean locked = false;

    public SwtMapPane(Composite composite, int n, GTRenderer gTRenderer, MapContent mapContent) {
        super(composite, n);
        this.addListener(9, this);
        this.addListener(3, this);
        this.addListener(4, this);
        this.imageOrigin = new java.awt.Point(0, 0);
        this.redrawBaseImage = true;
        this.setRenderer(gTRenderer);
        this.setMapContent(mapContent);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                SwtMapPane.this.curPaintArea = SwtMapPane.this.getVisibleRect();
                SwtMapPane.this.doSetDisplayArea((org.opengis.geometry.Envelope)SwtMapPane.this.content.getViewport().getBounds());
            }
        });
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if (this.panning) {
            this.moveImage(mouseEvent.x - this.panePos.x, mouseEvent.y - this.panePos.y);
            this.panePos.x = mouseEvent.x;
            this.panePos.y = mouseEvent.y;
        }
        if (this.mouseDown && !this.locked) {
            this.endX = mouseEvent.x;
            this.endY = mouseEvent.y;
            this.isDragging = true;
            if (!this.isDisposed()) {
                this.redraw();
            }
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (!this.locked) {
            this.panePos.x = mouseEvent.x;
            this.panePos.y = mouseEvent.y;
            this.panning = true;
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (this.panning) {
            this.panning = false;
            this.redraw();
        }
    }

    public void setMapLayerTable(MapLayerComposite mapLayerComposite) {
        if (mapLayerComposite == null) {
            throw new IllegalArgumentException("The argument must not be null");
        }
        this.layerTable = mapLayerComposite;
    }

    public GTRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(GTRenderer gTRenderer) {
        if (gTRenderer instanceof StreamingRenderer && this.content != null) {
            gTRenderer.setMapContent(this.content);
        }
        this.renderer = gTRenderer;
    }

    public MapContent getMapContent() {
        return this.content;
    }

    public void setMapContent(MapContent mapContent) {
        if (this.content != mapContent) {
            if (this.content != null) {
                this.content.removeMapLayerListListener((MapLayerListListener)this);
            }
            this.content = mapContent;
            if (mapContent != null) {
                this.content.addMapLayerListListener((MapLayerListListener)this);
                this.content.addMapBoundsListener((MapBoundsListener)this);
                for (Layer layer : mapContent.layers()) {
                    layer.setSelected(true);
                }
                this.setFullExtent();
            }
            if (this.renderer != null) {
                this.renderer.setMapContent(this.content);
            }
        }
    }

    public ReferencedEnvelope getDisplayArea() {
        ReferencedEnvelope referencedEnvelope = null;
        if (this.curPaintArea != null && this.screenToWorld != null) {
            Rectangle rectangle = Utils.toAwtRectangle(this.curPaintArea);
            Point2D.Double double_ = new Point2D.Double(rectangle.getMinX(), rectangle.getMinY());
            Point2D.Double double_2 = new Point2D.Double(rectangle.getMaxX(), rectangle.getMaxY());
            this.screenToWorld.transform(double_, double_);
            this.screenToWorld.transform(double_2, double_2);
            referencedEnvelope = new ReferencedEnvelope(Math.min(((Point2D)double_).getX(), ((Point2D)double_2).getX()), Math.max(((Point2D)double_).getX(), ((Point2D)double_2).getX()), Math.min(((Point2D)double_).getY(), ((Point2D)double_2).getY()), Math.max(((Point2D)double_).getY(), ((Point2D)double_2).getY()), this.content.getCoordinateReferenceSystem());
        }
        return referencedEnvelope;
    }

    public void setCrs(CoordinateReferenceSystem coordinateReferenceSystem) {
        try {
            ReferencedEnvelope referencedEnvelope = this.getDisplayArea();
            CoordinateReferenceSystem coordinateReferenceSystem2 = referencedEnvelope.getCoordinateReferenceSystem();
            CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateReferenceSystem;
            MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)coordinateReferenceSystem2, (CoordinateReferenceSystem)coordinateReferenceSystem3);
            Envelope envelope = JTS.transform((Envelope)referencedEnvelope, (MathTransform)mathTransform);
            ReferencedEnvelope referencedEnvelope2 = new ReferencedEnvelope(envelope, coordinateReferenceSystem3);
            this.content.getViewport().setBounds(referencedEnvelope2);
            this.fullExtent = null;
            this.doSetDisplayArea((org.opengis.geometry.Envelope)referencedEnvelope2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setDisplayArea(org.opengis.geometry.Envelope envelope) {
        if (this.content != null) {
            if (this.curPaintArea == null || this.curPaintArea.isEmpty()) {
                return;
            }
            this.doSetDisplayArea(envelope);
            if (!this.isDisposed()) {
                this.redraw();
            }
        } else {
            throw new IllegalStateException("Map context must be set before setting the display area");
        }
    }

    void doSetDisplayArea(org.opengis.geometry.Envelope envelope) {
        assert (this.content != null && this.curPaintArea != null && !this.curPaintArea.isEmpty());
        if (this.equalsFullExtent(envelope)) {
            this.setTransforms((org.opengis.geometry.Envelope)this.fullExtent, this.curPaintArea);
        } else {
            this.setTransforms(envelope, this.curPaintArea);
        }
        ReferencedEnvelope referencedEnvelope = this.getDisplayArea();
        this.content.getViewport().setBounds(referencedEnvelope);
    }

    private boolean equalsFullExtent(org.opengis.geometry.Envelope envelope) {
        if (this.fullExtent == null || envelope == null) {
            return false;
        }
        double d = 1.0E-6 * (this.fullExtent.getWidth() + this.fullExtent.getHeight());
        boolean bl = false;
        if (Math.abs(envelope.getMinimum(0) - this.fullExtent.getMinimum(0)) < d) {
            bl = true;
        }
        if (Math.abs(envelope.getMaximum(0) - this.fullExtent.getMaximum(0)) < d && bl) {
            return true;
        }
        if (Math.abs(envelope.getMinimum(1) - this.fullExtent.getMinimum(1)) < d) {
            bl = true;
        }
        return Math.abs(envelope.getMaximum(1) - this.fullExtent.getMaximum(1)) < d && bl;
    }

    public void reset() {
        if (this.fullExtent == null) {
            this.setFullExtent();
        }
        try {
            this.fullExtent = new ReferencedEnvelope((org.opengis.geometry.Envelope)CRS.transform((org.opengis.geometry.Envelope)this.fullExtent, (CoordinateReferenceSystem)this.content.getCoordinateReferenceSystem()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setDisplayArea((org.opengis.geometry.Envelope)this.fullExtent);
    }

    public RenderedImage getBaseImage() {
        return this.baseImage;
    }

    public AffineTransform getScreenToWorldTransform() {
        if (this.screenToWorld != null) {
            return new AffineTransform(this.screenToWorld);
        }
        return null;
    }

    public AffineTransform getWorldToScreenTransform() {
        if (this.worldToScreen != null) {
            return new AffineTransform(this.worldToScreen);
        }
        return null;
    }

    public void moveImage(int n, int n2) {
        this.imageOrigin.translate(n, n2);
        this.redrawBaseImage = false;
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    private void afterImageMove() {
        ReferencedEnvelope referencedEnvelope = this.content.getViewport().getBounds();
        if (referencedEnvelope == null) {
            return;
        }
        int n = this.imageOrigin.x;
        int n2 = this.imageOrigin.y;
        DirectPosition2D directPosition2D = new DirectPosition2D((double)n, (double)n2);
        this.screenToWorld.transform((Point2D)directPosition2D, (Point2D)directPosition2D);
        referencedEnvelope.translate(referencedEnvelope.getMinimum(0) - directPosition2D.x, referencedEnvelope.getMaximum(1) - directPosition2D.y);
        this.doSetDisplayArea((org.opengis.geometry.Envelope)referencedEnvelope);
        this.imageOrigin.setLocation(0, 0);
        this.redrawBaseImage = true;
    }

    public void layerAdded(MapLayerListEvent mapLayerListEvent) {
        boolean bl;
        Layer layer = mapLayerListEvent.getLayer();
        if (this.layerTable != null) {
            this.layerTable.onAddLayer(layer);
        }
        layer.setSelected(true);
        this.redrawBaseImage = true;
        boolean bl2 = this.equalsFullExtent((org.opengis.geometry.Envelope)this.getDisplayArea());
        boolean bl3 = bl = this.content.layers().size() == 1;
        if (bl || bl2) {
            this.reset();
            if (bl) {
                this.setCrs(layer.getBounds().getCoordinateReferenceSystem());
                return;
            }
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void layerRemoved(MapLayerListEvent mapLayerListEvent) {
        Layer layer = mapLayerListEvent.getLayer();
        if (this.layerTable != null) {
            this.layerTable.onRemoveLayer(layer);
        }
        this.redrawBaseImage = true;
        if (this.content.layers().size() == 0) {
            this.clearFields();
        } else {
            this.setFullExtent();
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void layerChanged(MapLayerListEvent mapLayerListEvent) {
        if (this.layerTable != null) {
            this.layerTable.repaint(mapLayerListEvent.getLayer());
        }
        this.redrawBaseImage = true;
        int n = mapLayerListEvent.getMapLayerEvent().getReason();
        if (n == 3) {
            this.setFullExtent();
        }
        if (n != 6 && !this.isDisposed()) {
            this.redraw();
        }
    }

    public void layerMoved(MapLayerListEvent mapLayerListEvent) {
        this.redrawBaseImage = true;
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void mapBoundsChanged(MapBoundsEvent mapBoundsEvent) {
        this.redrawBaseImage = true;
        int n = mapBoundsEvent.getType();
        if ((n & 2) != 0) {
            this.setFullExtent();
            this.reset();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setFullExtent() {
        if (this.content != null && this.content.layers().size() > 0) {
            try {
                this.fullExtent = this.content.getMaxBounds();
                if (this.fullExtent != null) return;
                this.fullExtent = this.worldEnvelope();
                return;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        } else {
            this.fullExtent = null;
        }
    }

    private void setTransforms(org.opengis.geometry.Envelope envelope, org.eclipse.swt.graphics.Rectangle rectangle) {
        ReferencedEnvelope referencedEnvelope = null;
        referencedEnvelope = envelope != null ? new ReferencedEnvelope(envelope) : this.worldEnvelope();
        Rectangle rectangle2 = Utils.toAwtRectangle(rectangle);
        double d = rectangle2.getWidth() / referencedEnvelope.getWidth();
        double d2 = rectangle2.getHeight() / referencedEnvelope.getHeight();
        double d3 = Math.min(d, d2);
        double d4 = referencedEnvelope.getMedian(0) * d3 - rectangle2.getCenterX();
        double d5 = referencedEnvelope.getMedian(1) * d3 + rectangle2.getCenterY();
        this.worldToScreen = new AffineTransform(d3, 0.0, 0.0, -d3, -d4, d5);
        try {
            this.screenToWorld = this.worldToScreen.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
    }

    private ReferencedEnvelope worldEnvelope() {
        return new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    private void clearFields() {
        this.fullExtent = null;
        this.worldToScreen = null;
        this.screenToWorld = null;
    }

    public org.eclipse.swt.graphics.Rectangle getVisibleRect() {
        return this.getClientArea();
    }

    public void setBaseImageAlpha(int n) {
        this.alpha = n;
    }

    public void handleEvent(Event event) {
        this.curPaintArea = this.getVisibleRect();
        if (event.type == 3) {
            this.startX = event.x;
            this.startY = event.y;
            this.mouseDown = true;
        } else if (event.type == 4) {
            boolean bl;
            this.endX = event.x;
            this.endY = event.y;
            boolean bl2 = bl = this.startX != this.endX || this.startY != this.endY;
            if (bl) {
                this.afterImageMove();
            }
            this.mouseDown = false;
            this.isDragging = false;
        } else if (event.type == 9) {
            ReferencedEnvelope referencedEnvelope;
            this.gc = event.gc;
            if (this.isDragging) {
                if (this.gc != null && !this.gc.isDisposed() && this.swtImage != null) {
                    Image image = new Image((Device)this.getDisplay(), this.curPaintArea.width, this.curPaintArea.height);
                    GC gC = new GC((Drawable)image);
                    gC.setBackground(this.white);
                    gC.fillRectangle(0, 0, this.curPaintArea.width, this.curPaintArea.height);
                    gC.drawImage(this.swtImage, this.imageOrigin.x, this.imageOrigin.y);
                    this.gc.drawImage(image, 0, 0);
                    image.dispose();
                }
                return;
            }
            if (this.curPaintArea == null || this.content == null || this.renderer == null) {
                return;
            }
            if (this.content.layers().size() == 0) {
                this.gc.setForeground(this.yellow);
                this.gc.fillRectangle(0, 0, this.curPaintArea.width + 1, this.curPaintArea.height + 1);
            }
            if ((referencedEnvelope = this.content.getViewport().getBounds()) == null) {
                return;
            }
            if (this.redrawBaseImage) {
                this.baseImage = new BufferedImage(this.curPaintArea.width + 1, this.curPaintArea.height + 1, 2);
                Graphics2D graphics2D = this.baseImage.createGraphics();
                graphics2D.fillRect(0, 0, this.curPaintArea.width + 1, this.curPaintArea.height + 1);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle rectangle = Utils.toAwtRectangle(this.curPaintArea);
                this.renderer.paint(graphics2D, rectangle, referencedEnvelope, this.getWorldToScreenTransform());
                if (this.swtImage != null && !this.swtImage.isDisposed()) {
                    this.swtImage.dispose();
                    this.swtImage = null;
                }
                this.swtImage = new Image((Device)this.getDisplay(), this.awtToSwt(this.baseImage, this.curPaintArea.width + 1, this.curPaintArea.height + 1));
            }
            if (this.swtImage != null) {
                this.drawFinalImage(this.swtImage);
            }
            this.redrawBaseImage = false;
        }
    }

    private void drawFinalImage(Image image) {
        Image image2 = new Image((Device)this.getDisplay(), this.curPaintArea.width, this.curPaintArea.height);
        GC gC = new GC((Drawable)image2);
        gC.setBackground(this.white);
        gC.fillRectangle(0, 0, this.curPaintArea.width, this.curPaintArea.height);
        if (image != null) {
            gC.setAlpha(this.alpha);
            gC.drawImage(image, this.imageOrigin.x, this.imageOrigin.y);
        }
        if (this.gc != null && !this.gc.isDisposed()) {
            this.gc.drawImage(image2, this.imageOrigin.x, this.imageOrigin.y);
        }
        gC.dispose();
        image2.dispose();
    }

    private ImageData awtToSwt(BufferedImage bufferedImage, int n, int n2) {
        int[] nArray = new int[n * n2];
        ImageData imageData = new ImageData(n, n2, 24, PALETTE_DATA);
        imageData.transparentPixel = 1193046;
        int n3 = imageData.depth / 8;
        byte[] byArray = imageData.data;
        bufferedImage.getRGB(0, 0, n, n2, nArray, 0, n);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = (0 + n4) * imageData.bytesPerLine + 0 * n3;
            int n6 = 0;
            while (n6 < n) {
                int n7 = nArray[n6 + n4 * n];
                int n8 = imageData.depth - 8;
                while (n8 >= 0) {
                    byArray[n5++] = (byte)(n7 >> n8 & 0xFF);
                    n8 -= 8;
                }
                ++n6;
            }
            ++n4;
        }
        return imageData;
    }

    public void layerPreDispose(MapLayerListEvent mapLayerListEvent) {
    }
}

