/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis.geotools.styling;

import java.awt.Color;
import java.util.Set;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.Filters;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.SemanticType;

public class SLDs
extends SLD {
    private static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    public static final double ALIGN_LEFT = 1.0;
    public static final double ALIGN_CENTER = 0.5;
    public static final double ALIGN_RIGHT = 0.0;
    public static final double ALIGN_BOTTOM = 1.0;
    public static final double ALIGN_MIDDLE = 0.5;
    public static final double ALIGN_TOP = 0.0;
    public static final String GENERIC_FEATURE_TYPENAME = "Feature";

    public static int size(org.opengis.style.Graphic graphic) {
        if (graphic == null) {
            return -1;
        }
        return Filters.asInt((Expression)graphic.getSize());
    }

    public static Color polyFill(PolygonSymbolizer polygonSymbolizer) {
        if (polygonSymbolizer == null) {
            return null;
        }
        Fill fill = polygonSymbolizer.getFill();
        if (fill == null) {
            return null;
        }
        Expression expression = fill.getColor();
        return SLDs.color(expression);
    }

    public static Color color(Expression expression) {
        if (expression == null) {
            return null;
        }
        try {
            return (Color)expression.evaluate(null, Color.class);
        }
        catch (Throwable throwable) {
            class ColorVisitor
            implements ExpressionVisitor {
                Color found;

                ColorVisitor() {
                }

                public Object visit(Literal literal, Object object) {
                    if (this.found != null) {
                        return null;
                    }
                    try {
                        Color color = (Color)literal.evaluate((Object)literal, Color.class);
                        if (color != null) {
                            this.found = color;
                        }
                    }
                    catch (Throwable throwable) {}
                    return object;
                }

                public Object visit(NilExpression nilExpression, Object object) {
                    return object;
                }

                public Object visit(Add add, Object object) {
                    return object;
                }

                public Object visit(Divide divide, Object object) {
                    return null;
                }

                public Object visit(Function function, Object object) {
                    for (Expression expression : function.getParameters()) {
                        expression.accept((ExpressionVisitor)this, object);
                    }
                    return object;
                }

                public Object visit(Multiply multiply, Object object) {
                    return object;
                }

                public Object visit(PropertyName propertyName, Object object) {
                    return object;
                }

                public Object visit(Subtract subtract, Object object) {
                    return object;
                }
            }
            ColorVisitor colorVisitor = new ColorVisitor();
            expression.accept((ExpressionVisitor)colorVisitor, null);
            return colorVisitor.found;
        }
    }

    public static Color pointFillWithAlpha(PointSymbolizer pointSymbolizer) {
        if (pointSymbolizer == null) {
            return null;
        }
        Graphic graphic = pointSymbolizer.getGraphic();
        if (graphic == null) {
            return null;
        }
        for (GraphicalSymbol graphicalSymbol : graphic.graphicalSymbols()) {
            Mark mark;
            Fill fill;
            if (!(graphicalSymbol instanceof Mark) || (fill = (mark = (Mark)graphicalSymbol).getFill()) == null) continue;
            Color color = SLDs.color(fill.getColor());
            if (color == null) {
                return null;
            }
            Expression expression = fill.getOpacity();
            if (expression == null) {
                expression = ff.literal(1.0);
            }
            float f = (float)Filters.asDouble((Expression)expression);
            color = new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, f);
            return color;
        }
        return null;
    }

    public static boolean isSemanticTypeMatch(FeatureTypeStyle featureTypeStyle, String string) {
        Set set = featureTypeStyle.semanticTypeIdentifiers();
        for (SemanticType semanticType : set) {
            if (!semanticType.matches(string)) continue;
            return true;
        }
        return false;
    }

    public static double minScale(FeatureTypeStyle featureTypeStyle) {
        if (featureTypeStyle == null || featureTypeStyle.rules().size() == 0) {
            return 0.0;
        }
        Rule rule = (Rule)featureTypeStyle.rules().get(0);
        return rule.getMinScaleDenominator();
    }

    public static double maxScale(FeatureTypeStyle featureTypeStyle) {
        if (featureTypeStyle == null || featureTypeStyle.rules().size() == 0) {
            return Double.NaN;
        }
        Rule rule = (Rule)featureTypeStyle.rules().get(0);
        return rule.getMaxScaleDenominator();
    }

    public static final boolean isPolygon(SimpleFeatureType simpleFeatureType) {
        if (simpleFeatureType == null) {
            return false;
        }
        GeometryDescriptor geometryDescriptor = simpleFeatureType.getGeometryDescriptor();
        if (geometryDescriptor == null) {
            return false;
        }
        Class clazz = geometryDescriptor.getType().getBinding();
        return Polygon.class.isAssignableFrom(clazz) || MultiPolygon.class.isAssignableFrom(clazz);
    }

    public static final boolean isLine(SimpleFeatureType simpleFeatureType) {
        if (simpleFeatureType == null) {
            return false;
        }
        GeometryDescriptor geometryDescriptor = simpleFeatureType.getGeometryDescriptor();
        if (geometryDescriptor == null) {
            return false;
        }
        Class clazz = geometryDescriptor.getType().getBinding();
        return LineString.class.isAssignableFrom(clazz) || MultiLineString.class.isAssignableFrom(clazz);
    }

    public static final boolean isPoint(SimpleFeatureType simpleFeatureType) {
        if (simpleFeatureType == null) {
            return false;
        }
        GeometryDescriptor geometryDescriptor = simpleFeatureType.getGeometryDescriptor();
        if (geometryDescriptor == null) {
            return false;
        }
        Class clazz = geometryDescriptor.getType().getBinding();
        return Point.class.isAssignableFrom(clazz) || MultiPoint.class.isAssignableFrom(clazz);
    }
}

