/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.image;

import gama.core.runtime.GAMA;
import gama.core.util.file.IGamaFileMetaData;
import gama.dev.DEBUG;
import gama.ui.navigator.metadata.ImageDataLoader;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.PreferencesHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import gama.ui.viewers.image.SaveImageAsDialog;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class ImageViewer
extends EditorPart
implements IReusableEditor,
IToolbarDecoratedView.Zoomable,
IToolbarDecoratedView.Colorizable {
    GamaToolbar2 toolbar;
    Image image;
    ImageData imageData;
    ScrolledComposite scroll;
    Composite intermediate;
    Canvas imageCanvas;
    double zoomFactor = 1.0;
    double maxZoomFactor = 1.0;
    boolean locked = false;
    ImageResourceChangeListener inputListener = null;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof IStorageEditorInput) && iEditorInput.getAdapter(ImageData.class) == null) {
            throw new PartInitException("Unable to read input: " + String.valueOf(iEditorInput));
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput, false);
    }

    public void setInput(IEditorInput iEditorInput) {
        this.setInput(iEditorInput, true);
    }

    void setInput(IEditorInput iEditorInput, boolean bl) {
        IEditorInput iEditorInput2 = this.getEditorInput();
        if (iEditorInput != iEditorInput2) {
            this.unregisterResourceListener(iEditorInput2);
            this.setPartName(iEditorInput);
            if (bl) {
                super.setInputWithNotify(iEditorInput);
            } else {
                super.setInput(iEditorInput);
            }
            this.startImageLoad();
            this.registerResourceListener(iEditorInput);
        }
    }

    void setPartName(IEditorInput iEditorInput) {
        String string = null;
        if (iEditorInput instanceof IStorageEditorInput) {
            try {
                string = ((IStorageEditorInput)iEditorInput).getStorage().getName();
            }
            catch (CoreException coreException) {}
        }
        if (string == null) {
            string = iEditorInput.getName();
        }
        if (string == null) {
            string = this.getSite().getRegisteredName();
        }
        this.setPartName(string);
    }

    IFile getFileFor(IEditorInput iEditorInput) {
        if (iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile();
        }
        if (iEditorInput instanceof IStorageEditorInput) {
            try {
                IStorage iStorage = ((IStorageEditorInput)iEditorInput).getStorage();
                if (iStorage instanceof IFile) {
                    return (IFile)iStorage;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    void displayInfoString() {
        GamaColors.GamaUIColor gamaUIColor = IGamaColors.OK;
        IGamaFileMetaData iGamaFileMetaData = GAMA.getGui().getMetaDataProvider().getMetaData((Object)this.getFileFor(this.getEditorInput()), false, true);
        String string = iGamaFileMetaData == null ? "" : iGamaFileMetaData.getSuffix();
        IEditorSite iEditorSite = this.getEditorSite();
        IHandlerService iHandlerService = (IHandlerService)iEditorSite.getService(IHandlerService.class);
        this.toolbar.button(gamaUIColor, string, selectionEvent -> {
            try {
                iHandlerService.executeCommand("org.eclipse.ui.file.properties", null);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException throwable) {
                throwable.printStackTrace();
            }
        }, 16384);
        this.toolbar.requestLayout();
    }

    protected void unregisterResourceListener(IEditorInput iEditorInput) {
        if (iEditorInput != null && this.inputListener != null) {
            this.inputListener.stop();
            this.inputListener = null;
        }
    }

    protected void registerResourceListener(IEditorInput iEditorInput) {
        if (iEditorInput != null) {
            if (this.inputListener != null) {
                this.inputListener.stop();
            }
            this.inputListener = null;
            IFile iFile = this.getFileFor(iEditorInput);
            if (iFile != null) {
                this.inputListener = new ImageResourceChangeListener((IResource)iFile);
                this.inputListener.start();
            }
        }
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = GamaToolbarFactory.createToolbars((IToolbarDecoratedView)this, (Composite)composite);
        this.scroll = new ScrolledComposite(composite2, 768);
        this.scroll.getHorizontalBar().setIncrement(10);
        this.scroll.getHorizontalBar().setPageIncrement(100);
        this.scroll.getVerticalBar().setIncrement(10);
        this.scroll.getVerticalBar().setPageIncrement(100);
        this.scroll.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                ImageViewer.this.resizeCanvas(ImageViewer.this.imageCanvas.getSize());
            }
        });
        this.intermediate = new Composite((Composite)this.scroll, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.intermediate.setLayout((Layout)gridLayout);
        this.intermediate.setBackground(this.getColor(0).color());
        this.imageCanvas = new Canvas(this.intermediate, 0);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, true);
        this.imageCanvas.setLayoutData((Object)gridData);
        this.imageCanvas.setBackground(this.getColor(0).color());
        this.scroll.setContent((Control)this.intermediate);
        this.imageCanvas.addPaintListener(paintEvent -> {
            Rectangle rectangle = this.imageCanvas.getBounds();
            paintEvent.gc.setBackground(this.getColor(0).color());
            paintEvent.gc.fillRectangle(rectangle);
            if (this.image != null) {
                Rectangle rectangle2 = this.image.getBounds();
                paintEvent.gc.drawImage(this.image, 0, 0, rectangle2.width, rectangle2.height, 0, 0, rectangle.width, rectangle.height);
            }
        });
        this.startImageLoad();
    }

    void resizeCanvas(Point point) {
        Rectangle rectangle = this.scroll.getClientArea();
        int n = point.x > rectangle.width ? point.x : rectangle.width;
        int n2 = point.y > rectangle.height ? point.y : rectangle.height;
        this.intermediate.setSize(n, n2);
        this.imageCanvas.setSize(point);
        GridData gridData = (GridData)this.imageCanvas.getLayoutData();
        gridData.widthHint = point.x;
        gridData.heightHint = point.y;
        this.intermediate.layout();
        int n3 = 0;
        int n4 = 0;
        if (n > rectangle.width) {
            n3 = (n - rectangle.width) / 2;
        }
        if (n2 > rectangle.height) {
            n4 = (n2 - rectangle.height) / 2;
        }
        this.scroll.setOrigin(n3, n4);
    }

    void startImageLoad() {
        if (this.imageCanvas == null) {
            return;
        }
        Runnable runnable = () -> {
            if (this.image != null) {
                this.image.dispose();
                this.imageData = null;
                this.image = null;
                this.imageCanvas.setSize(0, 0);
                this.scroll.redraw();
            }
        };
        WorkbenchHelper.asyncRun((Runnable)runnable);
        Job job = new Job(MessageFormat.format("Load Image {0}", this.getPartName())){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(this.getName(), -1);
                try {
                    ImageViewer.this.loadImageData();
                    Runnable runnable = () -> {
                        ImageViewer.this.showImage(true);
                        ImageViewer.this.displayInfoString();
                    };
                    WorkbenchHelper.asyncRun((Runnable)runnable);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (CoreException coreException) {
                    IStatus iStatus = coreException.getStatus();
                    return iStatus;
                }
                catch (SWTException sWTException) {
                    Status status = new Status(4, "gama.ui.application", sWTException.getMessage());
                    return status;
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    void loadImageData() throws CoreException {
        IEditorInput iEditorInput = this.getEditorInput();
        Object object = iEditorInput.getAdapter(ImageData.class);
        if (object instanceof ImageData) {
            this.imageData = (ImageData)object;
        } else if (iEditorInput instanceof IStorageEditorInput) {
            IFile iFile = this.getFileFor(iEditorInput);
            this.imageData = ImageDataLoader.getImageData((IFile)iFile);
        }
        this.maxZoomFactor = this.determineMaxZoomFactor();
    }

    void showImage(boolean bl) {
        if (this.imageData != null) {
            this.imageCanvas.setCursor(this.imageCanvas.getDisplay().getSystemCursor(1));
            try {
                if (bl || this.image == null) {
                    if (this.image != null && !this.image.isDisposed()) {
                        this.image.dispose();
                        this.image = null;
                    }
                    this.image = new Image((Device)this.imageCanvas.getDisplay(), this.imageData);
                }
                Rectangle rectangle = this.image.getBounds();
                Point point = new Point((int)((double)rectangle.width * this.zoomFactor), (int)((double)rectangle.height * this.zoomFactor));
                this.resizeCanvas(point);
                this.scroll.redraw();
            }
            finally {
                this.imageCanvas.setCursor(null);
            }
        }
    }

    public void setFocus() {
        if (this.scroll != null && !this.scroll.isDisposed()) {
            this.scroll.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.inputListener != null) {
            this.inputListener.stop();
            this.inputListener = null;
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
    }

    public boolean isDirty() {
        return false;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
        Object object;
        IFile iFile;
        IPath iPath;
        IFile iFile2;
        SaveImageAsDialog saveImageAsDialog = new SaveImageAsDialog(this.getSite().getShell());
        int n = this.imageData.type;
        if (n < 0) {
            n = 5;
        }
        if ((iFile2 = this.getFileFor(this.getEditorInput())) != null) {
            saveImageAsDialog.setOriginalFile(iFile2, n);
        } else {
            iPath = Path.fromPortableString((String)this.getPartName()).removeFileExtension();
            saveImageAsDialog.setOriginalName(iPath.toPortableString(), n);
        }
        saveImageAsDialog.create();
        if (saveImageAsDialog.open() != 0) {
            return;
        }
        iPath = saveImageAsDialog.getResult();
        if (iPath == null) {
            return;
        }
        if (iPath.getFileExtension() == null) {
            iPath = iPath.addFileExtension(saveImageAsDialog.getSaveAsImageExt());
        }
        if ((iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath)) == null || iFile2 != null && iFile.equals((Object)iFile2)) {
            return;
        }
        final int n2 = saveImageAsDialog.getSaveAsImageType();
        IResourceRuleFactory iResourceRuleFactory = iFile.getWorkspace().getRuleFactory();
        ISchedulingRule iSchedulingRule = null;
        if (iFile.exists()) {
            iSchedulingRule = iResourceRuleFactory.modifyRule((IResource)iFile);
            iSchedulingRule = MultiRule.combine((ISchedulingRule)iSchedulingRule, (ISchedulingRule)iResourceRuleFactory.validateEditRule(new IResource[]{iFile}));
        } else {
            iSchedulingRule = iResourceRuleFactory.createRule((IResource)iFile);
            object = iFile.getParent();
            while (object != null && !(object instanceof IProject) && !object.exists()) {
                iSchedulingRule = MultiRule.combine((ISchedulingRule)iSchedulingRule, (ISchedulingRule)iResourceRuleFactory.createRule((IResource)object));
                object = object.getParent();
            }
        }
        object = new WorkspaceModifyOperation(iSchedulingRule){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    if (iFile.exists() && !iFile.getWorkspace().validateEdit(new IFile[]{iFile}, (Object)ImageViewer.this.getSite().getShell()).isOK()) {
                        return;
                    }
                    ImageViewer.this.saveTo(ImageViewer.this.imageData, iFile, n2, iProgressMonitor);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getSite().getShell());
        try {
            progressMonitorDialog.run(true, true, (IRunnableWithProgress)object);
            if (this.getFileFor(this.getEditorInput()) == null) {
                this.setInput((IEditorInput)new FileEditorInput(iFile));
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            String string = MessageFormat.format("Failed to save {0}", iPath.toPortableString());
            Object object2 = null;
            object2 = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "gama.ui.application", 0, throwable.toString(), throwable);
            if (object2.getSeverity() != 8) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error Saving", (String)string, (IStatus)object2);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    void saveTo(ImageData imageData, final IFile iFile, final int n, IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException, IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)iFile.getFullPath().toPortableString(), (int)-1);
        try {
            ImageLoader imageLoader;
            if (!iFile.getParent().exists()) {
                imageLoader = new ContainerGenerator(iFile.getFullPath().removeLastSegments(1));
                imageLoader.generateContainer((IProgressMonitor)subMonitor.split(500));
                if (iProgressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
            imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{imageData};
            PipedInputStream pipedInputStream = new PipedInputStream();
            final PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            Job job = new Job("Write image data to pipe"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    IStatus iStatus;
                    block12: {
                        iStatus = Status.OK_STATUS;
                        try {
                            try {
                                imageLoader.save((OutputStream)pipedOutputStream, n);
                                pipedOutputStream.flush();
                            }
                            catch (Exception exception) {
                                iStatus = new Status(4, "gama.ui.application", MessageFormat.format("Error getting image data for {0}", iFile.getFullPath()), (Throwable)exception);
                                try {
                                    pipedOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    DEBUG.ERR((Object)("Exception ignored in ImageViewer saveTo: " + iOException.getMessage()));
                                }
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                pipedOutputStream.close();
                            }
                            catch (IOException iOException) {
                                DEBUG.ERR((Object)("Exception ignored in ImageViewer saveTo: " + iOException.getMessage()));
                            }
                            throw throwable;
                        }
                        try {
                            pipedOutputStream.close();
                        }
                        catch (IOException iOException) {
                            DEBUG.ERR((Object)("Exception ignored in ImageViewer saveTo: " + iOException.getMessage()));
                        }
                    }
                    if (!iStatus.isOK()) {
                        IStatus iStatus2 = iStatus;
                        ImageViewer.this.getSite().getShell().getDisplay().asyncExec(() -> {
                            int n2 = ErrorDialog.openError((Shell)ImageViewer.this.getSite().getShell(), (String)"Error Saving", (String)MessageFormat.format("Failed to save {0}", iFile.getFullPath()), (IStatus)iStatus2);
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setUser(false);
            job.schedule();
            Throwable throwable = null;
            Object var11_12 = null;
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(pipedInputStream);){
                bufferedInputStream.mark(1);
                int n2 = bufferedInputStream.read();
                if (n2 != -1) {
                    bufferedInputStream.reset();
                    if (iFile.exists()) {
                        iFile.setContents((InputStream)bufferedInputStream, true, true, (IProgressMonitor)subMonitor.split(500));
                    } else {
                        iFile.create((InputStream)bufferedInputStream, true, (IProgressMonitor)subMonitor.split(500));
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public int[] getCurrentImageInformation() {
        if (this.imageData != null) {
            return new int[]{this.imageData.type, this.imageData.width, this.imageData.height};
        }
        return null;
    }

    private double determineMaxZoomFactor() {
        if (this.imageData != null) {
            double d = 2.147483647E9 / (double)this.imageData.width;
            double d2 = 2.147483647E9 / (double)this.imageData.height;
            return Math.min(d, d2);
        }
        return 1.0;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double d) {
        double d2 = d;
        if (this.zoomFactor != (d2 = Math.min(d2, this.maxZoomFactor)) && d2 > 0.0) {
            this.zoomFactor = d2;
            if (this.imageCanvas != null) {
                Runnable runnable = () -> this.showImage(false);
                WorkbenchHelper.run((Runnable)runnable);
            }
        }
    }

    public void zoomIn() {
        if (!this.locked) {
            this.setZoomFactor(this.getZoomFactor() * 1.1);
        }
    }

    public void zoomOut() {
        if (!this.locked) {
            this.setZoomFactor(this.getZoomFactor() * 0.9);
        }
    }

    public void zoomFit() {
        if (this.imageData.width > this.imageData.height) {
            this.setZoomFactor((double)this.scroll.getSize().x / (double)this.imageData.width);
        } else {
            this.setZoomFactor((double)this.scroll.getSize().y / (double)this.imageData.height);
        }
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    public Control[] getZoomableControls() {
        return new Control[]{this.intermediate, this.imageCanvas};
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        this.toolbar = gamaToolbar2;
        gamaToolbar2.sep(4, 131072);
        gamaToolbar2.button("generic/menu.saveas", "Save as...", "Save as...", selectionEvent -> this.doSaveAs(), 131072);
    }

    public String[] getColorLabels() {
        return new String[]{"Set background color..."};
    }

    public GamaColors.GamaUIColor getColor(int n) {
        return GamaColors.get((Color)((Color)PreferencesHelper.IMAGE_VIEWER_BACKGROUND.getValue()));
    }

    public void setColor(int n, GamaColors.GamaUIColor gamaUIColor) {
        if (this.imageCanvas != null) {
            Runnable runnable = () -> {
                this.intermediate.setBackground(gamaUIColor.color());
                this.showImage(false);
            };
            WorkbenchHelper.run((Runnable)runnable);
        }
    }

    public boolean zoomWhenScrolling() {
        return false;
    }

    public boolean isCameraLocked() {
        return this.locked;
    }

    public boolean isCameraDynamic() {
        return false;
    }

    private class ImageResourceChangeListener
    implements IResourceChangeListener {
        IResource imageFile;

        public ImageResourceChangeListener(IResource iResource) {
            this.imageFile = iResource;
        }

        void start() {
            this.imageFile.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }

        void stop() {
            this.imageFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta().findMember(this.imageFile.getFullPath());
            if (iResourceDelta != null) {
                int n;
                if (iResourceDelta.getKind() == 2) {
                    Runnable runnable = () -> {
                        boolean bl = ImageViewer.this.getSite().getPage().closeEditor((IEditorPart)ImageViewer.this, false);
                    };
                    ImageViewer.this.getSite().getShell().getDisplay().asyncExec(runnable);
                } else if (iResourceDelta.getKind() == 4 && (((n = iResourceDelta.getFlags()) & 0x100) != 0 || (n & 0x200000) != 0)) {
                    ImageViewer.this.startImageLoad();
                }
            }
        }
    }
}

