/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.image;

import gama.ui.viewers.image.SaveAsDialog2;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class SaveImageAsDialog
extends SaveAsDialog2 {
    static int[] IMAGE_TYPES;
    static String[] IMAGE_LABELS;
    static String[] IMAGE_EXTS;
    private int initialImageTypeIndex = 0;
    private int selectedImageTypeIndex = -1;
    Combo imageTypeCombo;

    static {
        int[] nArray = new int[6];
        nArray[0] = 5;
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[4] = 3;
        nArray[5] = 6;
        IMAGE_TYPES = nArray;
        IMAGE_LABELS = new String[]{"PNG (Portable Network Graphics)", "GIF (Graphics Interchange Format)", "JPEG (Joint Photographic Experts Group)", "BMP (Bitmap)", "ICO (Icon File)", "TIFF (Tagged Image File Format)"};
        IMAGE_EXTS = new String[]{"png", "gif", "jpg", "bmp", "ico", "tiff"};
    }

    public SaveImageAsDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Group group = new Group(composite2, 0);
        group.setText("Image Information");
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 131072);
        label.setText("Type:");
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.imageTypeCombo = new Combo((Composite)group, 2060);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.imageTypeCombo.setLayoutData((Object)gridData);
        String[] stringArray = IMAGE_LABELS;
        int n = IMAGE_LABELS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.imageTypeCombo.add(string);
            ++n2;
        }
        if (this.initialImageTypeIndex >= 0 && this.initialImageTypeIndex < IMAGE_TYPES.length) {
            this.imageTypeCombo.select(this.initialImageTypeIndex);
            this.selectedImageTypeIndex = this.initialImageTypeIndex;
        } else {
            this.imageTypeCombo.select(0);
            this.selectedImageTypeIndex = 0;
        }
        this.imageTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = SaveImageAsDialog.this.imageTypeCombo.getSelectionIndex();
                IPath iPath = Path.fromPortableString((String)SaveImageAsDialog.this.getFileName());
                iPath = iPath.removeFileExtension().addFileExtension(IMAGE_EXTS[n]);
                SaveImageAsDialog.this.setFileName(iPath.toPortableString());
            }
        });
        return composite2;
    }

    protected void okPressed() {
        this.selectedImageTypeIndex = this.imageTypeCombo.getSelectionIndex();
        super.okPressed();
    }

    public void setOriginalName(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder().append(string);
        int n2 = 0;
        while (n2 < IMAGE_TYPES.length) {
            if (n == IMAGE_TYPES[n2]) {
                this.initialImageTypeIndex = n2;
                stringBuilder.append(".").append(IMAGE_EXTS[n2]);
                break;
            }
            ++n2;
        }
        this.setOriginalName(stringBuilder.toString());
    }

    public void setOriginalFile(IFile iFile, int n) {
        IFile iFile2 = iFile;
        int n2 = 0;
        while (n2 < IMAGE_TYPES.length) {
            if (n == IMAGE_TYPES[n2]) {
                this.initialImageTypeIndex = n2;
                String string = iFile2.getFullPath().removeFileExtension().addFileExtension(IMAGE_EXTS[n2]).lastSegment();
                iFile2 = iFile2.getParent().getFile(Path.fromPortableString((String)string));
                break;
            }
            ++n2;
        }
        this.setOriginalFile(iFile2);
    }

    public int getSaveAsImageType() {
        if (this.selectedImageTypeIndex >= 0 && this.selectedImageTypeIndex < IMAGE_TYPES.length) {
            return IMAGE_TYPES[this.selectedImageTypeIndex];
        }
        return IMAGE_TYPES[0];
    }

    public String getSaveAsImageExt() {
        if (this.selectedImageTypeIndex >= 0 && this.selectedImageTypeIndex < IMAGE_TYPES.length) {
            return IMAGE_EXTS[this.selectedImageTypeIndex];
        }
        return IMAGE_EXTS[0];
    }
}

