/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis.geotools.styling;

import gama.ui.viewers.gis.geotools.styling.Mode;
import gama.ui.viewers.gis.geotools.styling.SLDs;
import gama.ui.viewers.gis.geotools.styling.SimpleConfigurator;
import java.awt.Color;
import java.text.MessageFormat;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;
import org.opengis.style.GraphicalSymbol;

public class GraphicViewer {
    boolean enabled;
    String type;
    double width;
    Button on;
    Combo name;
    Combo size;
    Listener sync = new Listener();
    private SelectionListener listener;

    public void addListener(SelectionListener selectionListener) {
        this.listener = selectionListener;
    }

    protected void fire(SelectionEvent selectionEvent) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(selectionEvent);
    }

    public Composite createControl(Composite composite, KeyListener keyListener, StyleBuilder styleBuilder) {
        Composite composite2 = SimpleConfigurator.subpart(composite, "Point");
        this.on = new Button(composite2, 32);
        this.size = new Combo(composite2, 4);
        this.size.setItems(new String[]{"1", "2", "3", "5", "10", "15"});
        this.size.setTextLimit(2);
        this.size.addKeyListener(keyListener);
        this.size.setToolTipText("Graphic size");
        this.name = new Combo(composite2, 4);
        this.name.setItems(styleBuilder.getWellKnownMarkNames());
        this.name.setTextLimit(9);
        this.name.addKeyListener(keyListener);
        this.name.setToolTipText("Shape type");
        return composite2;
    }

    public Graphic getGraphic(Fill fill, Stroke stroke, StyleBuilder styleBuilder) {
        if (!this.enabled) {
            Mark mark = null;
            if (this.type == null) {
                styleBuilder.createMark("square", null, null);
            } else {
                mark = styleBuilder.createMark(this.type, null, null);
            }
            return styleBuilder.createGraphic(null, mark, null);
        }
        Mark mark = styleBuilder.createMark(this.type, fill, stroke);
        Graphic graphic = styleBuilder.createGraphic(null, mark, null);
        graphic.setSize(styleBuilder.literalExpression(this.width));
        return graphic;
    }

    public void setGraphic(Graphic graphic, Mode mode, Color color) {
        Object object;
        Graphic graphic2 = graphic;
        boolean bl = true;
        if (graphic2 == null) {
            object = new StyleBuilder();
            graphic2 = object.createGraphic(null, object.createMark("square", color), null);
            bl = true;
        }
        this.width = SLDs.size((org.opengis.style.Graphic)graphic2);
        object = MessageFormat.format("{0,number,#0}", this.width);
        if (object != null) {
            this.size.setText((String)object);
            this.size.select(this.size.indexOf((String)object));
        }
        boolean bl2 = false;
        if (graphic2 != null && graphic2.graphicalSymbols() != null && !graphic2.graphicalSymbols().isEmpty()) {
            for (GraphicalSymbol graphicalSymbol : graphic2.graphicalSymbols()) {
                if (!(graphicalSymbol instanceof Mark)) continue;
                Mark mark = (Mark)graphicalSymbol;
                this.setMark(mark, mode);
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            this.setMark(null, mode);
        }
        this.enabled = this.enabled && bl;
    }

    private void setMark(Mark mark, Mode mode) {
        this.listen(false);
        try {
            this.enabled = mode == Mode.POINT && mark != null;
            this.type = SLD.wellKnownName((Mark)mark);
            this.on.setEnabled(mode == Mode.POINT || mode == Mode.ALL);
            if (this.type != null) {
                this.name.setText(this.type);
                this.name.select(this.name.indexOf(this.type));
            }
            this.on.setSelection(this.enabled);
            this.size.setEnabled(this.enabled);
            this.name.setEnabled(this.enabled);
        }
        finally {
            this.listen(true);
        }
    }

    void listen(boolean bl) {
        if (bl) {
            this.on.addSelectionListener((SelectionListener)this.sync);
            this.size.addSelectionListener((SelectionListener)this.sync);
            this.size.addModifyListener((ModifyListener)this.sync);
            this.name.addSelectionListener((SelectionListener)this.sync);
            this.name.addModifyListener((ModifyListener)this.sync);
        } else {
            this.on.removeSelectionListener((SelectionListener)this.sync);
            this.size.removeSelectionListener((SelectionListener)this.sync);
            this.size.removeModifyListener((ModifyListener)this.sync);
            this.name.removeSelectionListener((SelectionListener)this.sync);
            this.name.removeModifyListener((ModifyListener)this.sync);
        }
    }

    class Listener
    implements SelectionListener,
    ModifyListener {
        Listener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.sync(selectionEvent);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.sync(selectionEvent);
        }

        public void modifyText(ModifyEvent modifyEvent) {
            this.sync(SimpleConfigurator.selectionEvent(modifyEvent));
        }

        private void sync(SelectionEvent selectionEvent) {
            try {
                try {
                    GraphicViewer.this.enabled = GraphicViewer.this.on.getSelection();
                    GraphicViewer.this.type = GraphicViewer.this.name.getText();
                    try {
                        GraphicViewer.this.width = Integer.parseInt(GraphicViewer.this.size.getText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    GraphicViewer.this.fire(selectionEvent);
                }
                catch (Throwable throwable) {
                    GraphicViewer.this.name.setEnabled(GraphicViewer.this.enabled);
                    GraphicViewer.this.size.setEnabled(GraphicViewer.this.enabled);
                }
            }
            finally {
                GraphicViewer.this.name.setEnabled(GraphicViewer.this.enabled);
                GraphicViewer.this.size.setEnabled(GraphicViewer.this.enabled);
            }
        }
    }
}

