/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis.geotools.styling;

import java.awt.Color;
import java.awt.Rectangle;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;

public class Utils {
    public static final StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    public static final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());

    public static Rectangle toAwtRectangle(org.eclipse.swt.graphics.Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return rectangle2;
    }

    public static Style createStyle2(SimpleFeatureSource simpleFeatureSource) {
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)simpleFeatureSource.getSchema();
        Class clazz = simpleFeatureType.getGeometryDescriptor().getType().getBinding();
        if (Polygon.class.isAssignableFrom(clazz) || MultiPolygon.class.isAssignableFrom(clazz)) {
            return Utils.createPolygonStyle();
        }
        if (LineString.class.isAssignableFrom(clazz) || MultiLineString.class.isAssignableFrom(clazz)) {
            return Utils.createLineStyle();
        }
        return Utils.createPointStyle();
    }

    public static Style createPolygonStyle() {
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1), (Expression)filterFactory.literal(0.5));
        org.geotools.styling.Fill fill = styleFactory.createFill((Expression)filterFactory.literal((Object)Color.CYAN), (Expression)filterFactory.literal(0.5));
        PolygonSymbolizer polygonSymbolizer = styleFactory.createPolygonSymbolizer(stroke, fill, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(polygonSymbolizer);
        FeatureTypeStyle featureTypeStyle = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }

    public static Style createLineStyle() {
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1));
        LineSymbolizer lineSymbolizer = styleFactory.createLineSymbolizer(stroke, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(lineSymbolizer);
        FeatureTypeStyle featureTypeStyle = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }

    public static Style createPointStyle() {
        Graphic graphic = styleFactory.createDefaultGraphic();
        Mark mark = styleFactory.getCircleMark();
        mark.setStroke((org.opengis.style.Stroke)styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1)));
        mark.setFill((Fill)styleFactory.createFill((Expression)filterFactory.literal((Object)Color.CYAN)));
        graphic.graphicalSymbols().clear();
        graphic.graphicalSymbols().add(mark);
        graphic.setSize((Expression)filterFactory.literal(5));
        PointSymbolizer pointSymbolizer = styleFactory.createPointSymbolizer(graphic, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(pointSymbolizer);
        FeatureTypeStyle featureTypeStyle = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }
}

