/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis;

import gama.ui.shared.resources.GamaIcon;
import gama.ui.viewers.gis.MaplayerTableViewer;
import gama.ui.viewers.gis.SwtMapPane;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;

public class MapLayerComposite
extends Composite {
    protected SwtMapPane pane;
    protected MaplayerTableViewer mapLayerTableViewer;

    public MapLayerComposite(Composite composite, int n) {
        super(composite, n);
        this.init();
    }

    public void setMapPane(SwtMapPane swtMapPane) {
        this.pane = swtMapPane;
        this.mapLayerTableViewer.clear();
        swtMapPane.setMapLayerTable(this);
        this.mapLayerTableViewer.setPane(swtMapPane);
        MapContent mapContent = swtMapPane.getMapContent();
        List list = mapContent.layers();
        for (Layer layer : list) {
            this.mapLayerTableViewer.addLayer(layer);
        }
    }

    public void onAddLayer(Layer layer) {
        this.mapLayerTableViewer.addLayer(layer);
    }

    public void onRemoveLayer(Layer layer) {
        this.mapLayerTableViewer.removeLayer(layer);
    }

    public void repaint(Layer layer) {
        this.mapLayerTableViewer.refresh(layer, true);
    }

    private void init() {
        this.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group((Composite)this, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Layers");
        this.mapLayerTableViewer = new MaplayerTableViewer((Composite)group, 67584);
        GridData gridData = new GridData(4, 4, true, true);
        this.mapLayerTableViewer.getTable().setLayoutData((Object)gridData);
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)new GridLayout(5, true));
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setToolTipText("Show all layers");
        button.setImage(GamaIcon.named((String)"overlays/small.inspect").image());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MapLayerComposite.this.onShowAllLayers();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button2.setToolTipText("Hide all layers");
        button2.setImage(GamaIcon.named((String)"overlays/small.hidden").image());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MapLayerComposite.this.onHideAllLayers();
            }
        });
        Button button3 = new Button(composite, 8);
        button3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button3.setToolTipText("Layer up");
        button3.setImage(GamaIcon.named((String)"overlays/small.collapse").image());
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MapLayerComposite.this.moveLayer(-1);
            }
        });
        Button button4 = new Button(composite, 8);
        button4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button4.setToolTipText("Layer down");
        button4.setImage(GamaIcon.named((String)"overlays/small.expand").image());
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MapLayerComposite.this.moveLayer(1);
            }
        });
    }

    void moveLayer(int n) {
        Layer layer = this.mapLayerTableViewer.getSelectedMapLayer();
        if (layer == null) {
            return;
        }
        List<Layer> list = this.mapLayerTableViewer.getLayersList();
        MapContent mapContent = this.pane.getMapContent();
        int n2 = mapContent.layers().indexOf(layer);
        int n3 = list.indexOf(layer);
        int n4 = n3 + n;
        if (n4 < 0 || n4 > list.size() - 1) {
            return;
        }
        int n5 = n2 - n;
        if (n5 < 0 || n5 > mapContent.layers().size() - 1) {
            return;
        }
        if (n2 != n5) {
            mapContent.moveLayer(n2, n5);
            this.pane.redraw();
            Collections.swap(list, n3, n4);
            this.mapLayerTableViewer.refresh();
        }
    }

    void onShowAllLayers() {
        if (this.pane != null && this.pane.getMapContent() != null) {
            for (Layer layer : this.pane.getMapContent().layers()) {
                if (layer.isVisible()) continue;
                layer.setVisible(true);
            }
            this.mapLayerTableViewer.refresh();
            this.pane.redraw();
        }
    }

    void onHideAllLayers() {
        if (this.pane != null && this.pane.getMapContent() != null) {
            for (Layer layer : this.pane.getMapContent().layers()) {
                if (!layer.isVisible()) continue;
                layer.setVisible(false);
            }
            this.mapLayerTableViewer.refresh();
            this.pane.redraw();
        }
    }

    public MaplayerTableViewer getMapLayerTableViewer() {
        return this.mapLayerTableViewer;
    }
}

