/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.csv.model;

import gama.ui.viewers.csv.model.IRowChangesListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class CSVRow {
    private final ArrayList<String> entries;
    private final IRowChangesListener listener;
    private boolean isHeader;

    public CSVRow(List<String> list, IRowChangesListener iRowChangesListener) {
        this.entries = new ArrayList<String>(list);
        this.listener = iRowChangesListener;
    }

    public CSVRow(String[] stringArray, IRowChangesListener iRowChangesListener) {
        this(Arrays.asList(stringArray), iRowChangesListener);
    }

    public static CSVRow createEmptyLine(int n, IRowChangesListener iRowChangesListener) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        while (n2 < n) {
            linkedList.add("");
            ++n2;
        }
        return new CSVRow(linkedList, iRowChangesListener);
    }

    public ArrayList<String> getEntries() {
        return this.entries;
    }

    public String[] getEntriesAsArray() {
        return this.entries.toArray(new String[this.entries.size()]);
    }

    public void setRowEntry(int n, String string) {
        if (this.entries.get(n).compareTo(string) != 0) {
            this.entries.set(n, string);
            this.listener.rowChanged(this, n);
        }
    }

    public String getElementAt(int n) {
        if (n >= this.entries.size()) {
            return "";
        }
        return this.entries.get(n);
    }

    public int getNumberOfElements() {
        return this.entries.size();
    }

    public void addElement(String string) {
        this.entries.add(string);
    }

    public void removeElementAt(int n) {
        this.entries.remove(n);
    }

    public void setHeader(boolean bl) {
        this.isHeader = bl;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public String getComment() {
        return this.entries.get(0).substring(1);
    }

    public String toString() {
        String string = "";
        for (String string2 : this.entries) {
            string = string.concat(string2).concat(",");
        }
        return string;
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }

    public boolean equals(Object object) {
        return this == object;
    }
}

