/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis;

import gama.core.metamodel.shape.IShape;
import gama.gaml.operators.Strings;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.views.toolbar.BackgroundChooser;
import gama.ui.shared.views.toolbar.GamaCommand;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.GamaToolbarSimple;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import gama.ui.viewers.gis.SwtMapPane;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.EditorPart;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.Envelope;

public abstract class GISFileViewer
extends EditorPart
implements IToolbarDecoratedView.Zoomable,
IToolbarDecoratedView.CSVExportable,
IToolbarDecoratedView.Colorizable {
    SwtMapPane pane;
    MapContent content;
    GamaToolbar2 toolbar;
    IFile file;
    SimpleFeatureSource featureSource;
    boolean noCRS = false;
    Style style;
    Layer layer;
    String pathStr;
    boolean locked = false;

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = GamaToolbarFactory.createToolbars((IToolbarDecoratedView)this, (Composite)composite);
        this.displayInfoString();
        this.pane = new SwtMapPane(composite2, 262144, (GTRenderer)new StreamingRenderer(), this.content);
        this.pane.setBackground(GamaColors.system((int)1));
        this.pane.redraw();
    }

    protected abstract void displayInfoString();

    public void setFocus() {
        this.pane.setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.content != null) {
            this.content.dispose();
            this.content = null;
        }
    }

    public void zoomIn() {
        if (!this.locked) {
            ReferencedEnvelope referencedEnvelope = this.pane.getDisplayArea();
            referencedEnvelope.expandBy(-referencedEnvelope.getWidth() / 10.0, -referencedEnvelope.getHeight() / 10.0);
            this.pane.setDisplayArea((Envelope)referencedEnvelope);
        }
    }

    public void zoomOut() {
        if (!this.locked) {
            ReferencedEnvelope referencedEnvelope = this.pane.getDisplayArea();
            referencedEnvelope.expandBy(referencedEnvelope.getWidth() / 10.0, referencedEnvelope.getHeight() / 10.0);
            this.pane.setDisplayArea((Envelope)referencedEnvelope);
        }
    }

    public void zoomFit() {
        this.pane.reset();
    }

    public void toggleLock() {
        this.locked = !this.locked;
        this.pane.toggleLock();
    }

    public boolean isCameraLocked() {
        return this.locked;
    }

    public boolean isCameraDynamic() {
        return false;
    }

    public Control getMapComposite() {
        return this.pane;
    }

    public Control[] getZoomableControls() {
        return new Control[]{this.pane};
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        this.toolbar = gamaToolbar2;
        GamaToolbarSimple gamaToolbarSimple = this.toolbar.getToolbar(131072);
        gamaToolbarSimple.button("editor/local.menu", "More...", "More options", selectionEvent -> {
            GamaMenu gamaMenu = new GamaMenu(){

                protected void fillMenu() {
                    GamaCommand.build((String)"generic/menu.saveas", (String)"Export as CSV...", (String)"CSV Export", selectionEvent -> GISFileViewer.this.saveAsCSV()).toItem(this.mainMenu);
                    GamaMenu.separate((Menu)this.mainMenu);
                    BackgroundChooser.install((IToolbarDecoratedView.Colorizable)GISFileViewer.this, (Menu)this.mainMenu);
                }
            };
            gamaMenu.open((Control)gamaToolbarSimple, selectionEvent, gamaToolbarSimple.getSize().y, 0);
        });
    }

    public boolean zoomWhenScrolling() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void saveAsCSV(List<String> list, List<IShape> list2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.pathStr.split("\\.");
        int n = 0;
        while (n < stringArray.length - 1) {
            stringBuilder.append(stringArray[n]).append(n < stringArray.length - 2 ? "." : "");
            ++n;
        }
        if (string != null) {
            stringBuilder.append(string).append(".");
        } else {
            stringBuilder.append(".");
        }
        stringBuilder.append("csv");
        File file = new File(stringBuilder.toString());
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (FileWriter fileWriter = new FileWriter(file, false);){
                fileWriter.write("id");
                for (String object : list) {
                    fileWriter.write(";" + object);
                }
                fileWriter.write(Strings.LN);
                if (list2 != null) {
                    boolean n2 = false;
                    for (IShape iShape : list2) {
                        void var10_18;
                        fileWriter.write("" + (int)var10_18);
                        ++var10_18;
                        for (String string2 : list) {
                            String string3 = iShape.hasAttribute(string2) ? iShape.getAttribute(string2).toString().replace(';', ',') : "-";
                            fileWriter.write(";" + string3);
                        }
                        fileWriter.write(Strings.LN);
                    }
                } else {
                    Object[] objectArray = this.layer.getFeatureSource().getFeatures().toArray();
                    int n2 = objectArray.length;
                    int n4 = 0;
                    while (n4 < n2) {
                        Object object = objectArray[n4];
                        SimpleFeature simpleFeature = (SimpleFeature)object;
                        fileWriter.write(simpleFeature.getID());
                        for (String string4 : list) {
                            fileWriter.write(";" + simpleFeature.getAttribute(string4).toString().replace(';', ','));
                        }
                        fileWriter.write(Strings.LN);
                        ++n4;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

