/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis;

import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.GamaOsmFile;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import gama.ui.viewers.gis.GISFileViewer;
import gama.ui.viewers.gis.MapLayerComposite;
import gama.ui.viewers.gis.SwtMapPane;
import gama.ui.viewers.gis.geotools.styling.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class OSMFileViewer
extends GISFileViewer {
    Map<String, String> attributes;
    GamaOsmFile osmfile;
    MapLayerComposite mapLayerTable;

    @Override
    public void createPartControl(Composite composite) {
        Composite composite2 = GamaToolbarFactory.createToolbars((IToolbarDecoratedView)this, (Composite)composite);
        SashForm sashForm = new SashForm(composite2, 256);
        this.displayInfoString();
        this.mapLayerTable = new MapLayerComposite((Composite)sashForm, 2048);
        this.pane = new SwtMapPane((Composite)sashForm, 264192, (GTRenderer)new StreamingRenderer(), this.content);
        this.pane.setBackground(GamaColors.system((int)1));
        this.mapLayerTable.setMapPane(this.pane);
        sashForm.setWeights(new int[]{1, 4});
        this.pane.redraw();
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
        this.file = fileEditorInput.getFile();
        IPath iPath = fileEditorInput.getPath();
        File file = iPath.makeAbsolute().toFile();
        try {
            IShape iShape2;
            this.pathStr = file.getAbsolutePath();
            this.osmfile = new GamaOsmFile(null, this.pathStr);
            this.attributes = this.osmfile.getOSMAttributes(GAMA.getRuntimeScope());
            SimpleFeatureType simpleFeatureType = DataUtilities.createType((String)"geometries", (String)"geom:LineString");
            ArrayList<SimpleFeature> arrayList = new ArrayList<SimpleFeature>();
            for (IShape iShape2 : this.osmfile.iterable(null)) {
                arrayList.add(SimpleFeatureBuilder.build((SimpleFeatureType)simpleFeatureType, (Object[])new Object[]{iShape2.getInnerGeometry()}, null));
            }
            iShape2 = new ListFeatureCollection(simpleFeatureType, arrayList);
            this.featureSource = DataUtilities.source((FeatureCollection)iShape2);
            this.content = new MapContent();
            this.style = Utils.createStyle2(this.featureSource);
            this.layer = new FeatureLayer((FeatureSource)this.featureSource, this.style);
            ArrayList arrayList2 = new ArrayList(this.osmfile.getLayers().keySet());
            Collections.sort(arrayList2);
            Collections.reverse(arrayList2);
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                IShape iShape32;
                String string = (String)iterator.next();
                boolean bl = string.endsWith("(point)");
                boolean bl2 = string.endsWith("(line)");
                SimpleFeatureType simpleFeatureType2 = bl ? DataUtilities.createType((String)string, (String)"geom:Point") : (bl2 ? DataUtilities.createType((String)string, (String)"geom:LineString") : DataUtilities.createType((String)string, (String)"geom:Polygon"));
                ArrayList<SimpleFeature> arrayList3 = new ArrayList<SimpleFeature>();
                for (IShape iShape32 : (List)this.osmfile.getLayers().get(string)) {
                    arrayList3.add(SimpleFeatureBuilder.build((SimpleFeatureType)simpleFeatureType2, (Object[])new Object[]{iShape32.getInnerGeometry()}, null));
                }
                iShape32 = new ListFeatureCollection(simpleFeatureType2, arrayList3);
                SimpleFeatureSource simpleFeatureSource = DataUtilities.source((FeatureCollection)iShape32);
                Style style = Utils.createStyle2(simpleFeatureSource);
                FeatureLayer featureLayer = new FeatureLayer((FeatureSource)simpleFeatureSource, style);
                this.content.addLayer((Layer)featureLayer);
            }
        }
        catch (GamaRuntimeException | SchemaException throwable) {
            throwable.printStackTrace();
        }
        this.setPartName(iPath.lastSegment());
        this.setInput(iEditorInput);
    }

    @Override
    protected void displayInfoString() {
        Object object = "";
        try {
            object = this.featureSource.getFeatures().size() + " objects | " + (int)(this.featureSource.getBounds().getWidth() * (Math.PI / 180) * 6378137.0) + "m x " + (int)(this.featureSource.getBounds().getHeight() * (Math.PI / 180) * 6378137.0) + "m";
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ToolItem toolItem = this.toolbar.status((String)object);
        ((FlatButton)toolItem.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){
            Menu menu;

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (this.menu == null) {
                    this.menu = new Menu((Decorations)OSMFileViewer.this.toolbar.getShell(), 8);
                    this.fillMenu();
                }
                Point point = OSMFileViewer.this.toolbar.toDisplay(new Point(selectionEvent.x, selectionEvent.y + OSMFileViewer.this.toolbar.getSize().y));
                this.menu.setLocation(point.x, point.y);
                this.menu.setVisible(true);
            }

            private void fillMenu() {
                Object object;
                Object object2;
                GamaMenu.separate((Menu)this.menu, (String)"Bounds");
                try {
                    object2 = OSMFileViewer.this.featureSource.getBounds();
                    object = new MenuItem(this.menu, 0);
                    object.setEnabled(false);
                    object.setText("     - upper corner : " + object2.getUpperCorner().getOrdinate(0) + " " + object2.getUpperCorner().getOrdinate(1));
                    object = new MenuItem(this.menu, 0);
                    object.setEnabled(false);
                    object.setText("     - lower corner : " + object2.getLowerCorner().getOrdinate(0) + " " + object2.getLowerCorner().getOrdinate(1));
                    object = new MenuItem(this.menu, 0);
                    object.setEnabled(false);
                    object.setText("     - dimensions : " + (int)(object2.getWidth() * (Math.PI / 180) * 6378137.0) + "m x " + (int)(object2.getHeight() * (Math.PI / 180) * 6378137.0) + "m");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                GamaMenu.separate((Menu)this.menu);
                GamaMenu.separate((Menu)this.menu, (String)"Attributes");
                try {
                    object2 = new ArrayList<String>(OSMFileViewer.this.attributes.keySet());
                    Collections.sort(object2);
                    object = "";
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        MenuItem menuItem;
                        String string = (String)iterator.next();
                        String[] stringArray = string.split(";");
                        if (!((String)object).equals(stringArray[0])) {
                            object = stringArray[0];
                            menuItem = new MenuItem(this.menu, 0);
                            menuItem.setEnabled(false);
                            menuItem.setText("  * " + (String)object);
                        }
                        menuItem = new MenuItem(this.menu, 0);
                        menuItem.setEnabled(false);
                        menuItem.setText("       - " + stringArray[1] + " (" + OSMFileViewer.this.attributes.get(string) + ")");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public void saveAsCSV() {
        Layer layer = this.mapLayerTable.getMapLayerTableViewer().getSelectedMapLayer();
        if (layer == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string = layer.getFeatureSource().getName().toString();
        for (String object2 : this.attributes.keySet()) {
            String[] stringArray = object2.split(";");
            if (!string.equals(stringArray[0])) continue;
            hashSet.add(stringArray[1]);
        }
        List list = (List)this.osmfile.getLayers().get(string);
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        this.saveAsCSV(arrayList, list, string);
    }

    public String[] getColorLabels() {
        return new String[0];
    }

    public GamaColors.GamaUIColor getColor(int n) {
        return null;
    }

    public void setColor(int n, GamaColors.GamaUIColor gamaUIColor) {
    }
}

