/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.html;

import gama.core.common.interfaces.IGamaView;
import gama.ui.shared.utils.WebHelper;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class HtmlViewer
extends EditorPart
implements IToolbarDecoratedView,
IGamaView.Html {
    Browser browser;
    ToolItem back;
    ToolItem forward;
    ToolItem home;

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.openInput();
    }

    private void openInput() {
        if (this.browser == null) {
            return;
        }
        if (this.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)this.getEditorInput();
            try {
                this.setUrl(fileEditorInput.getURI().toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        } else if (this.getEditorInput() instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)this.getEditorInput();
            try {
                this.setUrl(fileStoreEditorInput.getURI().toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = GamaToolbarFactory.createToolbars((IToolbarDecoratedView)this, (Composite)composite);
        this.browser = new Browser(composite2, 0);
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent progressEvent) {
            }

            public void completed(ProgressEvent progressEvent) {
                HtmlViewer.this.checkButtons();
            }
        });
        composite.layout();
        this.openInput();
    }

    public void setUrl(String string) {
        this.browser.setUrl(string);
        this.setPartName(string.substring(string.lastIndexOf(47) + 1));
        this.checkButtons();
    }

    void checkButtons() {
        this.back.setEnabled(this.browser.isBackEnabled());
        this.forward.setEnabled(this.browser.isForwardEnabled());
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public Control getSizableFontControl() {
        return this.browser;
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        this.back = gamaToolbar2.button("editor/command.lastedit", "Back", "Go to previous page in history", selectionEvent -> {
            this.browser.back();
            this.checkButtons();
        }, 131072);
        this.home = gamaToolbar2.button("toolbar/view.home", "Home", "Go back to the welcome page", selectionEvent -> {
            this.browser.setUrl(WebHelper.getWelcomePageURL().toString());
            this.checkButtons();
        }, 131072);
        this.forward = gamaToolbar2.button("editor/command.nextedit", "Forward", "Go to next page in history", selectionEvent -> {
            this.browser.forward();
            this.checkButtons();
        }, 131072);
        gamaToolbar2.button("toolbar/view.reload", "Refresh", "Refresh current page", selectionEvent -> this.browser.refresh(), 131072);
        gamaToolbar2.button("toolbar/view.stop", "Stop", "Stop loading page", selectionEvent -> this.browser.stop(), 131072);
    }
}

