/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.gis.geotools.styling;

import gama.ui.viewers.gis.geotools.styling.FillViewer;
import gama.ui.viewers.gis.geotools.styling.GraphicViewer;
import gama.ui.viewers.gis.geotools.styling.Mode;
import gama.ui.viewers.gis.geotools.styling.SLDs;
import gama.ui.viewers.gis.geotools.styling.StrokeViewer;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.map.Layer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.style.LabelPlacement;

public class SimpleConfigurator
extends Dialog {
    protected StyleBuilder build = new StyleBuilder();
    protected SimpleFeatureCollection featureCollection;
    protected Style style;
    private final StrokeViewer line = new StrokeViewer();
    private final FillViewer fill = new FillViewer();
    private final GraphicViewer point = new GraphicViewer();
    private Mode mode;
    private final SelectionListener synchronize = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SimpleConfigurator.this.synchronize();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            SimpleConfigurator.this.synchronize();
        }
    };
    private Button replace;

    public SimpleConfigurator(Shell shell, SimpleFeatureCollection simpleFeatureCollection, Style style) {
        super(shell);
        this.featureCollection = simpleFeatureCollection;
        this.style = style;
        this.line.addListener(this.synchronize);
        this.fill.addListener(this.synchronize);
        this.point.addListener(this.synchronize);
    }

    protected void setLayout(Composite composite) {
        RowLayout rowLayout = new RowLayout();
        rowLayout.pack = false;
        rowLayout.wrap = true;
        rowLayout.type = 256;
        rowLayout.fill = true;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        rowLayout.spacing = 0;
        composite.setLayout((Layout)rowLayout);
    }

    protected Style getStyle() {
        assert (this.featureCollection != null);
        Style style = this.style;
        if (style == null) {
            SimpleFeatureType simpleFeatureType = (SimpleFeatureType)this.featureCollection.getSchema();
            if (SLDs.isLine(simpleFeatureType)) {
                style = SLD.createLineStyle((Color)Color.red, (float)1.0f);
            } else if (SLDs.isPoint(simpleFeatureType)) {
                style = SLD.createPointStyle((String)"Circle", (Color)Color.red, (Color)Color.green, (float)1.0f, (float)3.0f);
            } else if (SLDs.isPolygon(simpleFeatureType)) {
                style = SLD.createPolygonStyle((Color)Color.red, (Color)Color.green, (float)1.0f);
            }
        }
        this.style = style;
        return style;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("");
    }

    protected Point getInitialSize() {
        return new Point(450, 370);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.setLayout(composite2);
        ((RowLayout)composite2.getLayout()).type = 512;
        ((RowLayout)composite2.getLayout()).spacing = 3;
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000050 || keyEvent.character == '\r') {
                    SimpleConfigurator.this.refresh();
                }
            }
        };
        this.line.createControl(composite2, (KeyListener)keyAdapter);
        this.fill.createControl(composite2, (KeyListener)keyAdapter);
        this.point.createControl(composite2, (KeyListener)keyAdapter, this.build);
        Composite composite3 = SimpleConfigurator.subpart(composite2, "Replace");
        this.replace = new Button(composite3, 32);
        this.replace.addSelectionListener(this.synchronize);
        this.replace.setSelection(true);
        this.refresh();
        return composite2;
    }

    public Mode determineMode(SimpleFeatureType simpleFeatureType, boolean bl) {
        if (simpleFeatureType == null) {
            return Mode.NONE;
        }
        if (SLDs.isLine(simpleFeatureType)) {
            return Mode.LINE;
        }
        if (SLDs.isPolygon(simpleFeatureType)) {
            return Mode.POLYGON;
        }
        if (SLDs.isPoint(simpleFeatureType)) {
            return Mode.POINT;
        }
        return Mode.ALL;
    }

    protected void refresh() {
        Object object;
        Style style = this.getStyle();
        List list = style.featureTypeStyles();
        FeatureTypeStyle featureTypeStyle = null;
        if (list.size() > 0) {
            featureTypeStyle = (FeatureTypeStyle)list.get(0);
        }
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)this.featureCollection.getSchema();
        Stroke stroke = null;
        Fill fill = null;
        Graphic graphic = null;
        TextSymbolizer textSymbolizer = null;
        PointPlacement pointPlacement = null;
        List list2 = Collections.emptyList();
        if (featureTypeStyle != null) {
            list2 = featureTypeStyle.rules();
        }
        if (list2.size() > 1) {
            object = (Rule)list2.get(0);
            list2.clear();
            list2.add(object);
        }
        this.mode = this.determineMode(simpleFeatureType, true);
        if (this.mode == Mode.LINE) {
            object = SLDs.lineSymbolizer((FeatureTypeStyle)featureTypeStyle);
            stroke = SLDs.stroke((LineSymbolizer)object);
            pointPlacement = SLDs.getPlacement((double)1.0, (double)0.5, (double)0.0);
        } else if (this.mode == Mode.POLYGON) {
            object = SLDs.polySymbolizer((FeatureTypeStyle)featureTypeStyle);
            stroke = SLDs.stroke((PolygonSymbolizer)object);
            fill = SLDs.fill((PolygonSymbolizer)object);
            pointPlacement = SLDs.getPlacement((double)0.5, (double)0.5, (double)0.0);
        } else if (this.mode == Mode.POINT || this.mode == Mode.ALL) {
            object = SLDs.pointSymbolizer((FeatureTypeStyle)featureTypeStyle);
            stroke = SLDs.stroke((PointSymbolizer)object);
            fill = SLDs.fill((PointSymbolizer)object);
            graphic = SLDs.graphic((PointSymbolizer)object);
            pointPlacement = SLDs.getPlacement((double)1.0, (double)0.5, (double)0.0);
        }
        textSymbolizer = SLDs.textSymbolizer((FeatureTypeStyle)featureTypeStyle);
        if (textSymbolizer != null && pointPlacement != null) {
            textSymbolizer.setLabelPlacement((LabelPlacement)pointPlacement);
        }
        object = Color.red;
        this.line.setStroke(stroke, this.mode, (Color)object);
        this.fill.setFill(fill, this.mode, (Color)object);
        this.point.setGraphic(graphic, this.mode, (Color)object);
    }

    public void synchronize() {
        FeatureTypeStyle featureTypeStyle;
        Rule rule;
        LineSymbolizer lineSymbolizer;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)this.featureCollection.getSchema();
        this.mode = this.determineMode(simpleFeatureType, true);
        String string = null;
        switch (this.mode) {
            case LINE: {
                lineSymbolizer = this.build.createLineSymbolizer(this.line.getStroke(this.build));
                arrayList.add(lineSymbolizer);
                lineSymbolizer.setGeometryPropertyName(string);
                break;
            }
            case POLYGON: {
                lineSymbolizer = this.build.createPolygonSymbolizer(this.line.getStroke(this.build), this.fill.getFill(this.build));
                lineSymbolizer.setGeometryPropertyName(string);
                arrayList.add(lineSymbolizer);
                break;
            }
            case POINT: {
                lineSymbolizer = this.build.createPointSymbolizer(this.point.getGraphic(this.fill.getFill(this.build), this.line.getStroke(this.build), this.build));
                lineSymbolizer.setGeometryPropertyName(string);
                arrayList.add(lineSymbolizer);
                break;
            }
            case ALL: {
                lineSymbolizer = this.build.createLineSymbolizer(this.line.getStroke(this.build));
                arrayList.add(lineSymbolizer);
                arrayList.add(lineSymbolizer);
                rule = this.build.createPolygonSymbolizer(this.line.getStroke(this.build), this.fill.getFill(this.build));
                rule.setGeometryPropertyName(string);
                arrayList.add(rule);
                featureTypeStyle = this.build.createPointSymbolizer(this.point.getGraphic(this.fill.getFill(this.build), this.line.getStroke(this.build), this.build));
                featureTypeStyle.setGeometryPropertyName(string);
                arrayList.add(featureTypeStyle);
            }
        }
        lineSymbolizer = arrayList.toArray(new Symbolizer[arrayList.size()]);
        rule = this.build.createRule((Symbolizer[])lineSymbolizer);
        featureTypeStyle = this.build.createFeatureTypeStyle("Feature", rule);
        featureTypeStyle.setName("simple");
        Style style = this.getStyle();
        style.setDefault(true);
        if (this.replace.getSelection()) {
            style.featureTypeStyles().clear();
            style.featureTypeStyles().add(featureTypeStyle);
        } else {
            List list = style.featureTypeStyles();
            boolean bl = false;
            int n = list.size() - 1;
            while (n > -1) {
                if (SLDs.isSemanticTypeMatch((FeatureTypeStyle)list.get(n), "simple")) {
                    list.set(n, featureTypeStyle);
                    bl = true;
                    break;
                }
                --n;
            }
            if (bl) {
                style.featureTypeStyles().clear();
                style.featureTypeStyles().addAll(list);
            } else {
                ArrayList<FeatureTypeStyle> arrayList2 = new ArrayList<FeatureTypeStyle>(list);
                Collections.copy(arrayList2, list);
                arrayList2.add(featureTypeStyle);
                style.featureTypeStyles().clear();
                style.featureTypeStyles().addAll(arrayList2);
            }
        }
        this.style = style;
    }

    public static Style showDialog(Shell shell, Layer layer) throws IOException {
        SimpleFeatureSource simpleFeatureSource = (SimpleFeatureSource)layer.getFeatureSource();
        Style style = layer.getStyle();
        SimpleConfigurator.showDialog(shell, simpleFeatureSource, style);
        return null;
    }

    public static Style showDialog(Shell shell, SimpleFeatureSource simpleFeatureSource, Style style) throws IOException {
        SimpleFeatureCollection simpleFeatureCollection = simpleFeatureSource.getFeatures();
        SimpleConfigurator simpleConfigurator = new SimpleConfigurator(shell, simpleFeatureCollection, style);
        simpleConfigurator.setBlockOnOpen(true);
        simpleConfigurator.open();
        return simpleConfigurator.getStyle();
    }

    public static Composite subpart(Composite composite, String string) {
        Composite composite2 = new Composite(composite, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.wrap = true;
        rowLayout.pack = true;
        rowLayout.fill = true;
        rowLayout.marginBottom = 1;
        rowLayout.marginRight = 2;
        composite2.setLayout((Layout)rowLayout);
        Label label = new Label(composite2, 16384);
        label.setText(string);
        RowData rowData = new RowData();
        rowData.width = 40;
        GC gC = new GC((Drawable)composite.getParent());
        gC.setFont(composite.getParent().getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        int n = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)(label.getText().length() + 1));
        if (n > rowData.width) {
            rowData.width = n;
        }
        rowData.height = 10;
        label.setLayoutData((Object)rowData);
        return composite2;
    }

    public static SelectionEvent selectionEvent(final ModifyEvent modifyEvent) {
        Event event = new Event();
        event.widget = modifyEvent.widget;
        event.data = modifyEvent.data;
        event.display = modifyEvent.display;
        event.time = modifyEvent.time;
        return new SelectionEvent(event){
            private static final long serialVersionUID = 6544345585295778029L;

            public Object getSource() {
                return modifyEvent.getSource();
            }
        };
    }
}

