/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.documentation;

import gama.core.common.interfaces.IDocManager;
import gama.dev.DEBUG;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.interfaces.IGamlDescription;
import gaml.compiler.gaml.documentation.GamlResourceDocumentationTask;
import gaml.compiler.gaml.resource.GamlResourceServices;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class GamlResourceDocumenter
implements IDocManager {
    final Map<URI, GamlResourceDocumentationTask> documentationTasks = new ConcurrentHashMap<URI, GamlResourceDocumentationTask>();
    final Map<URI, DocumentedObject> documentedObjects = new ConcurrentHashMap<URI, DocumentedObject>();

    static {
        DEBUG.ON();
    }

    public void addDocumentationTask(URI uRI, Runnable runnable) {
        if (runnable == null || !this.isTaskValid(uRI)) {
            return;
        }
        this.getTaskFor(uRI).add(runnable);
    }

    public void setGamlDocumentation(URI uRI, EObject eObject, IGamlDescription iGamlDescription) {
        this.addDocumentationTask(uRI, () -> {
            boolean bl = this.internalSetGamlDocumentation(uRI, this.getCurrentDocGenerationFor(uRI), eObject, iGamlDescription);
        });
    }

    boolean internalSetGamlDocumentation(URI uRI, int n, EObject eObject, IGamlDescription iGamlDescription) {
        block4: {
            try {
                if (this.isTaskValid(uRI) && this.isValidGeneration(uRI, n)) break block4;
                return false;
            }
            catch (RuntimeException runtimeException) {
                DEBUG.ERR((Object)("Error in documenting " + uRI.lastSegment()), (Throwable)runtimeException);
                return false;
            }
        }
        URI uRI2 = EcoreUtil.getURI((EObject)eObject);
        DocumentedObject documentedObject = this.documentedObjects.get(uRI2);
        if (documentedObject == null) {
            documentedObject = new DocumentedObject(new IDocManager.DocumentationNode(iGamlDescription), new HashSet<URI>());
            this.documentedObjects.put(uRI2, documentedObject);
        }
        documentedObject.resources.add(uRI);
        this.getTaskFor((URI)uRI).objects.add(uRI2);
        return true;
    }

    public void doDocument(URI uRI, ModelDescription modelDescription, Map<EObject, IGamlDescription> map) {
        GamlResourceDocumentationTask gamlResourceDocumentationTask = this.getTaskFor(uRI);
        gamlResourceDocumentationTask.incrementGeneration();
        int n = this.getCurrentDocGenerationFor(uRI);
        gamlResourceDocumentationTask.add(() -> {
            this.internalDoDocument(uRI, n, (IDescription)modelDescription);
            map.forEach((eObject, iGamlDescription) -> {
                boolean bl = this.internalSetGamlDocumentation(uRI, n, (EObject)eObject, (IGamlDescription)iGamlDescription);
            });
        });
    }

    private boolean internalDoDocument(URI uRI, int n, IDescription iDescription2) {
        if (iDescription2 == null) {
            return false;
        }
        EObject eObject = iDescription2.getUnderlyingElement();
        if (eObject == null) {
            return true;
        }
        if (!this.internalSetGamlDocumentation(uRI, n, eObject, (IGamlDescription)iDescription2)) {
            return false;
        }
        return iDescription2.visitOwnChildren(iDescription -> this.internalDoDocument(uRI, n, (IDescription)iDescription));
    }

    public IGamlDescription getGamlDocumentation(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        DocumentedObject documentedObject = this.documentedObjects.get(EcoreUtil.getURI((EObject)eObject));
        return documentedObject == null ? null : documentedObject.node;
    }

    public void invalidate(URI uRI) {
        if (uRI == null) {
            return;
        }
        GamlResourceDocumentationTask gamlResourceDocumentationTask = this.documentationTasks.remove(uRI);
        if (gamlResourceDocumentationTask != null) {
            gamlResourceDocumentationTask.objects.forEach(uRI2 -> {
                DocumentedObject documentedObject = this.documentedObjects.get(uRI2);
                if (documentedObject != null) {
                    Set<URI> set = documentedObject.resources;
                    set.remove(uRI);
                    if (set.isEmpty()) {
                        this.documentedObjects.remove(uRI2);
                    }
                }
            });
        }
    }

    public void invalidateAll() {
        this.getTaskFor(URI.createURI((String)"")).add(() -> {
            this.documentedObjects.clear();
            this.documentationTasks.clear();
        });
    }

    boolean isTaskValid(URI uRI) {
        return uRI != null && GamlResourceServices.isEdited(uRI);
    }

    boolean isValidGeneration(URI uRI, int n) {
        return this.getCurrentDocGenerationFor(uRI) == n;
    }

    GamlResourceDocumentationTask getTaskFor(URI uRI) {
        return this.documentationTasks.computeIfAbsent(uRI, GamlResourceDocumentationTask::new);
    }

    int getCurrentDocGenerationFor(URI uRI) {
        return this.getTaskFor((URI)uRI).currentGeneration;
    }

    record DocumentedObject(IDocManager.DocumentationNode node, Set<URI> resources) {
    }
}

