/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.expression;

import gama.gaml.compilation.GAML;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.expressions.units.UnitConstantExpression;
import gama.gaml.interfaces.IGamlDescription;
import gaml.compiler.gaml.BooleanLiteral;
import gaml.compiler.gaml.DoubleLiteral;
import gaml.compiler.gaml.EGaml;
import gaml.compiler.gaml.IntLiteral;
import gaml.compiler.gaml.StringLiteral;
import gaml.compiler.gaml.Unary;
import gaml.compiler.gaml.UnitName;
import gaml.compiler.gaml.expression.BlockExpressionDescription;
import gaml.compiler.gaml.expression.EcoreBasedExpressionDescription;
import gaml.compiler.gaml.resource.GamlResourceServices;
import gaml.compiler.gaml.util.GamlSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ExpressionDescriptionBuilder
extends GamlSwitch<IExpressionDescription> {
    @Override
    public ConstantExpressionDescription caseIntLiteral(IntLiteral intLiteral) {
        ConstantExpressionDescription constantExpressionDescription = null;
        try {
            constantExpressionDescription = ConstantExpressionDescription.create((Integer)Integer.parseInt(intLiteral.getOp()));
        }
        catch (NumberFormatException numberFormatException) {
            constantExpressionDescription = ConstantExpressionDescription.create((Integer)0);
        }
        Resource resource = intLiteral.eResource();
        if (resource != null) {
            GamlResourceServices.getResourceDocumenter().setGamlDocumentation(resource.getURI(), intLiteral, (IGamlDescription)constantExpressionDescription);
        }
        return constantExpressionDescription;
    }

    @Override
    public ConstantExpressionDescription caseDoubleLiteral(DoubleLiteral doubleLiteral) {
        ConstantExpressionDescription constantExpressionDescription = null;
        try {
            constantExpressionDescription = ConstantExpressionDescription.create((Double)Double.parseDouble(doubleLiteral.getOp()));
        }
        catch (NumberFormatException numberFormatException) {
            constantExpressionDescription = ConstantExpressionDescription.create((Double)0.0);
        }
        Resource resource = doubleLiteral.eResource();
        if (resource != null) {
            GamlResourceServices.getResourceDocumenter().setGamlDocumentation(resource.getURI(), doubleLiteral, (IGamlDescription)constantExpressionDescription.getExpression());
        }
        return constantExpressionDescription;
    }

    @Override
    public ConstantExpressionDescription caseStringLiteral(StringLiteral stringLiteral) {
        ConstantExpressionDescription constantExpressionDescription = ConstantExpressionDescription.create((Object)stringLiteral.getOp());
        Resource resource = stringLiteral.eResource();
        if (resource != null) {
            GamlResourceServices.getResourceDocumenter().setGamlDocumentation(resource.getURI(), stringLiteral, (IGamlDescription)constantExpressionDescription.getExpression());
        }
        return constantExpressionDescription;
    }

    @Override
    public ConstantExpressionDescription caseBooleanLiteral(BooleanLiteral booleanLiteral) {
        ConstantExpressionDescription constantExpressionDescription = ConstantExpressionDescription.create((Boolean)"true".equals(booleanLiteral.getOp()));
        Resource resource = booleanLiteral.eResource();
        if (resource != null) {
            GamlResourceServices.getResourceDocumenter().setGamlDocumentation(resource.getURI(), booleanLiteral, (IGamlDescription)constantExpressionDescription.getExpression());
        }
        return constantExpressionDescription;
    }

    @Override
    public IExpressionDescription caseUnitName(UnitName unitName) {
        String string = EGaml.getInstance().getKeyOf(unitName);
        UnitConstantExpression unitConstantExpression = (UnitConstantExpression)GAML.UNITS.get(string);
        return unitConstantExpression;
    }

    @Override
    public IExpressionDescription caseUnary(Unary unary) {
        String string = EGaml.getInstance().getKeyOf(unary);
        if ("#".equals(string)) {
            return (IExpressionDescription)this.doSwitch(unary.getRight());
        }
        return null;
    }

    @Override
    public IExpressionDescription defaultCase(EObject eObject) {
        return new EcoreBasedExpressionDescription(eObject);
    }

    public IExpressionDescription createBlock(ISyntacticElement iSyntacticElement) {
        return new BlockExpressionDescription(iSyntacticElement);
    }

    public IExpressionDescription create(EObject eObject) {
        IExpressionDescription iExpressionDescription = (IExpressionDescription)this.doSwitch(eObject);
        iExpressionDescription.setTarget(eObject);
        return iExpressionDescription;
    }
}

