/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.expression;

import com.google.common.collect.Iterables;
import gama.core.common.util.StringUtils;
import gama.core.outputs.layers.KeyboardEventLayerDelegate;
import gama.core.outputs.layers.MouseEventLayerDelegate;
import gama.core.runtime.GAMA;
import gama.core.runtime.IExecutionContext;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaMapFactory;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.compilation.kernel.GamaSkillRegistry;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.IVarDescriptionProvider;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.PlatformSpeciesDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.StringBasedExpressionDescription;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.descriptions.ValidationContext;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionCompiler;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.expressions.operators.TypeFieldExpression;
import gama.gaml.expressions.types.DenotedActionExpression;
import gama.gaml.expressions.units.UnitConstantExpression;
import gama.gaml.expressions.variables.CurrentExperimentExpression;
import gama.gaml.expressions.variables.EachExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.statements.Arguments;
import gama.gaml.types.GamaType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.ITypesManager;
import gama.gaml.types.ParametricType;
import gama.gaml.types.Signature;
import gama.gaml.types.Types;
import gaml.compiler.gaml.Access;
import gaml.compiler.gaml.ActionRef;
import gaml.compiler.gaml.ArgumentPair;
import gaml.compiler.gaml.Array;
import gaml.compiler.gaml.BinaryOperator;
import gaml.compiler.gaml.BooleanLiteral;
import gaml.compiler.gaml.DoubleLiteral;
import gaml.compiler.gaml.EGaml;
import gaml.compiler.gaml.EquationRef;
import gaml.compiler.gaml.Expression;
import gaml.compiler.gaml.ExpressionList;
import gaml.compiler.gaml.Function;
import gaml.compiler.gaml.If;
import gaml.compiler.gaml.IntLiteral;
import gaml.compiler.gaml.Parameter;
import gaml.compiler.gaml.Point;
import gaml.compiler.gaml.ReservedLiteral;
import gaml.compiler.gaml.SkillFakeDefinition;
import gaml.compiler.gaml.SkillRef;
import gaml.compiler.gaml.StringEvaluator;
import gaml.compiler.gaml.StringLiteral;
import gaml.compiler.gaml.TypeDefinition;
import gaml.compiler.gaml.TypeInfo;
import gaml.compiler.gaml.TypeRef;
import gaml.compiler.gaml.Unary;
import gaml.compiler.gaml.Unit;
import gaml.compiler.gaml.UnitName;
import gaml.compiler.gaml.VarDefinition;
import gaml.compiler.gaml.VariableRef;
import gaml.compiler.gaml.expression.ExpressionDescriptionBuilder;
import gaml.compiler.gaml.resource.GamlResource;
import gaml.compiler.gaml.resource.GamlResourceServices;
import gaml.compiler.gaml.util.GamlSwitch;
import java.io.ByteArrayInputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class GamlExpressionCompiler
extends GamlSwitch<IExpression>
implements IExpressionCompiler<Expression> {
    private final Deque<IVarExpression> iteratorContexts = new LinkedList<IVarExpression>();
    private IExpressionDescription currentExpressionDescription;
    private ITypesManager currentTypesManager;
    private static final Map<String, IExpression> constantSyntheticExpressions = GamaMapFactory.createUnordered();
    private static final ExpressionDescriptionBuilder builder = new ExpressionDescriptionBuilder();
    private IDescription currentContext;

    static {
        GAML.OPERATORS.put("my", GamaMapFactory.createUnordered());
    }

    public IExpression compile(IExpressionDescription iExpressionDescription, IDescription iDescription) {
        if (iExpressionDescription.isConst() || iExpressionDescription == this.getCurrentExpressionDescription()) {
            return iExpressionDescription.getExpression();
        }
        this.setCurrentExpressionDescription(iExpressionDescription);
        EObject eObject = iExpressionDescription.getTarget();
        if (eObject == null && iExpressionDescription instanceof StringBasedExpressionDescription) {
            IExecutionContext iExecutionContext = GAMA.getExperiment() == null ? null : GAMA.getRuntimeScope().getExecutionContext();
            return this.compile(iExpressionDescription.toString(), iDescription, iExecutionContext);
        }
        IDescription iDescription2 = this.setContext(iDescription);
        try {
            IExpression iExpression = this.compile(eObject);
            return iExpression;
        }
        finally {
            this.setContext(iDescription2);
            this.setCurrentExpressionDescription(null);
        }
    }

    public IExpression compile(String string, IDescription iDescription, IExecutionContext iExecutionContext) {
        IDescription iDescription2 = this.setContext(iDescription);
        try {
            IExpression iExpression = constantSyntheticExpressions.get(string);
            if (iExpression != null) {
                IExpression iExpression2 = iExpression;
                return iExpression2;
            }
            EObject eObject = this.getEObjectOf(string, iExecutionContext);
            iExpression = this.compile(eObject);
            if (iExpression != null && iExpression.isContextIndependant()) {
                constantSyntheticExpressions.put(string, iExpression);
            }
            IExpression iExpression3 = iExpression;
            return iExpression3;
        }
        finally {
            this.setContext(iDescription2);
            this.setCurrentExpressionDescription(null);
        }
    }

    private IExpression compile(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        IExpression iExpression = (IExpression)this.doSwitch(eObject.eClass().getClassifierID(), eObject);
        if (iExpression != null && this.getContext() != null) {
            this.getContext().document(eObject, (IGamlDescription)iExpression);
        }
        return iExpression;
    }

    private IExpression skill(String string) {
        return this.getFactory().createConst((Object)string, Types.SKILL);
    }

    private IExpression unary(String string, Expression expression) {
        if (string == null) {
            return null;
        }
        IExpression iExpression = this.compile(expression);
        if (iExpression == null) {
            return null;
        }
        if ("my".equals(string)) {
            IVarDescriptionProvider iVarDescriptionProvider = this.getContext().getDescriptionDeclaringVar("myself");
            if (iVarDescriptionProvider instanceof IDescription) {
                IExpression iExpression2 = iVarDescriptionProvider.getVarExpr("myself", false);
                SpeciesDescription speciesDescription = iExpression2.getGamlType().getSpecies();
                IExpression iExpression3 = speciesDescription.getVarExpr(EGaml.getInstance().getKeyOf(expression), true);
                return this.getFactory().createOperator(".", (IDescription)iVarDescriptionProvider, (EObject)expression, new IExpression[]{iExpression2, iExpression3});
            }
            return iExpression;
        }
        if ("#".equals(string)) {
            return iExpression;
        }
        if (this.isSpeciesName(string)) {
            return this.getFactory().createAs(this.getContext(), iExpression, (IExpression)this.getSpeciesContext(string).getSpeciesExpr());
        }
        OperatorProto operatorProto = iExpression.getGamlType().getGetter(string);
        if (operatorProto != null) {
            TypeFieldExpression typeFieldExpression = (TypeFieldExpression)operatorProto.create(this.getContext(), (EObject)expression, new IExpression[]{iExpression});
            if (this.getContext() != null) {
                this.getContext().document((EObject)expression, (IGamlDescription)iExpression);
            }
            return typeFieldExpression;
        }
        return this.getFactory().createOperator(string, this.getContext(), (EObject)expression, new IExpression[]{iExpression});
    }

    private IExpression casting(IType iType, IExpression iExpression, Expression expression) {
        IType iType2;
        if (iExpression == null) {
            return null;
        }
        IType iType3 = iType.typeIfCasting(iExpression);
        TypeInfo typeInfo = null;
        if (expression instanceof TypeRef) {
            typeInfo = ((TypeRef)expression).getParameter();
        } else if (expression instanceof Function) {
            typeInfo = ((Function)expression).getType();
        }
        IType iType4 = iType3.getKeyType();
        IType iType5 = iType3.getContentType();
        if (typeInfo != null) {
            iType2 = this.fromTypeRef((TypeRef)typeInfo.getFirst());
            IType iType6 = this.fromTypeRef((TypeRef)typeInfo.getSecond());
            if (iType6 == null || iType6 == Types.NO_TYPE) {
                iType6 = iType2;
                iType2 = null;
            }
            if (iType6 != null && iType6 != Types.NO_TYPE) {
                iType5 = iType6;
            }
            if (iType2 != null && iType2 != Types.NO_TYPE) {
                iType4 = iType2;
            }
        }
        iType2 = GamaType.from((IType)iType3, (IType)iType4, (IType)iType5);
        return this.getFactory().createAs((IDescription)this.getContext().getSpeciesContext(), iExpression, this.getFactory().createTypeExpression(iType2));
    }

    IType fromTypeRef(TypeRef typeRef) {
        if (typeRef == null) {
            return null;
        }
        String string = EGaml.getInstance().getKeyOf(typeRef);
        if (string == null) {
            string = typeRef.getRef().getName();
        } else if ("species_var".equals(string)) {
            string = "species";
        }
        IType iType = this.currentTypesManager.get(string);
        if (iType == Types.NO_TYPE && !"unknown".equals(string)) {
            this.getContext().error(string + " is not a valid type name", "gaml.not.a.type.issue", (EObject)typeRef, new String[]{string});
            return iType;
        }
        if (iType.isAgentType() && iType.getSpecies().isModel()) {
            TypeInfo typeInfo = typeRef.getParameter();
            if (typeInfo == null) {
                return iType;
            }
            TypeRef typeRef2 = (TypeRef)typeInfo.getFirst();
            if (typeRef2 == null) {
                return iType;
            }
            ITypesManager iTypesManager = this.currentTypesManager;
            try {
                this.currentTypesManager = iType.getSpecies().getModelDescription().getTypesManager();
                IType iType2 = this.fromTypeRef(typeRef2);
                return iType2;
            }
            finally {
                this.currentTypesManager = iTypesManager;
            }
        }
        this.getContext().document((EObject)typeRef, (IGamlDescription)iType);
        if (iType.isAgentType()) {
            return iType;
        }
        TypeInfo typeInfo = typeRef.getParameter();
        if (typeInfo == null) {
            return iType;
        }
        int n = iType.getNumberOfParameters();
        if (n == 0) {
            this.getContext().warning(String.valueOf(iType) + " is not a parametric type. Type parameters will be ignored", "gaml.wrong.type.issue", (EObject)typeRef, new String[0]);
            return iType;
        }
        TypeRef typeRef3 = (TypeRef)typeInfo.getFirst();
        if (typeRef3 == null) {
            return iType;
        }
        TypeRef typeRef4 = (TypeRef)typeInfo.getSecond();
        if (typeRef4 == null) {
            if (n == 2) {
                this.getContext().warning(String.valueOf(iType) + " expects two type parameters", "gaml.wrong.type.issue", (EObject)typeRef, new String[0]);
            }
            return GamaType.from((IType)iType, (IType)iType.getKeyType(), (IType)this.fromTypeRef(typeRef3));
        }
        if (n == 1) {
            this.getContext().error(String.valueOf(iType) + " expects only one type parameter", "gaml.wrong.type.issue", (EObject)typeRef, new String[0]);
            return null;
        }
        return GamaType.from((IType)iType, (IType)this.fromTypeRef(typeRef3), (IType)this.fromTypeRef(typeRef4));
    }

    private IExpression binary(String string, IExpression iExpression, Expression iExpressionArray) {
        IExpression[] iExpressionArray2;
        Object object;
        Object object2;
        if (iExpression == null) {
            return null;
        }
        if (!GAML.OPERATORS.containsKey(string)) {
            this.getContext().error("Unknown operator: " + string, "gaml.unknown.action.issue", iExpressionArray.eContainer(), new String[]{string});
            return null;
        }
        Object object3 = iExpressionArray;
        boolean bl = GAML.ITERATORS.contains(string);
        if (bl) {
            object2 = "each";
            if (object3 instanceof ExpressionList) {
                object = (ExpressionList)object3;
                List<Expression> list = EGaml.getInstance().getExprsOf((EObject)object);
                if (!list.isEmpty()) {
                    iExpressionArray2 = list.get(0);
                    if (iExpressionArray2 instanceof Parameter) {
                        Parameter parameter = (Parameter)iExpressionArray2;
                        object2 = EGaml.getInstance().getKeyOf(parameter);
                        object3 = parameter.getRight();
                    } else {
                        object3 = iExpressionArray2;
                    }
                }
            }
            this.iteratorContexts.push((IVarExpression)new EachExpression((String)object2, iExpression.getGamlType().getContentType()));
        }
        if (object3 instanceof ExpressionList) {
            object2 = (ExpressionList)object3;
            object = EGaml.getInstance().getExprsOf((EObject)object2);
            int n = object.size();
            if (n > 1) {
                iExpressionArray2 = new IExpression[n + 1];
                iExpressionArray2[0] = iExpression;
                int n2 = 0;
                while (n2 < n) {
                    iExpressionArray2[n2 + 1] = this.compile((EObject)object.get(n2));
                    ++n2;
                }
                return this.getFactory().createOperator(string, this.getContext(), (EObject)object3, iExpressionArray2);
            }
        }
        object = this.compile((EObject)object3);
        if (bl) {
            this.iteratorContexts.pop();
        }
        return this.getFactory().createOperator(string, this.getContext(), iExpressionArray.eContainer(), new IExpression[]{iExpression, object});
    }

    private IExpression action(String string, IExpression iExpression, ExpressionList expressionList, ActionDescription actionDescription) {
        Arguments arguments = this.parseArguments(actionDescription, expressionList, this.getContext(), true);
        return this.getFactory().createAction(string, this.getContext(), actionDescription, iExpression, arguments);
    }

    @Override
    public IExpression caseBinaryOperator(BinaryOperator binaryOperator) {
        return this.binary(binaryOperator.getOp(), binaryOperator.getLeft(), binaryOperator.getRight());
    }

    private IExpression binary(String string, Expression expression, Expression expression2) {
        return switch (string) {
            case "of" -> this.compileFieldExpr(expression2, expression);
            case "as" -> {
                String var5_5 = EGaml.getInstance().getKeyOf(expression2);
                IType var6_7 = this.getType(var5_5);
                if (var6_7 != null) {
                    yield this.casting(var6_7, this.compile(expression), expression2);
                }
                this.getContext().error("'as' must be followed by a type, species or skill name. " + var5_5 + " is neither of these.", "gaml.not.a.type.issue", (EObject)expression2, new String[]{var5_5});
                yield null;
            }
            case "is" -> {
                IExpression var5_6 = this.compile(expression);
                String var6_8 = EGaml.getInstance().getKeyOf(expression2);
                if (this.isTypeName(var6_8)) {
                    yield this.getFactory().createOperator("is", this.getContext(), expression2.eContainer(), new IExpression[]{var5_6, this.getFactory().createConst((Object)var6_8, (IType)Types.STRING)});
                }
                if (this.isSkillName(var6_8)) {
                    yield this.getFactory().createOperator("is_skill", this.getContext(), expression2.eContainer(), new IExpression[]{var5_6, this.getFactory().createConst((Object)var6_8, Types.SKILL)});
                }
                this.getContext().error("'is' must be followed by a type, species or skill name. " + var6_8 + " is neither of these.", "gaml.not.a.type.issue", (EObject)expression2, new String[]{var6_8});
                yield null;
            }
            default -> this.binary(string, this.compile(expression), expression2);
        };
    }

    private SpeciesDescription getSpeciesContext(String string) {
        return this.getContext().getSpeciesDescription(string);
    }

    private boolean isSpeciesName(String string) {
        ModelDescription modelDescription = this.getContext().getModelDescription();
        if (modelDescription == null) {
            return false;
        }
        SpeciesDescription speciesDescription = modelDescription.getSpeciesDescription(string);
        return speciesDescription != null && !(speciesDescription instanceof ExperimentDescription);
    }

    private boolean isSkillName(String string) {
        return GamaSkillRegistry.INSTANCE.hasSkill(string);
    }

    private boolean isTypeName(String string) {
        IType iType = this.currentTypesManager.get(string, null);
        if (iType == null) {
            return false;
        }
        SpeciesDescription speciesDescription = iType.getSpecies();
        return speciesDescription == null || !speciesDescription.isExperiment();
    }

    private IType getType(String string) {
        IType iType = this.currentTypesManager.get(string, null);
        if (iType == null) {
            return null;
        }
        SpeciesDescription speciesDescription = iType.getSpecies();
        if (speciesDescription != null && speciesDescription.isExperiment()) {
            return null;
        }
        return iType;
    }

    private IExpression compileNamedExperimentFieldExpr(Expression expression, String string) {
        ModelDescription modelDescription;
        SpeciesDescription speciesDescription;
        IExpression iExpression = this.compile(expression);
        if (iExpression == null) {
            return null;
        }
        IType iType = iExpression.getGamlType();
        if (iType.isParametricFormOf((IType)Types.SPECIES) && (speciesDescription = iType.getContentType().getSpecies()) instanceof ModelDescription && (modelDescription = (ModelDescription)speciesDescription).hasExperiment(string)) {
            return this.getFactory().createConst((Object)string, GamaType.from((TypeDescription)modelDescription.getExperiment(string)));
        }
        this.getContext().error("Only experiments can be accessed using their plain name", "gaml.unknown.field.issue");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IExpression compileFieldExpr(Expression expression, Expression expression2) {
        ActionDescription actionDescription;
        ModelDescription modelDescription;
        SpeciesDescription speciesDescription;
        ParametricType parametricType;
        IExpression iExpression = this.compile(expression);
        if (iExpression == null) {
            return null;
        }
        String string = EGaml.getInstance().getKeyOf(expression2);
        IType iType = iExpression.getGamlType();
        if (iType instanceof ParametricType && (parametricType = (ParametricType)iType).getGamlType().id() == 14 && (speciesDescription = parametricType.getContentType().getSpecies()) instanceof ModelDescription && (modelDescription = (ModelDescription)speciesDescription).hasExperiment(string)) {
            return this.getFactory().createConst((Object)string, GamaType.from((TypeDescription)modelDescription.getExperiment(string)));
        }
        SpeciesDescription speciesDescription2 = iType.getSpecies();
        if (speciesDescription2 == null) {
            OperatorProto operatorProto = iType.getGetter(string);
            if (operatorProto == null) {
                if (iType.id() == 8) {
                    return this.binary(".", iExpression, expression2);
                }
                this.getContext().error("Unknown field '" + string + "' for type " + String.valueOf(iType), "gaml.unknown.field.issue", (EObject)expression, new String[]{string, iType.toString()});
                return null;
            }
            TypeFieldExpression typeFieldExpression = (TypeFieldExpression)operatorProto.create(this.getContext(), (EObject)expression2, new IExpression[]{iExpression});
            if (this.getContext() != null) {
                this.getContext().document((EObject)expression2, (IGamlDescription)typeFieldExpression);
            }
            return typeFieldExpression;
        }
        if (expression2 instanceof VariableRef) {
            IExpression iExpression2;
            block17: {
                ModelDescription modelDescription2;
                iExpression2 = speciesDescription2.getVarExpr(string, true);
                if (iExpression2 == null) {
                    ModelDescription modelDescription3;
                    if (speciesDescription2 instanceof ModelDescription && (modelDescription3 = (ModelDescription)speciesDescription2).hasExperiment(string)) {
                        iExpression2 = this.getFactory().createTypeExpression((IType)GamaType.from((IContainerType)Types.SPECIES, (IType)Types.INT, (IType)modelDescription3.getTypeNamed(string)));
                        break block17;
                    } else {
                        if (speciesDescription2 instanceof PlatformSpeciesDescription) {
                            PlatformSpeciesDescription platformSpeciesDescription = (PlatformSpeciesDescription)speciesDescription2;
                            if (GAMA.isInHeadLessMode()) {
                                return platformSpeciesDescription.getFakePrefExpression(string);
                            }
                        }
                        this.getContext().error("Unknown variable '" + string + "' in " + speciesDescription2.getKeyword() + " " + speciesDescription2.getName(), "gaml.unknown.var.issue", expression2.eContainer(), new String[]{string, speciesDescription2.getName()});
                        return null;
                    }
                }
                if ("simulation".equals(string) && iExpression2.getGamlType().equals(Types.get((String)"model"))) {
                    ModelDescription modelDescription4 = this.getContext().getModelDescription();
                    if (modelDescription4 != null) {
                        iExpression2 = this.getFactory().createAs(this.currentContext, iExpression2, modelDescription4.getGamlType());
                    }
                } else if ("simulations".equals(string) && iExpression2.getGamlType().getContentType().equals(Types.get((String)"model")) && (modelDescription2 = this.getContext().getModelDescription()) != null) {
                    iExpression2 = this.getFactory().createAs(this.currentContext, iExpression2, (IType)Types.LIST.of(modelDescription2.getGamlType()));
                }
            }
            this.getContext().document((EObject)expression2, (IGamlDescription)iExpression2);
            return this.getFactory().createOperator(".", this.getContext(), (EObject)expression2, new IExpression[]{iExpression, iExpression2});
        }
        if (expression2 instanceof Function && (actionDescription = speciesDescription2.getAction(string)) != null) {
            ExpressionList expressionList = ((Function)expression2).getRight();
            IExpression iExpression3 = this.action(string, iExpression, expressionList, actionDescription);
            this.getContext().document((EObject)expression2, (IGamlDescription)iExpression3);
            return iExpression3;
        }
        return null;
    }

    private IDescription setContext(IDescription iDescription) {
        ITypesManager iTypesManager;
        ModelDescription modelDescription;
        IDescription iDescription2 = this.currentContext;
        this.currentContext = iDescription == null ? GAML.getModelContext() : iDescription;
        this.currentTypesManager = Types.builtInTypes;
        if (this.currentContext != null && (modelDescription = this.currentContext.getModelDescription()) != null && (iTypesManager = modelDescription.getTypesManager()) != null) {
            this.currentTypesManager = iTypesManager;
        }
        return iDescription2;
    }

    private IDescription getContext() {
        return this.currentContext;
    }

    private ValidationContext getValidationContext() {
        if (this.currentContext == null) {
            return null;
        }
        return this.currentContext.getValidationContext();
    }

    public Arguments parseArguments(ActionDescription actionDescription, EObject eObject, IDescription iDescription, boolean bl) {
        if (eObject == null) {
            return null;
        }
        boolean bl2 = false;
        List<Expression> list = null;
        EGaml eGaml = EGaml.getInstance();
        if (eObject instanceof Array) {
            Array array = (Array)eObject;
            list = eGaml.getExprsOf(array.getExprs());
        } else if (eObject instanceof ExpressionList) {
            list = eGaml.getExprsOf(eObject);
            bl2 = true;
        } else {
            iDescription.error("Arguments must be written [a1::v1, a2::v2], (a1:v1, a2:v2) or (v1, v2)");
            return null;
        }
        Arguments arguments = new Arguments();
        int n = 0;
        for (Expression expression : list) {
            BinaryOperator binaryOperator;
            String string = null;
            IExpressionDescription iExpressionDescription = null;
            if (expression instanceof ArgumentPair) {
                ArgumentPair argumentPair = (ArgumentPair)expression;
                string = eGaml.getKeyOfArgumentPair(argumentPair);
                iExpressionDescription = builder.create(argumentPair.getRight());
            } else if (expression instanceof Parameter) {
                Parameter parameter = (Parameter)expression;
                string = eGaml.getKeyOfParameter(parameter);
                iExpressionDescription = builder.create(parameter.getRight());
            } else if (expression instanceof BinaryOperator && "::".equals((binaryOperator = (BinaryOperator)expression).getOp())) {
                string = eGaml.getKeyOf(binaryOperator.getLeft());
                iExpressionDescription = builder.create(binaryOperator.getRight());
            } else if (bl2) {
                List list2;
                List list3 = list2 = actionDescription == null ? null : actionDescription.getArgNames();
                if (list2 != null && actionDescription != null && n == list2.size()) {
                    iDescription.error("Wrong number of arguments. Action " + actionDescription.getName() + " expects " + String.valueOf(list2));
                    return arguments;
                }
                string = list2 == null ? String.valueOf(n++) : (String)list2.get(n++);
                iExpressionDescription = builder.create(expression);
            }
            if (iExpressionDescription != null && bl) {
                iExpressionDescription.compile(iDescription);
            }
            arguments.put(string, iExpressionDescription);
        }
        return arguments;
    }

    @Override
    public IExpression caseSkillRef(SkillRef skillRef) {
        return this.skill(EGaml.getInstance().getKeyOf(skillRef));
    }

    @Override
    public IExpression caseActionRef(ActionRef actionRef) {
        String string = EGaml.getInstance().getKeyOf(actionRef);
        SpeciesDescription speciesDescription = this.getContext().getSpeciesContext();
        ActionDescription actionDescription = speciesDescription.getAction(string);
        if (actionDescription == null) {
            IDescription iDescription;
            boolean bl;
            if (speciesDescription instanceof ExperimentDescription) {
                ExperimentDescription experimentDescription = (ExperimentDescription)speciesDescription;
                v0 = true;
            } else {
                v0 = bl = false;
            }
            if (!bl && (iDescription = speciesDescription.getEnclosingDescription()) != null) {
                actionDescription = iDescription.getAction(string);
            }
            if (actionDescription == null) {
                if (bl) {
                    this.getContext().error("The action " + string + " must be defined in the experiment", "gaml.unknown.action.issue", (EObject)actionRef, new String[0]);
                } else {
                    this.getContext().error("The action " + string + " is unknown", "gaml.unknown.action.issue", (EObject)actionRef, new String[0]);
                }
                return null;
            }
        }
        if (actionDescription.getArgNames().size() > 0) {
            this.getContext().error("Impossible to call an action that requires arguments", "gaml.unknonw.argument.issue", (EObject)actionRef, new String[0]);
            return null;
        }
        return new DenotedActionExpression((StatementDescription)actionDescription);
    }

    @Override
    public IExpression caseVariableRef(VariableRef variableRef) {
        String string = EGaml.getInstance().getNameOfRef(variableRef);
        if (string == null) {
            return this.caseVarDefinition(variableRef.getRef());
        }
        return this.caseVar(string, variableRef);
    }

    @Override
    public IExpression caseTypeRef(TypeRef typeRef) {
        IType iType = this.fromTypeRef(typeRef);
        if (iType == null) {
            return null;
        }
        if (iType.isAgentType()) {
            return iType.getSpecies().getSpeciesExpr();
        }
        return this.getFactory().createTypeExpression(iType);
    }

    @Override
    public IExpression caseEquationRef(EquationRef equationRef) {
        return this.getFactory().createConst((Object)EGaml.getInstance().getNameOfRef(equationRef), (IType)Types.STRING);
    }

    @Override
    public IExpression caseUnitName(UnitName unitName) {
        String string = EGaml.getInstance().getNameOfRef(unitName);
        UnitConstantExpression unitConstantExpression = this.caseUnitName(string);
        if (unitConstantExpression == null) {
            this.getContext().error(string + " is not a unit or constant name.", "gaml.not.a.unit.issue", (EObject)unitName, null);
            return null;
        }
        if (unitConstantExpression.isDeprecated()) {
            this.getContext().warning(string + " is deprecated.", "gaml.deprecated.code.issue", (EObject)unitName, null);
        }
        return unitConstantExpression;
    }

    public UnitConstantExpression caseUnitName(String string) {
        if (GAML.UNITS.containsKey(string)) {
            return this.getFactory().getUnitExpr(string);
        }
        return null;
    }

    @Override
    public IExpression caseVarDefinition(VarDefinition varDefinition) {
        return this.skill(varDefinition.getName());
    }

    @Override
    public IExpression caseTypeDefinition(TypeDefinition typeDefinition) {
        return this.caseVar(typeDefinition.getName(), typeDefinition);
    }

    @Override
    public IExpression caseSkillFakeDefinition(SkillFakeDefinition skillFakeDefinition) {
        return this.caseVar(skillFakeDefinition.getName(), skillFakeDefinition);
    }

    @Override
    public IExpression caseReservedLiteral(ReservedLiteral reservedLiteral) {
        return this.caseVar(EGaml.getInstance().getKeyOf(reservedLiteral), reservedLiteral);
    }

    @Override
    public IExpression caseIf(If if_) {
        IExpression iExpression = this.compile(if_.getIfFalse());
        IExpression iExpression2 = this.getFactory().createOperator(":", this.getContext(), (EObject)if_, new IExpression[]{this.compile(if_.getRight()), iExpression});
        return this.getFactory().createOperator("?", this.getContext(), (EObject)if_, new IExpression[]{this.compile(if_.getLeft()), iExpression2});
    }

    @Override
    public IExpression caseArgumentPair(ArgumentPair argumentPair) {
        return this.binary("::", this.caseVar(EGaml.getInstance().getKeyOf(argumentPair), argumentPair), argumentPair.getRight());
    }

    @Override
    public IExpression caseUnit(Unit unit) {
        return this.binary("*", unit.getLeft(), unit.getRight());
    }

    @Override
    public IExpression caseUnary(Unary unary) {
        return this.unary(EGaml.getInstance().getKeyOf(unary), unary.getRight());
    }

    public IExpression caseDot(Access access) {
        Expression expression = access.getRight();
        if (expression instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expression;
            return this.compileNamedExperimentFieldExpr(access.getLeft(), stringLiteral.getOp());
        }
        if (expression != null) {
            return this.compileFieldExpr(access.getLeft(), expression);
        }
        return null;
    }

    @Override
    public IExpression caseAccess(Access access) {
        if (".".equals(access.getOp())) {
            return this.caseDot(access);
        }
        IExpression iExpression = this.compile(access.getLeft());
        if (iExpression == null) {
            return null;
        }
        IType iType = iExpression.getGamlType();
        boolean bl = Types.MATRIX.isAssignableFrom(iType);
        IType iType2 = iType.getKeyType();
        List<Expression> list = EGaml.getInstance().getExprsOf(access.getRight());
        Throwable throwable = null;
        Object var8_9 = null;
        try (Collector.AsList asList = Collector.getList();){
            Object object;
            IExpression iExpression2;
            Expression expression;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                expression = list.get(n2);
                iExpression2 = this.compile(expression);
                if (iExpression2 != null) {
                    object = iExpression2.getGamlType();
                    if (n == 1 && Types.PAIR.isAssignableFrom((IType)object) && Types.LIST.isAssignableFrom(iType) && Types.INT == object.getKeyType() && Types.INT == object.getContentType()) {
                        return this.getFactory().createOperator("internal_between", this.getContext(), (EObject)access, new IExpression[]{iExpression, iExpression2});
                    }
                    if (!(iType2 == Types.NO_TYPE || iType2.isAssignableFrom((IType)object) || bl && object.id() == 1)) {
                        this.getContext().warning("a " + iType.toString() + " should not be accessed using a " + object.toString() + " index", "gaml.wrong.type.issue", (EObject)expression, new String[0]);
                    }
                    asList.add((Object)iExpression2);
                }
                ++n2;
            }
            if (n > 2) {
                String string = !bl ? " only 1 index" : " 1 or 2 indices";
                this.getContext().warning("a " + iType.toString() + " should be accessed using" + string, "gaml.different.arguments.issue", (EObject)access, new String[0]);
            }
            IExpression iExpression3 = this.getFactory().createList((Iterable)asList.items());
            expression = null;
            if (iExpression instanceof IVarExpression.Agent && ((IVarExpression.Agent)iExpression).getOwner() != null && (iExpression2 = ((IVarExpression.Agent)(expression = ((IVarExpression.Agent)iExpression).getVar())).getDefinitionDescription().getSpeciesContext()) != null) {
                object = iExpression2.getChildrenWithKeyword("equation");
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    IDescription iDescription = (IDescription)iterator.next();
                    if (!iDescription.manipulatesVar(expression.getName())) continue;
                    return this.getFactory().createOperator("internal_integrated_value", this.getContext(), (EObject)access, new IExpression[]{((IVarExpression.Agent)iExpression).getOwner(), expression});
                }
            }
            return this.getFactory().createOperator("internal_at", this.getContext(), (EObject)access, new IExpression[]{iExpression, iExpression3});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public IExpression caseArray(Array array) {
        List<Expression> list = EGaml.getInstance().getExprsOf(array.getExprs());
        boolean bl = !list.isEmpty() && Iterables.all(list, expression -> expression instanceof ArgumentPair || "::".equals(EGaml.getInstance().getKeyOf((EObject)expression)));
        Iterable iterable = Iterables.transform(list, this::compile);
        if (Iterables.any((Iterable)iterable, iExpression -> iExpression == null)) {
            return null;
        }
        return bl ? this.getFactory().createMap(iterable) : this.getFactory().createList(iterable);
    }

    @Override
    public IExpression casePoint(Point point) {
        Expression expression = point.getZ();
        if (expression == null) {
            return this.binary("point", point.getLeft(), point.getRight());
        }
        IExpression[] iExpressionArray = new IExpression[]{this.compile(point.getLeft()), this.compile(point.getRight()), this.compile(expression)};
        if (iExpressionArray[0] == null || iExpressionArray[1] == null || iExpressionArray[2] == null) {
            return null;
        }
        return this.getFactory().createOperator("point", this.getContext(), (EObject)point, iExpressionArray);
    }

    @Override
    public IExpression caseExpressionList(ExpressionList expressionList) {
        List<Expression> list = EGaml.getInstance().getExprsOf(expressionList);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            this.getContext().warning("A sequence of expressions is not expected here. Only the first expression will be evaluated", "gaml.unknonw.argument.issue", (EObject)expressionList, new String[0]);
        }
        return this.compile(list.get(0));
    }

    @Override
    public IExpression caseFunction(Function function) {
        if (function == null) {
            return null;
        }
        String string = EGaml.getInstance().getKeyOf(function.getLeft());
        IExpression iExpression = this.tryCastingFunction(string, function);
        if (iExpression != null) {
            return iExpression;
        }
        iExpression = this.tryActionCall(string, function);
        if (iExpression != null) {
            return iExpression;
        }
        List<Expression> list = EGaml.getInstance().getExprsOf(function.getRight());
        return switch (list.size()) {
            case 0 -> {
                this.getContext().error("Unknown operator or action: " + string, "gaml.unknown.action.issue", (EObject)function, new String[0]);
                yield null;
            }
            case 1 -> this.unary(string, list.get(0));
            case 2 -> this.binary(string, list.get(0), list.get(1));
            default -> this.getFactory().createOperator(string, this.getContext(), (EObject)function, (IExpression[])Iterables.toArray((Iterable)Iterables.transform(list, this::compile), IExpression.class));
        };
    }

    private IExpression tryCastingFunction(String string, Function function) {
        IType iType = this.getType(string);
        if (iType == null) {
            if (function.getType() != null) {
                this.getContext().warning(string + " is not a type name: parameter types are not expected and will not be evaluated", "gaml.unknonw.argument.issue", (EObject)function.getType(), new String[0]);
            }
            return null;
        }
        List<Expression> list = EGaml.getInstance().getExprsOf(function.getRight());
        return switch (list.size()) {
            case 0 -> null;
            case 1 -> {
                IExpression var5_5 = this.compile(list.get(0));
                if (this.getFactory().hasExactOperator(string, var5_5)) {
                    yield null;
                }
                yield this.casting(iType, var5_5, function);
            }
            default -> {
                Iterable var5_6 = Iterables.transform(list, this::compile);
                yield this.getFactory().hasOperator(string, new Signature((IExpression[])Iterables.toArray((Iterable)var5_6, IExpression.class))) ? null : this.casting(iType, this.getFactory().createList(var5_6), function);
            }
        };
    }

    private IExpression tryActionCall(String string, Function function) {
        ActionDescription actionDescription;
        StatementDescription statementDescription;
        SpeciesDescription speciesDescription = this.getContext().getSpeciesContext();
        if (speciesDescription == null) {
            return null;
        }
        IDescription iDescription = this.getContext();
        boolean bl = iDescription instanceof StatementDescription && (statementDescription = (StatementDescription)iDescription).isSuperInvocation();
        ActionDescription actionDescription2 = actionDescription = bl ? speciesDescription.getParent().getAction(string) : speciesDescription.getAction(string);
        if (actionDescription == null) {
            if (speciesDescription instanceof ExperimentDescription && this.getContext().isIn("output")) {
                speciesDescription = speciesDescription.getModelDescription();
            }
            ActionDescription actionDescription3 = actionDescription = bl ? speciesDescription.getParent().getAction(string) : speciesDescription.getAction(string);
        }
        if (actionDescription == null) {
            return null;
        }
        ExpressionList expressionList = function.getRight();
        return this.action(string, this.caseVar(bl ? "super" : "self", function), expressionList, actionDescription);
    }

    @Override
    public IExpression caseIntLiteral(IntLiteral intLiteral) {
        try {
            Integer n = Integer.parseInt(EGaml.getInstance().getKeyOf(intLiteral), 10);
            return this.getFactory().createConst((Object)n, (IType)Types.INT);
        }
        catch (NumberFormatException numberFormatException) {
            this.getContext().error("Malformed integer: " + EGaml.getInstance().getKeyOf(intLiteral), "gaml.unknown.number.issue", (EObject)intLiteral, new String[0]);
            return null;
        }
    }

    @Override
    public IExpression caseDoubleLiteral(DoubleLiteral doubleLiteral) {
        String string = EGaml.getInstance().getKeyOf(doubleLiteral);
        if (string == null) {
            return null;
        }
        try {
            return this.getFactory().createConst((Object)Double.parseDouble(string), (IType)Types.FLOAT);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
                string = string.replace('e', 'E').replace("+", "");
                return this.getFactory().createConst((Object)numberFormat.parse(string).doubleValue(), (IType)Types.FLOAT);
            }
            catch (ParseException parseException) {
                this.getContext().error("Malformed float: " + string, "gaml.unknown.number.issue", (EObject)doubleLiteral, new String[0]);
                return null;
            }
        }
    }

    @Override
    public IExpression caseStringLiteral(StringLiteral stringLiteral) {
        return this.getFactory().createConst((Object)StringUtils.unescapeJava((String)EGaml.getInstance().getKeyOf(stringLiteral)), (IType)Types.STRING);
    }

    @Override
    public IExpression caseBooleanLiteral(BooleanLiteral booleanLiteral) {
        String string = EGaml.getInstance().getKeyOf(booleanLiteral);
        if (string == null) {
            return null;
        }
        return "true".equalsIgnoreCase(string) ? IExpressionFactory.TRUE_EXPR : IExpressionFactory.FALSE_EXPR;
    }

    @Override
    public IExpression defaultCase(EObject eObject) {
        ValidationContext validationContext = this.getValidationContext();
        if (validationContext != null && !validationContext.hasErrors()) {
            this.getContext().error("Cannot compile: " + String.valueOf(eObject), "gaml.general.issue", eObject, new String[0]);
        }
        return null;
    }

    private IExpression caseVar(String string, EObject eObject) {
        SpeciesDescription speciesDescription;
        SpeciesDescription speciesDescription2;
        IDescription iDescription;
        if (string == null) {
            this.getContext().error("Unknown variable", "gaml.unknown.var.issue", eObject, new String[0]);
            return null;
        }
        switch (string) {
            case "experiment": {
                return CurrentExperimentExpression.create();
            }
            case "gama": {
                return GAMA.getPlatformAgent();
            }
            case "each": {
                return this.getEachExpr(eObject);
            }
            case "nil": {
                return IExpressionFactory.NIL_EXPR;
            }
            case "self": {
                return this.returnSelfOrSuper("self", eObject, false);
            }
            case "super": {
                return this.returnSelfOrSuper("super", eObject, true);
            }
        }
        Iterator<IVarExpression> iterator = this.iteratorContexts.iterator();
        while (iterator.hasNext()) {
            iDescription = iterator.next();
            if (!iDescription.getName().equals(string)) continue;
            return iDescription;
        }
        iDescription = this.getContext();
        Object object = iterator = iDescription == null ? null : iDescription.getDescriptionDeclaringVar(string);
        if (iterator != null) {
            if (!(iterator instanceof SpeciesDescription)) {
                return iterator.getVarExpr(string, false);
            }
            speciesDescription2 = this.getContext().getSpeciesContext();
            if (speciesDescription2 != null) {
                speciesDescription = (SpeciesDescription)iterator;
                if (speciesDescription2 != iterator && !speciesDescription2.isBuiltIn() && !speciesDescription2.hasMacroSpecies(speciesDescription)) {
                    this.getContext().error("The variable " + string + " is not accessible in this context (" + speciesDescription2.getName() + "), but in the context of " + speciesDescription.getName() + ". It should be preceded by 'myself.'", "gaml.unknown.var.issue", eObject, new String[]{string});
                }
            }
            if (!this.isSpeciesName(string)) {
                return iterator.getVarExpr(string, false);
            }
        }
        if (this.isSpeciesName(string)) {
            speciesDescription2 = this.getSpeciesContext(string);
            return speciesDescription2 == null ? null : speciesDescription2.getSpeciesExpr();
        }
        speciesDescription2 = this.getType(string);
        if (speciesDescription2 != null) {
            return this.getFactory().createTypeExpression((IType)speciesDescription2);
        }
        if (this.isSkillName(string)) {
            return this.skill(string);
        }
        if (iDescription != null) {
            UnitConstantExpression unitConstantExpression;
            speciesDescription = iDescription.getSpeciesContext();
            if (speciesDescription.hasAction(string, false)) {
                return new DenotedActionExpression((StatementDescription)speciesDescription.getAction(string));
            }
            if (speciesDescription.hasBehavior(string)) {
                return new DenotedActionExpression(speciesDescription.getBehavior(string));
            }
            if (speciesDescription.hasAspect(string)) {
                return new DenotedActionExpression(speciesDescription.getAspect(string));
            }
            if ((MouseEventLayerDelegate.EVENTS.contains(string) || KeyboardEventLayerDelegate.EVENTS.contains(string)) && (unitConstantExpression = this.caseUnitName(string)) != null) {
                iDescription.warning("The usage of the event name (" + string + ") is now deprecated and should be replaced either by a string ('" + string + "') or a constant (#" + string + ")", "gaml.unknown.var.issue", eObject, new String[]{string});
                return unitConstantExpression;
            }
            this.getContext().error(string + " is not defined or accessible in this context. Check its name or declare it", "gaml.unknown.var.issue", eObject, new String[]{string});
        }
        return null;
    }

    private IExpression returnSelfOrSuper(String string, EObject eObject, boolean bl) {
        SpeciesDescription speciesDescription = this.getContext().getSpeciesContext();
        if (speciesDescription == null) {
            this.getContext().error("Unable to determine the species of " + string, "gaml.general.issue", eObject, new String[0]);
            return null;
        }
        IType iType = bl ? speciesDescription.getParent().getGamlType() : speciesDescription.getGamlType();
        return this.getFactory().createVar(string, iType, true, bl ? 5 : 4, null);
    }

    private EObject getEObjectOf(String string, IExecutionContext iExecutionContext) throws GamaRuntimeException {
        Expression expression = null;
        String string2 = "dummy <- " + string;
        GamlResource gamlResource = GamlResourceServices.getTemporaryResource(this.getContext());
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
            try {
                gamlResource.loadSynthetic(byteArrayInputStream, iExecutionContext);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                GamlResourceServices.discardTemporaryResource(gamlResource);
                return null;
            }
            if (gamlResource.hasErrors()) {
                Resource.Diagnostic diagnostic = (Resource.Diagnostic)gamlResource.getErrors().get(0);
                throw GamaRuntimeException.error((String)diagnostic.getMessage(), (IScope)iExecutionContext.getScope());
            }
            EObject eObject = (EObject)gamlResource.getContents().get(0);
            if (eObject instanceof StringEvaluator) {
                expression = ((StringEvaluator)eObject).getExpr();
            }
            Expression expression2 = expression;
            return expression2;
        }
        finally {
            GamlResourceServices.discardTemporaryResource(gamlResource);
        }
    }

    /*
     * Exception decompiling
     */
    public List<IDescription> compileBlock(String var1_1, IDescription var2_2, IExecutionContext var3_3) throws GamaRuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IVarExpression getEachExpr(EObject eObject) {
        IVarExpression iVarExpression = this.iteratorContexts.peek();
        if (iVarExpression == null) {
            this.getContext().error("'each' is not accessible in this context", "gaml.unknown.var.issue", eObject, new String[0]);
            return null;
        }
        return iVarExpression;
    }

    private IExpressionDescription getCurrentExpressionDescription() {
        return this.currentExpressionDescription;
    }

    private void setCurrentExpressionDescription(IExpressionDescription iExpressionDescription) {
        this.currentExpressionDescription = iExpressionDescription;
    }

    private IExpressionFactory getFactory() {
        return GAML.getExpressionFactory();
    }

    public void dispose() {
        this.currentContext = null;
        this.currentTypesManager = null;
        this.currentExpressionDescription = null;
        this.iteratorContexts.clear();
    }

    private static /* synthetic */ void lambda$5(IDescription iDescription, Collector.AsList asList, ISyntacticElement iSyntacticElement) {
        IDescription iDescription2 = DescriptionFactory.create((ISyntacticElement)iSyntacticElement, (IDescription)iDescription, null);
        asList.add((Object)iDescription2);
    }
}

