/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.indexer;

import com.google.common.collect.Maps;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.URI;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.Graphs;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.EdgeSetFactory;
import org.jgrapht.graph.FastLookupGraphSpecificsStrategy;
import org.jgrapht.graph.GraphSpecificsStrategy;

public class GamlResourceGraph {
    Imports imports = new Imports();

    static {
        DEBUG.ON();
    }

    void reset() {
        this.imports = new Imports();
    }

    public Set<URI> predecessorsOf(URI uRI) {
        if (!this.imports.containsVertex(uRI)) {
            return Collections.EMPTY_SET;
        }
        Set set = this.imports.incomingEdgesOf(uRI);
        if (set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<URI> hashSet = new HashSet<URI>();
        for (LabeledEdge labeledEdge : set) {
            hashSet.add((URI)Graphs.getOppositeVertex((Graph)this.imports, (Object)labeledEdge, (Object)uRI));
        }
        return hashSet;
    }

    public Set<URI> successorsOf(URI uRI) {
        if (!this.imports.containsVertex(uRI)) {
            return Collections.EMPTY_SET;
        }
        Set set = this.imports.outgoingEdgesOf(uRI);
        if (set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<URI> hashSet = new HashSet<URI>();
        for (LabeledEdge labeledEdge : set) {
            hashSet.add((URI)Graphs.getOppositeVertex((Graph)this.imports, (Object)labeledEdge, (Object)uRI));
        }
        return hashSet;
    }

    public void addEdge(URI uRI, URI uRI2, String string) {
        this.imports.addEdge(uRI, uRI2, new LabeledEdge(string, uRI2));
    }

    public void removeAllEdges(URI uRI, Map<URI, String> map) {
        if (map.isEmpty()) {
            return;
        }
        map.forEach((uRI2, string) -> this.imports.removeEdge(uRI, uRI2));
    }

    public Map<URI, String> outgoingEdgesOf(URI uRI) {
        if (!this.imports.containsVertex(uRI)) {
            return Collections.EMPTY_MAP;
        }
        Set set = this.imports.outgoingEdgesOf(uRI);
        if (set.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        IMap iMap = GamaMapFactory.createOrdered();
        for (LabeledEdge labeledEdge : set) {
            iMap.put(labeledEdge.target, labeledEdge.label);
        }
        return iMap;
    }

    public Map<URI, String> sortedDepthFirstSearchWithLabels(URI uRI) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        this.searchImports(uRI, null, linkedHashMap);
        linkedHashMap.remove(uRI);
        return linkedHashMap;
    }

    private void searchImports(URI uRI, String string, LinkedHashMap<URI, String> linkedHashMap) {
        if (!linkedHashMap.containsKey(uRI)) {
            linkedHashMap.put(uRI, string);
            if (this.imports.containsVertex(uRI)) {
                for (LabeledEdge labeledEdge : this.imports.outgoingEdgesOf(uRI)) {
                    this.searchImports(labeledEdge.target, labeledEdge.label == null ? string : labeledEdge.label, linkedHashMap);
                }
            }
        } else {
            linkedHashMap.remove(uRI);
            linkedHashMap.put(uRI, string);
        }
    }

    class Imports
    extends AbstractBaseGraph<URI, LabeledEdge> {
        public Imports() {
            super(null, null, (GraphType)new DefaultGraphType.Builder().directed().allowMultipleEdges(false).allowSelfLoops(false).weighted(false).allowCycles(true).build(), (GraphSpecificsStrategy)new FastLookupGraphSpecificsStrategy<URI, LabeledEdge>(){

                public EdgeSetFactory<URI, LabeledEdge> getEdgeSetFactory() {
                    return uRI -> Collections.newSetFromMap(new ConcurrentHashMap());
                }
            });
        }

        public boolean addEdge(URI uRI, URI uRI2, LabeledEdge labeledEdge) {
            this.addVertex(uRI);
            this.addVertex(uRI2);
            this.removeEdge(uRI, uRI2);
            return super.addEdge((Object)uRI, (Object)uRI2, (Object)labeledEdge);
        }
    }

    class LabeledEdge
    implements Comparable<LabeledEdge> {
        String label;
        final URI target;

        LabeledEdge(String string, URI uRI) {
            this.label = string;
            this.target = uRI;
        }

        @Override
        public int compareTo(LabeledEdge labeledEdge) {
            return this.target.toString().compareTo(labeledEdge.target.toString());
        }
    }
}

