/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.indexer;

import com.google.inject.Singleton;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gaml.compiler.gaml.ExperimentFileStructure;
import gaml.compiler.gaml.Import;
import gaml.compiler.gaml.Model;
import gaml.compiler.gaml.impl.ModelImpl;
import gaml.compiler.gaml.indexer.GamlResourceGraph;
import gaml.compiler.gaml.resource.GamlResource;
import gaml.compiler.gaml.resource.GamlResourceServices;
import gaml.compiler.gaml.resource.ImportedResources;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;

@Singleton
public class GamlResourceIndexer {
    static GamlResourceGraph index = new GamlResourceGraph();
    protected static final IMap EMPTY_MAP;
    public static final Object IMPORTED_URIS;

    static {
        DEBUG.ON();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        iWorkspace.addResourceChangeListener(iResourceChangeEvent -> {
            if (iResourceChangeEvent.getBuildKind() == 15) {
                GamlResourceIndexer.eraseIndex();
            }
        }, 8);
        EMPTY_MAP = GamaMapFactory.create();
        IMPORTED_URIS = "ImportedURIs";
    }

    private static Map<URI, String> getImportsAsAbsoluteURIS(URI uRI, EObject eObject) {
        ExperimentFileStructure experimentFileStructure;
        String string;
        ModelImpl modelImpl;
        Object object = EMPTY_MAP;
        if (eObject instanceof ModelImpl && (modelImpl = (ModelImpl)eObject).eIsSet(2)) {
            EList<Import> eList = modelImpl.getImports();
            if (eList.isEmpty()) {
                return object;
            }
            object = GamaMapFactory.createOrdered();
            for (Import import_ : eList) {
                String string2 = import_.getImportURI();
                if (string2 == null) continue;
                URI uRI2 = URI.createURI((String)string2, (boolean)true);
                try {
                    uRI2 = uRI2.resolve(uRI);
                }
                catch (Exception exception) {
                    DEBUG.LOG((Object)("Error in resolving " + String.valueOf(uRI2) + " against base " + String.valueOf(uRI)));
                }
                uRI2 = GamlResourceServices.properlyEncodedURI(uRI2);
                object.put(uRI2, import_.getName());
            }
        } else if (eObject instanceof ExperimentFileStructure && (string = (experimentFileStructure = (ExperimentFileStructure)eObject).getExp().getImportURI()) != null) {
            URI uRI3 = URI.createURI((String)string, (boolean)true);
            uRI3 = GamlResourceServices.properlyEncodedURI(uRI3.resolve(uRI));
            object = Collections.singletonMap(uRI3, null);
        }
        return object;
    }

    private static EObject findImport(EObject eObject, URI uRI, URI uRI2) {
        if (eObject instanceof ExperimentFileStructure) {
            ExperimentFileStructure experimentFileStructure = (ExperimentFileStructure)eObject;
            String string = experimentFileStructure.getExp().getImportURI();
            String string2 = URI.decode((String)uRI2.lastSegment());
            if (string2 != null && string.contains(string2) || uRI2.equals(uRI) && string.isEmpty()) {
                return eObject;
            }
        } else if (eObject instanceof Model) {
            Model model = (Model)eObject;
            for (Import import_ : model.getImports()) {
                if (!import_.getImportURI().contains(URI.decode((String)uRI2.lastSegment()))) continue;
                return import_;
            }
        }
        return null;
    }

    public static synchronized EObject updateImports(GamlResource gamlResource) {
        URI uRI = gamlResource.getURI();
        Map<URI, String> map = index.outgoingEdgesOf(uRI);
        if (gamlResource.getContents().isEmpty()) {
            return null;
        }
        EObject eObject = (EObject)gamlResource.getContents().get(0);
        if (eObject == null) {
            return null;
        }
        Map<URI, String> map2 = GamlResourceIndexer.getImportsAsAbsoluteURIS(uRI, eObject);
        for (Map.Entry<URI, String> entry : map2.entrySet()) {
            URI uRI2 = entry.getKey();
            if (uRI.equals(uRI2)) continue;
            String string = entry.getValue();
            if (!map.containsKey(uRI2)) {
                if (!EcoreUtil2.isValidUri((Resource)gamlResource, (URI)uRI2)) {
                    return GamlResourceIndexer.findImport(eObject, uRI, uRI2);
                }
                boolean bl = GamlResourceIndexer.index.imports.containsVertex(uRI2);
                URI uRI3 = uRI2;
                String string2 = string;
                index.addEdge(uRI, uRI3, string2);
                if (bl) continue;
                gamlResource.getResourceSet().getResource(uRI2, true);
                continue;
            }
            index.addEdge(uRI, uRI2, map.remove(uRI2));
        }
        index.removeAllEdges(uRI, map);
        return null;
    }

    public static ImportedResources validateImportsOf(GamlResource gamlResource) {
        Map<URI, String> map = GamlResourceIndexer.allImportsOf(gamlResource);
        ImportedResources importedResources = null;
        if (!map.isEmpty()) {
            importedResources = new ImportedResources();
            for (Map.Entry<URI, String> entry : map.entrySet()) {
                GamlResource gamlResource2 = (GamlResource)gamlResource.getResourceSet().getResource(entry.getKey(), true);
                if (gamlResource2 == gamlResource) continue;
                if (gamlResource2.hasErrors()) {
                    gamlResource.invalidate(gamlResource2, "Errors detected");
                    return null;
                }
                importedResources.add(entry.getValue(), gamlResource2);
            }
        }
        return importedResources;
    }

    public static Map<URI, String> allImportsOf(GamlResource gamlResource) {
        return (Map)gamlResource.getCache().get(IMPORTED_URIS, (Resource)gamlResource, () -> GamlResourceIndexer.allImportsOfProperlyEncoded(gamlResource.getURI()));
    }

    public static void eraseIndex() {
        index.reset();
    }

    public static boolean isImported(GamlResource gamlResource) {
        return !GamlResourceIndexer.directImportersOf(gamlResource.getURI()).isEmpty();
    }

    public static Set<URI> directImportersOf(URI uRI) {
        return index.predecessorsOf(uRI);
    }

    public static Set<URI> directImportsOf(URI uRI) {
        return index.successorsOf(uRI);
    }

    public static Map<URI, String> allImportsOf(URI uRI) {
        return GamlResourceIndexer.allImportsOfProperlyEncoded(GamlResourceServices.properlyEncodedURI(uRI));
    }

    public static Map<URI, String> allImportsOfProperlyEncoded(URI uRI) {
        return index.sortedDepthFirstSearchWithLabels(uRI);
    }
}

