/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.linking;

import gaml.compiler.gaml.ActionRef;
import gaml.compiler.gaml.EquationRef;
import gaml.compiler.gaml.SkillRef;
import gaml.compiler.gaml.TypeRef;
import gaml.compiler.gaml.VariableRef;
import gaml.compiler.gaml.util.GamlSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticMessageProvider;

public class GamlLinkingErrorMessageProvider
extends LinkingDiagnosticMessageProvider {
    public DiagnosticMessage getUnresolvedProxyMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext iLinkingDiagnosticContext) {
        EObject eObject = iLinkingDiagnosticContext.getContext();
        String string = (String)new GamlSwitch<String>(){

            @Override
            public String caseVariableRef(VariableRef variableRef) {
                return "variable or species";
            }

            @Override
            public String caseTypeRef(TypeRef typeRef) {
                return "type";
            }

            @Override
            public String caseActionRef(ActionRef actionRef) {
                return "primitive or action";
            }

            @Override
            public String caseEquationRef(EquationRef equationRef) {
                return "equation";
            }

            @Override
            public String caseSkillRef(SkillRef skillRef) {
                return "skill";
            }

            @Override
            public String defaultCase(EObject eObject) {
                return "element";
            }
        }.doSwitch(eObject);
        String string2 = "";
        try {
            string2 = iLinkingDiagnosticContext.getLinkText();
        }
        catch (IllegalNodeException illegalNodeException) {
            string2 = illegalNodeException.getNode().getText();
        }
        String string3 = "The " + string + " '" + string2 + "' cannot be resolved (either it is not defined or not accessible)";
        return new DiagnosticMessage(string3, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    public DiagnosticMessage getIllegalNodeMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext iLinkingDiagnosticContext, IllegalNodeException illegalNodeException) {
        String string = illegalNodeException.getMessage();
        return new DiagnosticMessage(string, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    public DiagnosticMessage getIllegalCrossReferenceMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext iLinkingDiagnosticContext, CrossReference crossReference) {
        String string = "Cannot find reference " + String.valueOf(crossReference);
        return new DiagnosticMessage(string, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    public DiagnosticMessage getViolatedBoundsConstraintMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext iLinkingDiagnosticContext, int n) {
        String string = "Too many matches for reference to '" + iLinkingDiagnosticContext.getLinkText() + "'. Feature " + iLinkingDiagnosticContext.getReference().getName() + " can only hold " + iLinkingDiagnosticContext.getReference().getUpperBound() + " reference" + (iLinkingDiagnosticContext.getReference().getUpperBound() != 1 ? "s" : "") + " but found " + n + " candidate" + (n != 1 ? "s" : "");
        return new DiagnosticMessage(string, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    public DiagnosticMessage getViolatedUniqueConstraintMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext iLinkingDiagnosticContext) {
        String string = "Cannot refer to '" + iLinkingDiagnosticContext.getLinkText() + "' more than once.";
        return new DiagnosticMessage(string, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }
}

