/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.parsing;

import gama.annotations.precompiler.ISymbolKind;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.compilation.ast.SyntacticFactory;
import gama.gaml.compilation.ast.SyntacticModelElement;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.LabelExpressionDescription;
import gama.gaml.descriptions.OperatorExpressionDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.statements.Facets;
import gaml.compiler.gaml.Access;
import gaml.compiler.gaml.ActionArguments;
import gaml.compiler.gaml.ArgumentDefinition;
import gaml.compiler.gaml.Block;
import gaml.compiler.gaml.EGaml;
import gaml.compiler.gaml.ExperimentFileStructure;
import gaml.compiler.gaml.Expression;
import gaml.compiler.gaml.ExpressionList;
import gaml.compiler.gaml.Facet;
import gaml.compiler.gaml.Function;
import gaml.compiler.gaml.HeadlessExperiment;
import gaml.compiler.gaml.Model;
import gaml.compiler.gaml.Pragma;
import gaml.compiler.gaml.S_Action;
import gaml.compiler.gaml.S_Assignment;
import gaml.compiler.gaml.S_Definition;
import gaml.compiler.gaml.S_Do;
import gaml.compiler.gaml.S_Equations;
import gaml.compiler.gaml.S_Experiment;
import gaml.compiler.gaml.S_If;
import gaml.compiler.gaml.S_Reflex;
import gaml.compiler.gaml.S_Solve;
import gaml.compiler.gaml.S_Try;
import gaml.compiler.gaml.StandaloneBlock;
import gaml.compiler.gaml.Statement;
import gaml.compiler.gaml.TypeRef;
import gaml.compiler.gaml.VariableRef;
import gaml.compiler.gaml.expression.ExpressionDescriptionBuilder;
import gaml.compiler.gaml.impl.ModelImpl;
import gaml.compiler.gaml.resource.GamlResourceServices;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Diagnostic;

public class GamlSyntacticConverter {
    static final ExpressionDescriptionBuilder builder;
    private static int SYNTHETIC_ACTION;

    static {
        DEBUG.ON();
        builder = new ExpressionDescriptionBuilder();
        SYNTHETIC_ACTION = 0;
    }

    public static String getAbsoluteContainerFolderPathOf(Resource resource) {
        URI uRI = resource.getURI();
        if (uRI.isFile()) {
            uRI = uRI.trimSegments(1);
            return uRI.toFileString();
        }
        if (uRI.isPlatform()) {
            IPath iPath = GamlResourceServices.getPathOf(resource);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
            IContainer iContainer = iFile.getParent();
            return iContainer.getLocation().toString();
        }
        return URI.decode((String)uRI.toString());
    }

    public ISyntacticElement buildSyntacticContents(EObject eObject, Set<Diagnostic> set) {
        if (eObject instanceof StandaloneBlock) {
            SyntacticModelElement syntacticModelElement = SyntacticFactory.createSyntheticModel((EObject)eObject);
            this.convertBlock((ISyntacticElement)syntacticModelElement, ((StandaloneBlock)eObject).getBlock(), set);
            return syntacticModelElement;
        }
        if (eObject instanceof ExperimentFileStructure) {
            HeadlessExperiment headlessExperiment = ((ExperimentFileStructure)eObject).getExp();
            String string = GamlSyntacticConverter.getAbsoluteContainerFolderPathOf(eObject.eResource());
            SyntacticModelElement.SyntacticExperimentModelElement syntacticExperimentModelElement = SyntacticFactory.createExperimentModel((EObject)eObject, (EObject)headlessExperiment, (String)string);
            this.convertFacets(headlessExperiment, (ISyntacticElement)syntacticExperimentModelElement.getExperiment(), set);
            syntacticExperimentModelElement.setFacet("name", LabelExpressionDescription.create((String)syntacticExperimentModelElement.getExperiment().getName()));
            this.convStatements((ISyntacticElement)syntacticExperimentModelElement.getExperiment(), EGaml.getInstance().getStatementsOf(headlessExperiment.getBlock()), set);
            return syntacticExperimentModelElement;
        }
        if (!(eObject instanceof Model)) {
            return null;
        }
        ModelImpl modelImpl = (ModelImpl)eObject;
        String string = GamlSyntacticConverter.getAbsoluteContainerFolderPathOf(eObject.eResource());
        SyntacticModelElement syntacticModelElement = (SyntacticModelElement)SyntacticFactory.create((String)"model", (EObject)modelImpl, (boolean)EGaml.getInstance().hasChildren(modelImpl), (Object[])new Object[]{string});
        Map<String, List<String>> map = this.collectPragmas(modelImpl);
        if (map != null) {
            syntacticModelElement.setFacet("pragma", (IExpressionDescription)ConstantExpressionDescription.create(map));
        }
        syntacticModelElement.setFacet("name", this.convertToLabel(null, modelImpl.getName()));
        this.convStatements((ISyntacticElement)syntacticModelElement, EGaml.getInstance().getStatementsOf(modelImpl), set);
        syntacticModelElement.compactModel();
        return syntacticModelElement;
    }

    private Map<String, List<String>> collectPragmas(ModelImpl modelImpl) {
        if (!modelImpl.eIsSet(1)) {
            return null;
        }
        EList<Pragma> eList = modelImpl.getPragmas();
        if (eList.isEmpty()) {
            return null;
        }
        IMap iMap = GamaMapFactory.create();
        for (Pragma pragma : eList) {
            ExpressionList expressionList = pragma.getPlugins();
            if (expressionList != null) {
                IList iList = GamaListFactory.create();
                for (Expression expression : expressionList.getExprs()) {
                    iList.add(EGaml.getInstance().toString(expression));
                }
                iMap.put(pragma.getName(), iList);
                continue;
            }
            iMap.put(pragma.getName(), null);
        }
        return iMap;
    }

    private boolean doesNotDefineAttributes(String string) {
        SymbolProto symbolProto = DescriptionFactory.getProto((String)string, null);
        if (symbolProto == null) {
            return true;
        }
        int n = symbolProto.getKind();
        return !ISymbolKind.STATEMENTS_CONTAINING_ATTRIBUTES.contains(n);
    }

    /*
     * Unable to fully structure code
     */
    private final ISyntacticElement convStatement(ISyntacticElement var1_1, Statement var2_2, Set<Diagnostic> var3_3) {
        block29: {
            block28: {
                var4_4 = EGaml.getInstance().getKeyOf(var2_2);
                if (var4_4 == null) {
                    throw new NullPointerException("Trying to convert a statement with a null keyword. Please debug to understand the cause.");
                }
                var4_4 = this.convertKeyword(var4_4, var1_1.getKeyword());
                var5_5 = this.doesNotDefineAttributes(var1_1.getKeyword()) == false;
                var6_6 = var2_2 instanceof S_Definition != false && DescriptionFactory.isStatementProto((String)var4_4) == false && var5_5 != false && EGaml.getInstance().hasChildren(var2_2) == false;
                v0 = var7_7 = var6_6 != false ? SyntacticFactory.createVar((String)var4_4, (String)((S_Definition)var2_2).getName(), (EObject)var2_2) : SyntacticFactory.create((String)var4_4, (EObject)var2_2, (boolean)EGaml.getInstance().hasChildren(var2_2), (Object[])new Object[0]);
                if (!(var2_2 instanceof S_Assignment)) break block28;
                var4_4 = this.convertAssignment((S_Assignment)var2_2, var4_4, var7_7, var2_2.getExpr(), var3_3);
                break block29;
            }
            if (!(var2_2 instanceof S_Definition)) ** GOTO lbl-1000
            var8_8 = (S_Definition)var2_2;
            if (!DescriptionFactory.isStatementProto((String)var4_4)) {
                var9_9 = (TypeRef)var8_8.getTkey();
                if (var9_9 != null) {
                    this.addFacet(var7_7, "type", this.convExpr(var9_9, var3_3), var3_3);
                }
                if (var9_9 != null && !var5_5) {
                    var7_7.setKeyword("let");
                    var4_4 = "let";
                } else {
                    if (EGaml.getInstance().hasChildren(var8_8)) {
                        var7_7.setKeyword("action");
                        var4_4 = "action";
                    }
                    this.convertArgs(var8_8.getArgs(), var7_7, var3_3);
                }
            } else if (var2_2 instanceof S_Do) {
                this.processDo(var2_2, var3_3, var7_7);
            } else if (var2_2 instanceof S_If) {
                this.convElse((S_If)var2_2, var7_7, var3_3);
            } else if (var2_2 instanceof S_Action) {
                this.convertArgs(((S_Action)var2_2).getArgs(), var7_7, var3_3);
            } else if (var2_2 instanceof S_Reflex) {
                var9_10 = (S_Reflex)var2_2;
                if (var9_10.getExpr() != null) {
                    this.addFacet(var7_7, "when", this.convExpr(var9_10.getExpr(), var3_3), var3_3);
                }
            } else if (var2_2 instanceof S_Solve) {
                var10_11 = var2_2.getExpr();
                this.addFacet(var7_7, "equation", this.convertToLabel((EObject)var10_11, EGaml.getInstance().getKeyOf((EObject)var10_11)), var3_3);
            } else if (var2_2 instanceof S_Try) {
                this.convCatch((S_Try)var2_2, var7_7, var3_3);
            } else if ("parameter".equals(var4_4)) {
                this.processParameter(var2_2, var3_3, var7_7);
            }
        }
        this.convertFacets(var2_2, var4_4, var7_7, var3_3);
        if (var2_2 instanceof S_Experiment) {
            this.processExperiment(var7_7);
        } else if ("method".equals(var4_4)) {
            var10_11 = var7_7.getName();
            if (var10_11 != null) {
                var7_7.setKeyword((String)var10_11);
            }
        } else if (var2_2 instanceof S_Equations) {
            this.convStatements(var7_7, EGaml.getInstance().getEquationsOf(var2_2), var3_3);
        }
        if (!"parameter".equals(var4_4)) {
            this.convertBlock(var7_7, var2_2.getBlock(), var3_3);
        }
        return var7_7;
    }

    private void processExperiment(ISyntacticElement iSyntacticElement) {
        IExpressionDescription iExpressionDescription = iSyntacticElement.getExpressionAt("type");
        if (iExpressionDescription == null) {
            iSyntacticElement.setFacet("type", (IExpressionDescription)ConstantExpressionDescription.create((Object)"gui"));
        }
        String string = iSyntacticElement.getName();
        iSyntacticElement.setFacet("title", this.convertToLabel(null, "Experiment " + string));
        iSyntacticElement.setFacet("name", this.convertToLabel(null, string));
    }

    private void processParameter(Statement statement, Set<Diagnostic> set, ISyntacticElement iSyntacticElement) {
        Block block = statement.getBlock();
        if (block != null) {
            ISyntacticElement iSyntacticElement2 = SyntacticFactory.create((String)"action", (Facets)new Facets(new String[]{"name", "__synthetic__" + SYNTHETIC_ACTION++}), (boolean)true, (Object[])new Object[0]);
            this.convertBlock(iSyntacticElement2, block, set);
            IExpressionDescription iExpressionDescription = this.createBlockExpr(iSyntacticElement2);
            this.addFacet(iSyntacticElement, "on_change", iExpressionDescription, set);
        }
    }

    private void processDo(Statement statement, Set<Diagnostic> set, ISyntacticElement iSyntacticElement) {
        Function function;
        ExpressionList expressionList;
        Expression expression = statement.getExpr();
        this.addFacet(iSyntacticElement, "action", this.convertToLabel(expression, EGaml.getInstance().getKeyOf(expression)), set);
        this.addFacet(iSyntacticElement, "internal_function", this.convExpr(expression, set), set);
        if (expression instanceof Function && (expressionList = (function = (Function)expression).getRight()) != null) {
            this.addFacet(iSyntacticElement, "with", this.convExpr(expressionList, set), set);
        }
    }

    public void convertBlock(ISyntacticElement iSyntacticElement, Block block, Set<Diagnostic> set) {
        if (block != null) {
            this.convStatements(iSyntacticElement, EGaml.getInstance().getStatementsOf(block), set);
        }
    }

    private void addFacet(ISyntacticElement iSyntacticElement, String string, IExpressionDescription iExpressionDescription, Set<Diagnostic> set) {
        if (iSyntacticElement.hasFacet(string)) {
            iSyntacticElement.setFacet("***DOUBLED***" + string, iExpressionDescription);
        } else {
            iSyntacticElement.setFacet(string, iExpressionDescription);
        }
    }

    private void convElse(S_If s_If, ISyntacticElement iSyntacticElement, Set<Diagnostic> set) {
        EObject eObject = s_If.getElse();
        if (eObject != null) {
            ISyntacticElement iSyntacticElement2 = SyntacticFactory.create((String)"else", (EObject)eObject, (boolean)EGaml.getInstance().hasChildren(eObject), (Object[])new Object[0]);
            if (eObject instanceof Statement) {
                iSyntacticElement2.addChild(this.convStatement(iSyntacticElement, (Statement)eObject, set));
            } else {
                this.convStatements(iSyntacticElement2, EGaml.getInstance().getStatementsOf(eObject), set);
            }
            iSyntacticElement.addChild(iSyntacticElement2);
        }
    }

    private void convCatch(S_Try s_Try, ISyntacticElement iSyntacticElement, Set<Diagnostic> set) {
        Block block = s_Try.getCatch();
        if (block != null) {
            ISyntacticElement iSyntacticElement2 = SyntacticFactory.create((String)"catch", (EObject)block, (boolean)EGaml.getInstance().hasChildren(block), (Object[])new Object[0]);
            this.convStatements(iSyntacticElement2, EGaml.getInstance().getStatementsOf(block), set);
            iSyntacticElement.addChild(iSyntacticElement2);
        }
    }

    private void convertArgs(ActionArguments actionArguments, ISyntacticElement iSyntacticElement, Set<Diagnostic> set) {
        if (actionArguments != null) {
            for (ArgumentDefinition argumentDefinition : EGaml.getInstance().getArgsOf(actionArguments)) {
                ISyntacticElement iSyntacticElement2 = SyntacticFactory.create((String)"arg", (EObject)argumentDefinition, (boolean)false, (Object[])new Object[0]);
                this.addFacet(iSyntacticElement2, "name", this.convertToLabel(null, argumentDefinition.getName()), set);
                Expression expression = argumentDefinition.getType();
                this.addFacet(iSyntacticElement2, "type", this.convExpr(expression, set), set);
                Expression expression2 = argumentDefinition.getDefault();
                if (expression2 != null) {
                    this.addFacet(iSyntacticElement2, "default", this.convExpr(expression2, set), set);
                }
                iSyntacticElement.addChild(iSyntacticElement2);
            }
        }
    }

    private String convertAssignment(S_Assignment s_Assignment, String string, ISyntacticElement iSyntacticElement, Expression expression, Set<Diagnostic> set) {
        IExpressionDescription iExpressionDescription = this.convExpr(s_Assignment.getValue(), set);
        String string2 = string;
        if (string2.endsWith("<-") || "set".equals(string2)) {
            string2 = this.processBasicAssignment(iSyntacticElement, expression, set, iExpressionDescription, string2);
        } else if (string2.startsWith("<<") || "<+".equals(string2)) {
            string2 = this.processAdditiveAssignment(iSyntacticElement, expression, set, iExpressionDescription, string2);
        } else if (string2.startsWith(">>") || ">-".equals(string2)) {
            string2 = this.processRemovalAssignment(iSyntacticElement, expression, set, iExpressionDescription, string2);
        } else if ("=".equals(string2)) {
            this.processEquationAssignment(iSyntacticElement, expression, set, iExpressionDescription);
        }
        return string2;
    }

    private void processEquationAssignment(ISyntacticElement iSyntacticElement, Expression expression, Set<Diagnostic> set, IExpressionDescription iExpressionDescription) {
        Object object = null;
        object = expression instanceof VariableRef ? new OperatorExpressionDescription("internal_zero_order_equation", new IExpressionDescription[]{this.convExpr(expression, set)}) : this.convExpr(expression, set);
        this.addFacet(iSyntacticElement, "left", (IExpressionDescription)object, set);
        this.addFacet(iSyntacticElement, "right", iExpressionDescription, set);
    }

    private String processRemovalAssignment(ISyntacticElement iSyntacticElement, Expression expression, Set<Diagnostic> set, IExpressionDescription iExpressionDescription, String string) {
        iSyntacticElement.setKeyword("remove");
        if (expression instanceof Access && "[".equals(((Access)expression).getOp()) && EGaml.getInstance().getExprsOf(((Access)expression).getRight()).size() == 0) {
            this.addFacet(iSyntacticElement, "from", this.convExpr(((Access)expression).getLeft(), set), set);
            this.addFacet(iSyntacticElement, "index", iExpressionDescription, set);
        } else {
            this.addFacet(iSyntacticElement, "from", this.convExpr(expression, set), set);
            this.addFacet(iSyntacticElement, "item", iExpressionDescription, set);
        }
        if (">>-".equals(string)) {
            this.addFacet(iSyntacticElement, "all", (IExpressionDescription)ConstantExpressionDescription.create((Boolean)true), set);
        }
        return "remove";
    }

    private String processAdditiveAssignment(ISyntacticElement iSyntacticElement, Expression expression, Set<Diagnostic> set, IExpressionDescription iExpressionDescription, String string) {
        iSyntacticElement.setKeyword("add");
        this.addFacet(iSyntacticElement, "to", this.convExpr(expression, set), set);
        this.addFacet(iSyntacticElement, "item", iExpressionDescription, set);
        if ("<<+".equals(string)) {
            this.addFacet(iSyntacticElement, "all", (IExpressionDescription)ConstantExpressionDescription.create((Boolean)true), set);
        }
        return "add";
    }

    private String processBasicAssignment(ISyntacticElement iSyntacticElement, Expression expression, Set<Diagnostic> set, IExpressionDescription iExpressionDescription, String string) {
        if (expression instanceof Access && "[".equals(((Access)expression).getOp())) {
            String string2 = "+<-".equals(string) ? "add" : "put";
            String string3 = "+<-".equals(string) ? "to" : "in";
            iSyntacticElement.setKeyword(string2);
            this.addFacet(iSyntacticElement, "item", iExpressionDescription, set);
            this.addFacet(iSyntacticElement, string3, this.convExpr(((Access)expression).getLeft(), set), set);
            List<Expression> list = EGaml.getInstance().getExprsOf(((Access)expression).getRight());
            if (list.size() == 0) {
                this.addFacet(iSyntacticElement, "all", (IExpressionDescription)ConstantExpressionDescription.create((Boolean)true), set);
            } else if (list.size() == 1) {
                this.addFacet(iSyntacticElement, "at", this.convExpr(list.get(0), set), set);
            } else {
                OperatorExpressionDescription operatorExpressionDescription = new OperatorExpressionDescription("internal_list", new IExpressionDescription[]{this.convExpr(list.get(0), set), this.convExpr(list.get(1), set)});
                this.addFacet(iSyntacticElement, "at", (IExpressionDescription)operatorExpressionDescription, set);
            }
            string = string2;
        } else {
            iSyntacticElement.setKeyword("set");
            this.addFacet(iSyntacticElement, "value", iExpressionDescription, set);
            string = "set";
        }
        return string;
    }

    private void convertFacets(Statement statement, String string, ISyntacticElement iSyntacticElement, Set<Diagnostic> set) {
        Object object;
        SymbolProto symbolProto = DescriptionFactory.getProto((String)string, null);
        IExpressionDescription iExpressionDescription = EGaml.getInstance().getFacetsOf(statement).iterator();
        while (iExpressionDescription.hasNext()) {
            object = iExpressionDescription.next();
            String string2 = EGaml.getInstance().getKeyOf((EObject)object);
            if ("<-".equals(string2)) {
                string2 = "let".equals(string) || "set".equals(string) ? "value" : "init";
            } else if ("->".equals(string2)) {
                string2 = "function";
            }
            boolean bl = symbolProto == null ? false : symbolProto.isLabel(string2);
            IExpressionDescription iExpressionDescription2 = this.convExpr((Facet)object, bl, set);
            this.addFacet(iSyntacticElement, string2, iExpressionDescription2, set);
        }
        object = statement.getFirstFacet();
        if (object != null) {
            if (((String)object).endsWith(":")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
        } else {
            object = DescriptionFactory.getOmissibleFacetForSymbol((String)string);
        }
        if (object != null && !((String)object).isEmpty() && !iSyntacticElement.hasFacet((String)object) && (iExpressionDescription = this.findExpr(statement, set)) != null) {
            iSyntacticElement.setFacet((String)object, iExpressionDescription);
        }
    }

    private void convertFacets(HeadlessExperiment headlessExperiment, ISyntacticElement iSyntacticElement, Set<Diagnostic> set) {
        Facet facet2;
        SymbolProto symbolProto = DescriptionFactory.getProto((String)"experiment", null);
        for (Facet facet2 : EGaml.getInstance().getFacetsOf(headlessExperiment)) {
            String string = EGaml.getInstance().getKeyOf(facet2);
            boolean bl = symbolProto == null ? false : symbolProto.isLabel(string);
            IExpressionDescription iExpressionDescription = this.convExpr(facet2, bl, set);
            this.addFacet(iSyntacticElement, string, iExpressionDescription, set);
        }
        facet2 = this.findExpr(headlessExperiment, set);
        this.addFacet(iSyntacticElement, "name", (IExpressionDescription)facet2, set);
        this.addFacet(iSyntacticElement, "title", (IExpressionDescription)facet2, set);
    }

    private String convertKeyword(String string, String string2) {
        String string3 = string;
        if (("batch".equals(string2) || "experiment".equals(string2)) && "save".equals(string3)) {
            string3 = "save_batch";
        } else if ("display".equals(string2) || "species_layer".equals(string2)) {
            if ("species".equals(string3)) {
                string3 = "species_layer";
            } else if ("grid".equals(string3)) {
                string3 = "display_grid";
            } else if ("image".equals(string3)) {
                string3 = "image_layer";
            }
        }
        return string3;
    }

    private final IExpressionDescription convExpr(EObject eObject, Set<Diagnostic> set) {
        if (eObject == null) {
            return null;
        }
        return builder.create(eObject);
    }

    private final IExpressionDescription createBlockExpr(ISyntacticElement iSyntacticElement) {
        if (iSyntacticElement == null) {
            return null;
        }
        return builder.createBlock(iSyntacticElement);
    }

    private final IExpressionDescription convExpr(Facet facet, boolean bl, Set<Diagnostic> set) {
        if (facet != null) {
            Expression expression = facet.getExpr();
            if (expression == null && facet.getBlock() != null) {
                Block block = facet.getBlock();
                ISyntacticElement iSyntacticElement = SyntacticFactory.create((String)"action", (Facets)new Facets(new String[]{"name", "__synthetic__" + SYNTHETIC_ACTION++}), (boolean)true, (Object[])new Object[0]);
                this.convertBlock(iSyntacticElement, block, set);
                return this.createBlockExpr(iSyntacticElement);
            }
            if (expression != null) {
                return bl ? this.convertToLabel(expression, EGaml.getInstance().getKeyOf(expression)) : this.convExpr(expression, set);
            }
            String string = facet.getName();
            if (string != null) {
                return this.convertToLabel(null, string);
            }
        }
        return null;
    }

    final IExpressionDescription convertToLabel(EObject eObject, String string) {
        IExpressionDescription iExpressionDescription = LabelExpressionDescription.create((String)string);
        iExpressionDescription.setTarget(eObject);
        return iExpressionDescription;
    }

    final void convStatements(ISyntacticElement iSyntacticElement, List<? extends Statement> list, Set<Diagnostic> set) {
        for (Statement statement : list) {
            if ("global".equals(EGaml.getInstance().getKeyOf(statement))) {
                this.convStatements(iSyntacticElement, EGaml.getInstance().getStatementsOf(statement.getBlock()), set);
                this.convertFacets(statement, "global", iSyntacticElement, set);
                continue;
            }
            ISyntacticElement iSyntacticElement2 = this.convStatement(iSyntacticElement, statement, set);
            if (iSyntacticElement2 == null) continue;
            iSyntacticElement.addChild(iSyntacticElement2);
        }
    }

    private final IExpressionDescription findExpr(Statement statement, Set<Diagnostic> set) {
        if (statement == null) {
            return null;
        }
        String string = EGaml.getInstance().getNameOf(statement);
        if (string != null) {
            return this.convertToLabel(statement, string);
        }
        Expression expression = statement.getExpr();
        if (expression != null) {
            return this.convExpr(expression, set);
        }
        return null;
    }

    private final IExpressionDescription findExpr(HeadlessExperiment headlessExperiment, Set<Diagnostic> set) {
        if (headlessExperiment == null) {
            return null;
        }
        return this.convertToLabel(headlessExperiment, EGaml.getInstance().getNameOf(headlessExperiment));
    }
}

