/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.resource;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.kernel.model.IModel;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaFile;
import gama.core.util.file.GamlFileInfo;
import gama.gaml.compilation.GAML;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.File;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="experiments", type=5, of=4, doc={@GamlAnnotations.doc(value="Returns a list containing the names of the experiments defined in this file. An empty list is returned if it does not define any experiment")}), @GamlAnnotations.variable(name="tags", type=5, of=4, doc={@GamlAnnotations.doc(value="Returns a list containing the names of the tags defined in this file. An empty list is returned if it does not define any tag")}), @GamlAnnotations.variable(name="uses", type=5, of=4, doc={@GamlAnnotations.doc(value="Returns a list containing the names of the files 'used' (read or written) in this model")}), @GamlAnnotations.variable(name="valid", type=3, doc={@GamlAnnotations.doc(value="Returns true if this file is syntactically valid, false otherwise")}), @GamlAnnotations.variable(name="imports", type=5, of=4, doc={@GamlAnnotations.doc(value="Returns a list containing the names of the models imported by this file. An empty list is returned if it does not import any model")})})
@GamlAnnotations.file(name="gaml", extensions={"gaml", "experiment"}, buffer_type=5, buffer_content=14, buffer_index=1, concept={"file"}, doc={@GamlAnnotations.doc(value="Represents GAML model files")})
public class GamlFile
extends GamaFile<IList<IModel>, IModel> {
    private IModel model;
    private final String aliasName;

    @GamlAnnotations.doc(value="This file constructor allows to read a gaml file (.gaml)", examples={@GamlAnnotations.example(value="file f <- gaml_file(\"file.gaml\");", isExecutable=false)})
    public GamlFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
        this.aliasName = "";
    }

    public IContainerType getGamlType() {
        return Types.FILE.of((IType)Types.INT, (IType)Types.SPECIES);
    }

    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.EMPTY_LIST;
    }

    @GamlAnnotations.getter(value="experiments")
    public IList<String> getExperiments(IScope iScope) {
        File file2 = this.getFile(iScope);
        GamlFileInfo gamlFileInfo = GAML.getInfo((URI)URI.createFileURI((String)this.getFile(iScope).getAbsolutePath()), (long)file2.lastModified());
        if (gamlFileInfo != null) {
            return GamaListFactory.wrap((IType)Types.STRING, (Collection)gamlFileInfo.getExperiments());
        }
        return GamaListFactory.EMPTY_LIST;
    }

    @GamlAnnotations.getter(value="tags")
    public IList<String> getTags(IScope iScope) {
        File file2 = this.getFile(iScope);
        GamlFileInfo gamlFileInfo = GAML.getInfo((URI)URI.createFileURI((String)this.getFile(iScope).getAbsolutePath()), (long)file2.lastModified());
        if (gamlFileInfo != null) {
            return GamaListFactory.wrap((IType)Types.STRING, (Collection)gamlFileInfo.getTags());
        }
        return GamaListFactory.EMPTY_LIST;
    }

    @GamlAnnotations.getter(value="uses")
    public IList<String> getUses(IScope iScope) {
        File file2 = this.getFile(iScope);
        GamlFileInfo gamlFileInfo = GAML.getInfo((URI)URI.createFileURI((String)this.getFile(iScope).getAbsolutePath()), (long)file2.lastModified());
        if (gamlFileInfo != null) {
            return GamaListFactory.wrap((IType)Types.STRING, (Collection)gamlFileInfo.getUses());
        }
        return GamaListFactory.EMPTY_LIST;
    }

    @GamlAnnotations.getter(value="imports")
    public IList<String> getImports(IScope iScope) {
        File file2 = this.getFile(iScope);
        GamlFileInfo gamlFileInfo = GAML.getInfo((URI)URI.createFileURI((String)this.getFile(iScope).getAbsolutePath()), (long)file2.lastModified());
        if (gamlFileInfo != null) {
            return GamaListFactory.wrap((IType)Types.STRING, (Collection)gamlFileInfo.getImports());
        }
        return GamaListFactory.EMPTY_LIST;
    }

    @GamlAnnotations.getter(value="valid")
    public Boolean isValid(IScope iScope) {
        File file2 = this.getFile(iScope);
        GamlFileInfo gamlFileInfo = GAML.getInfo((URI)URI.createFileURI((String)this.getFile(iScope).getAbsolutePath()), (long)file2.lastModified());
        if (gamlFileInfo != null) {
            return gamlFileInfo.isValid();
        }
        return false;
    }

    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
    }

    public Envelope3D computeEnvelope(IScope iScope) {
        return null;
    }
}

