/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.resource;

import com.google.common.base.Function;
import gama.core.runtime.IExecutionContext;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.ValidationContext;
import gaml.compiler.gaml.indexer.GamlResourceIndexer;
import gaml.compiler.gaml.resource.GamlResourceServices;
import gaml.compiler.gaml.resource.ImportedResources;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.diagnostics.Diagnostic;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class GamlResource
extends LazyLinkingResource
implements IDiagnosticConsumer {
    ISyntacticElement element;
    static final Function<GamlResource, ISyntacticElement> TO_SYNTACTIC_CONTENTS;

    static {
        DEBUG.OFF();
        TO_SYNTACTIC_CONTENTS = gamlResource -> {
            gamlResource.getResourceSet().getResource(gamlResource.getURI(), true);
            return gamlResource.getSyntacticContents();
        };
    }

    public ValidationContext getValidationContext() {
        return GamlResourceServices.getOrCreateValidationContext(this);
    }

    public boolean hasSemanticErrors() {
        return this.getValidationContext().hasErrors();
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public String toString() {
        return "GamlResource[" + this.getURI().lastSegment() + "]";
    }

    public void updateWith(ModelDescription modelDescription, boolean bl) {
        GamlResourceServices.updateState(this.getURI(), modelDescription, bl, this.getValidationContext());
    }

    public ISyntacticElement getSyntacticContents() {
        if (this.element != null) {
            return this.element;
        }
        this.setElement(GamlResourceServices.buildSyntacticContents(this));
        return this.element;
    }

    private ModelDescription buildModelDescription(ImportedResources importedResources) {
        GAML.getExpressionFactory().resetParser();
        String string = GamlResourceServices.getModelPathOf((Resource)this);
        String string2 = GamlResourceServices.getProjectPathOf((Resource)this);
        ValidationContext validationContext = this.getValidationContext();
        validationContext.shouldDocument(GamlResourceServices.isEdited((Resource)this));
        if (importedResources == null) {
            return GAML.getModelFactory().createModelDescription(string2, string, Collections.singleton(this.getSyntacticContents()), validationContext, null);
        }
        Iterable<ISyntacticElement> iterable = importedResources.computeDirectImports(this.getSyntacticContents());
        return GAML.getModelFactory().createModelDescription(string2, string, iterable, validationContext, importedResources.computeMicroModels(string2, string, validationContext));
    }

    public void invalidate(GamlResource gamlResource, String string) {
        GamlCompilationError gamlCompilationError = null;
        gamlCompilationError = GamlResourceServices.equals(gamlResource.getURI(), this.getURI()) ? new GamlCompilationError(string, "gaml.general.issue", (EObject)gamlResource.getContents().get(0), GamlCompilationError.GamlCompilationErrorType.Error, new String[0]) : new GamlCompilationError(string, "gaml.general.issue", gamlResource.getURI(), GamlCompilationError.GamlCompilationErrorType.Error, new String[0]);
        this.getValidationContext().add(gamlCompilationError);
        this.updateWith(null, true);
    }

    public ModelDescription buildCompleteDescription() {
        ImportedResources importedResources = GamlResourceIndexer.validateImportsOf(this);
        if (this.hasErrors() || this.hasSemanticErrors()) {
            return null;
        }
        ModelDescription modelDescription = this.buildModelDescription(importedResources);
        if (modelDescription == null) {
            this.invalidate(this, "Impossible to validate " + URI.decode((String)this.getURI().lastSegment()) + " (check the logs)");
        }
        return modelDescription;
    }

    public void validate() {
        ModelDescription modelDescription = this.buildCompleteDescription();
        if (modelDescription == null) {
            this.updateWith(null, true);
            return;
        }
        try {
            this.updateWith(modelDescription.validate(), true);
        }
        catch (Throwable throwable) {
            if (GamlResourceServices.isEdited(this.getURI())) {
                GamlResourceServices.getResourceDocumenter().addDocumentationTask(this.getURI(), () -> modelDescription.dispose());
            } else {
                modelDescription.dispose();
            }
            throw throwable;
        }
        if (GamlResourceServices.isEdited(this.getURI())) {
            GamlResourceServices.getResourceDocumenter().addDocumentationTask(this.getURI(), () -> modelDescription.dispose());
        } else {
            modelDescription.dispose();
        }
    }

    protected void updateInternalState(IParseResult iParseResult, IParseResult iParseResult2) {
        if (iParseResult != iParseResult2) {
            super.updateInternalState(iParseResult, iParseResult2);
            this.setElement(null);
        }
    }

    protected void clearInternalState() {
        super.clearInternalState();
        this.setElement(null);
    }

    protected void doUnload() {
        super.doUnload();
        this.setElement(null);
    }

    private void setElement(ISyntacticElement iSyntacticElement) {
        if (iSyntacticElement == this.element) {
            return;
        }
        if (this.element != null) {
            this.element.dispose();
        }
        this.element = iSyntacticElement;
    }

    public void loadSynthetic(final InputStream inputStream, IExecutionContext iExecutionContext) {
        OnChangeEvictingCache onChangeEvictingCache = this.getCache();
        onChangeEvictingCache.getOrCreate((Resource)this).set((Object)"linking", (Object)iExecutionContext);
        this.getCache().execWithoutCacheClear((Resource)this, (IUnitOfWork)new IUnitOfWork.Void<GamlResource>(){

            public void process(GamlResource gamlResource) throws Exception {
                gamlResource.load(inputStream, null);
                EcoreUtil.resolveAll((Resource)GamlResource.this);
            }
        });
        onChangeEvictingCache.getOrCreate((Resource)this).set((Object)"linking", null);
    }

    public OnChangeEvictingCache getCache() {
        return (OnChangeEvictingCache)super.getCache();
    }

    protected void doLinking() {
        EObject eObject = GamlResourceIndexer.updateImports(this);
        if (eObject != null) {
            this.getErrors().add((Object)new XtextLinkingDiagnostic((INode)NodeModelUtils.getNode((EObject)eObject), "Impossible to locate import", "gaml.import.has.error", new String[]{""}));
            return;
        }
        EObject eObject2 = this.getParseResult().getRootASTElement();
        if (eObject2 != null) {
            this.getLinker().linkModel(eObject2, (IDiagnosticConsumer)this);
        }
    }

    public boolean hasErrors() {
        return !this.getErrors().isEmpty() || this.getParseResult().hasSyntaxErrors();
    }

    public void setURI(URI uRI) {
        super.setURI(GamlResourceServices.properlyEncodedURI(uRI));
    }

    public void clearCache() {
        GamlResourceServices.getResourceDocumenter().invalidate(this.getURI());
        super.clearCache();
    }

    public void consume(Diagnostic diagnostic, Severity severity) {
        if (this.isValidationDisabled()) {
            return;
        }
        switch (severity) {
            case ERROR: {
                this.getErrors().add((Object)diagnostic);
                break;
            }
            case WARNING: {
                this.getWarnings().add((Object)diagnostic);
            }
        }
    }

    public boolean hasConsumedDiagnostics(Severity severity) {
        return !this.getErrors().isEmpty() && !this.getWarnings().isEmpty();
    }
}

