/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.resource;

import com.google.inject.Inject;
import gama.dev.DEBUG;
import gaml.compiler.gaml.indexer.GamlResourceIndexer;
import gaml.compiler.gaml.resource.GamlResource;
import gaml.compiler.gaml.resource.GamlResourceDescription;
import gaml.compiler.gaml.resource.GamlResourceServices;
import gaml.compiler.gaml.scoping.BuiltinGlobalScopeProvider;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionManager;
import org.eclipse.xtext.util.OnChangeEvictingCache;

public class GamlResourceDescriptionManager
extends DefaultResourceDescriptionManager {
    @Inject
    BuiltinGlobalScopeProvider provider;

    static {
        DEBUG.OFF();
    }

    public IResourceDescription getResourceDescription(Resource resource) {
        IResourceDescription iResourceDescription = super.getResourceDescription(resource);
        if (resource instanceof GamlResource) {
            GamlResource gamlResource = (GamlResource)resource;
            if (iResourceDescription instanceof GamlResourceDescription) {
                return iResourceDescription;
            }
            OnChangeEvictingCache onChangeEvictingCache = (OnChangeEvictingCache)super.getCache();
            onChangeEvictingCache.clear(resource);
            return super.getResourceDescription(resource);
        }
        return iResourceDescription;
    }

    protected IResourceDescription internalGetResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy iDefaultResourceDescriptionStrategy) {
        return new GamlResourceDescription((GamlResource)resource, iDefaultResourceDescriptionStrategy, this.getCache(), this.provider);
    }

    public boolean isAffected(Collection<IResourceDescription.Delta> collection, IResourceDescription iResourceDescription, IResourceDescriptions iResourceDescriptions) {
        URI uRI = GamlResourceServices.properlyEncodedURI(iResourceDescription.getURI());
        Map<URI, String> map = GamlResourceIndexer.allImportsOfProperlyEncoded(uRI);
        if (map.isEmpty()) {
            return false;
        }
        for (IResourceDescription.Delta delta : collection) {
            URI uRI2 = GamlResourceServices.properlyEncodedURI(delta.getUri());
            if (!map.containsKey(uRI2)) continue;
            return true;
        }
        return false;
    }
}

