/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.resource;

import com.google.inject.Singleton;
import gama.core.util.file.GamlFileInfo;
import gama.core.util.file.IGamlResourceInfoProvider;
import gama.dev.DEBUG;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.types.GamaFileType;
import gaml.compiler.gaml.indexer.GamlResourceIndexer;
import gaml.compiler.gaml.resource.GamlResourceServices;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.URI;

@Singleton
public class GamlResourceInfoProvider
implements IGamlResourceInfoProvider {
    public static final Pattern findTags;
    public static final Pattern findPragmas;
    public static final Pattern findStrings;
    public static final Pattern findExperiments;
    public static final GamlResourceInfoProvider INSTANCE;

    static {
        DEBUG.OFF();
        findTags = Pattern.compile("Tags:\\s*(.*)");
        findPragmas = Pattern.compile("^\\s*@([^\\s@]+)");
        findStrings = Pattern.compile("('([^']*)')|(\"([^\"]*)\")");
        findExperiments = Pattern.compile("^\\s*experiment\\s+(?:'([^']*)'|\"([^\"]*)\"|(\\w+))(?:\\s+type:\\s*(\\w+))?(?:\\s+virtual:\\s*(\\w+))?");
        INSTANCE = new GamlResourceInfoProvider();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GamlFileInfo getInfo(URI uRI, long l) {
        LinkedHashSet<String> linkedHashSet = null;
        HashSet<String> hashSet = null;
        LinkedHashSet<Object> linkedHashSet2 = null;
        LinkedHashSet<String> linkedHashSet3 = null;
        for (URI uRI2 : GamlResourceIndexer.directImportsOf(uRI)) {
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet<String>();
            }
            linkedHashSet.add(uRI2.deresolve(uRI).toString());
        }
        try {
            Throwable throwable = null;
            Iterator<URI> iterator = null;
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(GamlResourceServices.getResourceSet().getURIConverter().createInputStream(uRI));
                try {
                    try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                        String string;
                        boolean bl = true;
                        while ((string = bufferedReader.readLine()) != null) {
                            Object object;
                            String string2;
                            Object object2;
                            Object object3;
                            Object object4;
                            Matcher matcher = findTags.matcher(string);
                            if (matcher.find()) {
                                object4 = matcher.group(1);
                                hashSet = new HashSet<String>(Arrays.asList(StringUtils.split((String)StringUtils.uncapitalize((String)StringUtils.deleteWhitespace((String)object4)), (char)',')));
                            }
                            if (((Matcher)(object4 = findPragmas.matcher(string))).find() && "no_experiment".equals(object3 = ((Matcher)object4).group(1))) {
                                bl = false;
                            }
                            object3 = findStrings.matcher(string);
                            while (((Matcher)object3).find()) {
                                object2 = ((Matcher)object3).group();
                                if (((String)object2).length() <= 6 || (string2 = (object = URI.createFileURI((String)(object2 = ((String)object2).substring(1, ((String)object2).length() - 1)))).fileExtension()) == null || string2.isBlank() || "gaml".equals(string2) || !GamaFileType.managesExtension((String)string2)) continue;
                                if (linkedHashSet2 == null) {
                                    linkedHashSet2 = new LinkedHashSet<Object>();
                                }
                                DEBUG.OUT((Object)("===== Considers in uses : " + (String)object2));
                                linkedHashSet2.add(object2);
                            }
                            if (!bl || !((Matcher)(object2 = findExperiments.matcher(string))).find()) continue;
                            object = ((Matcher)object2).group(1);
                            if (object == null) {
                                object = ((Matcher)object2).group(2);
                            }
                            if (object == null) {
                                object = ((Matcher)object2).group(3);
                            }
                            string2 = ((Matcher)object2).group(4);
                            String string3 = ((Matcher)object2).group(5);
                            if (object == null || "true".equals(string3)) continue;
                            if (linkedHashSet3 == null) {
                                linkedHashSet3 = new LinkedHashSet<String>();
                            }
                            if ("batch".equals(string2)) {
                                object = "***" + (String)object;
                            }
                            linkedHashSet3.add((String)object);
                        }
                    }
                    if (inputStreamReader == null) return new GamlFileInfo(l, linkedHashSet, linkedHashSet2, linkedHashSet3, hashSet);
                }
                catch (Throwable throwable2) {
                    void var8_14;
                    if (throwable == null) {
                        Throwable throwable3 = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inputStreamReader == null) throw var8_14;
                    inputStreamReader.close();
                    throw var8_14;
                }
                inputStreamReader.close();
                return new GamlFileInfo(l, linkedHashSet, linkedHashSet2, linkedHashSet3, hashSet);
            }
            catch (Throwable throwable4) {
                void var8_16;
                if (throwable == null) {
                    Throwable throwable5 = throwable4;
                    throw var8_16;
                } else {
                    if (throwable == throwable4) throw var8_16;
                    throwable.addSuppressed(throwable4);
                }
                throw var8_16;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return new GamlFileInfo(l, linkedHashSet, linkedHashSet2, linkedHashSet3, hashSet);
    }

    public ISyntacticElement getContents(URI uRI) {
        return GamlResourceServices.getOrCreateSyntacticContents(uRI);
    }
}

