/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.validation;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.descriptions.ValidationContext;
import gaml.compiler.gaml.ExperimentFileStructure;
import gaml.compiler.gaml.GamlDefinition;
import gaml.compiler.gaml.GamlPackage;
import gaml.compiler.gaml.HeadlessExperiment;
import gaml.compiler.gaml.Import;
import gaml.compiler.gaml.Model;
import gaml.compiler.gaml.Statement;
import gaml.compiler.gaml.impl.StatementImpl;
import gaml.compiler.gaml.resource.GamlResource;
import gaml.compiler.gaml.resource.GamlResourceServices;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.util.Arrays;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

@Singleton
public class ErrorToDiagnoticTranslator {
    @Inject
    public ErrorToDiagnoticTranslator() {
    }

    public Diagnostic translate(ValidationContext validationContext, GamlResource gamlResource, CheckMode checkMode) {
        BasicDiagnostic basicDiagnostic = new BasicDiagnostic();
        for (GamlCompilationError gamlCompilationError : validationContext) {
            Diagnostic diagnostic = this.translate(gamlCompilationError, gamlResource, checkMode);
            if (diagnostic == null) continue;
            basicDiagnostic.add(diagnostic);
        }
        return basicDiagnostic;
    }

    public Diagnostic translate(GamlCompilationError gamlCompilationError, GamlResource gamlResource, CheckMode checkMode) {
        URI uRI = gamlCompilationError.getURI();
        if (!GamlResourceServices.equals(uRI, gamlResource.getURI())) {
            String string = URI.decode((String)uRI.lastSegment());
            EObject eObject = (EObject)gamlResource.getContents().get(0);
            EObject eObject2 = this.findImportWith(eObject, string);
            EAttribute eAttribute = eObject2 instanceof Model ? GamlPackage.Literals.GAML_DEFINITION__NAME : (eObject2 instanceof HeadlessExperiment ? GamlPackage.Literals.HEADLESS_EXPERIMENT__IMPORT_URI : GamlPackage.Literals.IMPORT__IMPORT_URI);
            return this.createDiagnostic(CheckMode.NORMAL_ONLY, 4, gamlCompilationError.toString() + " (imported from " + string + ")", eObject2, (EStructuralFeature)eAttribute, -1, gamlCompilationError.getCode(), gamlCompilationError.getData());
        }
        EAttribute eAttribute = null;
        EObject eObject = gamlCompilationError.getStatement();
        String[] stringArray = gamlCompilationError.getData();
        if (eObject instanceof GamlDefinition && stringArray != null && stringArray.length > 0 && "name".equals(stringArray[0])) {
            eAttribute = GamlPackage.Literals.GAML_DEFINITION__NAME;
        } else if (eObject instanceof Statement) {
            StatementImpl statementImpl = (StatementImpl)eObject;
            if (statementImpl.eIsSet((EStructuralFeature)GamlPackage.Literals.STATEMENT__KEY)) {
                eAttribute = GamlPackage.Literals.STATEMENT__KEY;
            } else if (statementImpl.eIsSet((EStructuralFeature)GamlPackage.Literals.SDEFINITION__TKEY)) {
                eAttribute = GamlPackage.Literals.SDEFINITION__TKEY;
            }
        } else if (eObject instanceof Model) {
            eAttribute = GamlPackage.Literals.GAML_DEFINITION__NAME;
        }
        if (!Arrays.contains((Object[])gamlCompilationError.getData(), null)) {
            return this.createDiagnostic(checkMode, this.toDiagnosticSeverity(gamlCompilationError), gamlCompilationError.toString(), eObject, (EStructuralFeature)eAttribute, -1, gamlCompilationError.getCode(), gamlCompilationError.getData());
        }
        return null;
    }

    private Diagnostic createDiagnostic(CheckMode checkMode, int n, String string, EObject eObject, EStructuralFeature eStructuralFeature, int n2, String string2, String ... stringArray) {
        FeatureBasedDiagnostic featureBasedDiagnostic = new FeatureBasedDiagnostic(n, string, eObject, eStructuralFeature, n2, this.getType(checkMode), string2, stringArray);
        return featureBasedDiagnostic;
    }

    private CheckType getType(CheckMode checkMode) {
        if (checkMode == CheckMode.FAST_ONLY) {
            return CheckType.FAST;
        }
        if (checkMode == CheckMode.EXPENSIVE_ONLY) {
            return CheckType.EXPENSIVE;
        }
        if (checkMode == CheckMode.ALL || checkMode == CheckMode.NORMAL_AND_FAST || checkMode != CheckMode.NORMAL_ONLY) {
            return CheckType.FAST;
        }
        return CheckType.NORMAL;
    }

    protected int toDiagnosticSeverity(GamlCompilationError gamlCompilationError) {
        int n = -1;
        if (gamlCompilationError.isError()) {
            n = 4;
        } else if (gamlCompilationError.isWarning()) {
            n = 2;
        } else if (gamlCompilationError.isInfo()) {
            n = 1;
        }
        return n;
    }

    private EObject findImportWith(EObject eObject, String string) {
        if (eObject instanceof Model) {
            for (Import import_ : ((Model)eObject).getImports()) {
                if (!import_.getImportURI().endsWith(string)) continue;
                return import_;
            }
        } else if (eObject instanceof ExperimentFileStructure) {
            return ((ExperimentFileStructure)eObject).getExp();
        }
        return eObject;
    }
}

