/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.validation;

import com.google.inject.Inject;
import gama.dev.DEBUG;
import gaml.compiler.gaml.resource.GamlResource;
import gaml.compiler.gaml.resource.GamlResourceServices;
import gaml.compiler.gaml.validation.ErrorToDiagnoticTranslator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IDiagnosticConverter;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class GamlResourceValidator
implements IResourceValidator {
    static long VALIDATION_DURATION = 0L;
    @Inject
    IDiagnosticConverter converter;
    private static ErrorToDiagnoticTranslator errorTranslator;

    static {
        DEBUG.OFF();
        errorTranslator = new ErrorToDiagnoticTranslator();
    }

    public static void RESET() {
        VALIDATION_DURATION = 0L;
    }

    public static long DURATION() {
        return VALIDATION_DURATION;
    }

    public List<Issue> validate(Resource resource, CheckMode checkMode, CancelIndicator cancelIndicator) {
        String string = URI.decode((String)resource.getURI().lastSegment());
        ArrayList<Issue> arrayList = new ArrayList<Issue>();
        DEBUG.TIMER((String)"COMPIL", (String)string, (String)"in", () -> {
            GamlResource gamlResource2;
            IAcceptor iAcceptor = issue -> {
                if (issue.getMessage() != null && !issue.getMessage().isEmpty()) {
                    arrayList.add((Issue)issue);
                }
            };
            EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)cancelIndicator);
            for (GamlResource gamlResource2 : resource.getErrors()) {
                this.converter.convertResourceDiagnostic((Resource.Diagnostic)gamlResource2, Severity.ERROR, iAcceptor);
            }
            gamlResource2 = (GamlResource)resource;
            gamlResource2.validate();
            for (Iterator iterator : errorTranslator.translate(gamlResource2.getValidationContext(), gamlResource2, checkMode).getChildren()) {
                this.converter.convertValidatorDiagnostic((Diagnostic)iterator, iAcceptor);
            }
            GamlResourceServices.discardValidationContext(gamlResource2);
        }, (Consumer[])new Consumer[]{l -> {
            long l2 = VALIDATION_DURATION = VALIDATION_DURATION + l;
        }});
        return arrayList;
    }
}

