/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.gaml.documentation;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;

public class GamlResourceDocumentationTask {
    ConcurrentLinkedQueue<Runnable> queue;
    final Job job;
    final String name;
    int currentGeneration;
    Set<URI> objects = new HashSet<URI>();

    public GamlResourceDocumentationTask(URI uRI) {
        this.incrementGeneration();
        this.name = uRI == null ? "unknown" : uRI.lastSegment();
        this.job = new Job("Documentation of " + this.name){
            {
                this.setUser(false);
                this.setPriority(20);
            }

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Runnable runnable = GamlResourceDocumentationTask.this.queue.poll();
                while (runnable != null) {
                    runnable.run();
                    runnable = GamlResourceDocumentationTask.this.queue.poll();
                }
                return Status.OK_STATUS;
            }
        };
    }

    public void incrementGeneration() {
        ++this.currentGeneration;
        this.queue = new ConcurrentLinkedQueue();
    }

    public void add(Runnable runnable) {
        this.queue.offer(runnable);
        this.job.schedule(50L);
    }
}

